/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest.mq;

import java.security.SecureRandom;
import java.util.Random;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.support.MessageSerde;
import kd.bos.rocketmq.RocketInfo;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;

public class RocketMqSpeedTest
implements SpeedTest {
    private static Random random = new SecureRandom();
    private MQProducer producer;
    private String queueName;
    private String serverKey;
    private RocketInfo rocketInfo;

    public RocketMqSpeedTest(MQProducer producer, String queueName, String region, String serverKey, RocketInfo rocketInfo) {
        this.producer = producer;
        this.queueName = queueName;
        this.serverKey = serverKey;
        this.rocketInfo = rocketInfo;
    }

    @Override
    public void doTest() {
        try {
            kd.bos.mq.support.Message message = this.toMessage("rocketmq speed test");
            byte[] bytes = MessageSerde.get().encode(message);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName((String)this.rocketInfo.getVhost(), (String)this.queueName);
            Message rocketMessage = new Message(groupAndTopicName, "*", bytes);
            this.producer.send(rocketMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Mq";
    }

    @Override
    public String getUrl() {
        return "MqServerKey:" + this.serverKey + "," + this.rocketInfo.getHost();
    }

    @Override
    public String getDes() {
        return "RocketMq publish message to the demo queue";
    }

    private kd.bos.mq.support.Message toMessage(Object body) {
        kd.bos.mq.support.Message message = new kd.bos.mq.support.Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(random.nextLong());
        return message;
    }
}

