/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import kd.bos.ksql.shell.KDDriverUtil;
import kd.bos.monitor.testspeed.DetailSpeedItem;
import kd.bos.monitor.testspeed.SpeedTest;

public class KDConnectionSpeedTest
implements SpeedTest {
    private String url;
    private String user;
    private String lastDetailTestInfo = "";
    Properties p = new Properties();

    public KDConnectionSpeedTest(String url, String user) {
        this.url = url;
        this.user = user;
    }

    @Override
    public void doTest() {
        try {
            this.p.setProperty("user", this.user);
            ArrayList<DetailSpeedItem> ls = new ArrayList<DetailSpeedItem>(2);
            long l = System.currentTimeMillis();
            try (Connection con = KDDriverUtil.connect((String)this.url, (Properties)this.p);){
                ls.add(new DetailSpeedItem("getConnection", System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                try (PreparedStatement st = con.prepareStatement("select 1");){
                    ls.add(new DetailSpeedItem("prepareStatement", System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                    try (ResultSet rs = st.executeQuery();){
                        if (rs.next()) {
                            rs.getString(1);
                        }
                        ls.add(new DetailSpeedItem("executeQuery", System.currentTimeMillis() - l));
                        l = System.currentTimeMillis();
                    }
                }
            }
            ls.add(new DetailSpeedItem("closeCon", System.currentTimeMillis() - l));
            this.lastDetailTestInfo = ((Object)ls).toString();
        }
        catch (Exception e) {
            this.lastDetailTestInfo = "hasException";
            return;
        }
    }

    @Override
    public String getName() {
        String name = this.url.substring(this.url.indexOf(":jdbc:") + 6);
        if (name.startsWith("oracle")) {
            return name.split("\\?")[0] + "$" + this.user;
        }
        return name.split("\\?")[0];
    }

    @Override
    public String getDes() {
        return "test connection";
    }

    @Override
    public String getLastDetailTestInfo() {
        return this.lastDetailTestInfo;
    }

    public void setPassword(String password) {
        this.p.setProperty("password", password);
    }
}

