/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed;

import java.util.ArrayList;
import kd.bos.instance.Instance;
import kd.bos.monitor.testspeed.DetailSpeedItem;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class RedisSpeedTest
implements SpeedTest {
    private String url;
    private String lastDetailTestInfo = "";
    private static final String SPEED_TEST = "speedtest-k-";

    public RedisSpeedTest(String url) {
        this.url = url;
    }

    @Override
    public void doTest() {
        ArrayList<DetailSpeedItem> ls = new ArrayList<DetailSpeedItem>(2);
        long l = System.currentTimeMillis();
        try (JedisClient client = RedisFactory.getJedisClient((String)this.url);){
            ls.add(new DetailSpeedItem("getJedisClient", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            client.set(SPEED_TEST + Instance.getInstanceId(), "speedtest-v-" + Instance.getInstanceId());
            ls.add(new DetailSpeedItem("set", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            client.get(SPEED_TEST + Instance.getInstanceId());
            ls.add(new DetailSpeedItem("get", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            client.del(SPEED_TEST + Instance.getInstanceId());
            ls.add(new DetailSpeedItem("del", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
        }
        catch (Exception e) {
            return;
        }
        ls.add(new DetailSpeedItem("closeJedisClient", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        this.lastDetailTestInfo = ((Object)ls).toString();
    }

    @Override
    public String getName() {
        return this.url;
    }

    @Override
    public String getDes() {
        return "redis (set/get/del)";
    }

    @Override
    public String getLastDetailTestInfo() {
        return this.lastDetailTestInfo;
    }
}

