/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.mq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.Map;
import kd.bos.context.OperationContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.mq.support.QueueManager;

public class RabbitMqSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(RabbitMqSpeedTest.class);
    private String k;
    private Map<String, Connection> poolmap;

    public RabbitMqSpeedTest(String k, Map<String, Connection> poolmap) {
        this.k = k;
        this.poolmap = poolmap;
    }

    @Override
    public void doTest() {
        try {
            OperationContextCreator.getOrCreateForBos();
            String quueuName = QueueManager.getRealQueueName((String)"demo", (String)"demo_queue");
            Channel channel = this.poolmap.get(this.k).createChannel();
            channel.basicPublish("", quueuName, null, "speed test".getBytes());
            channel.close();
        }
        catch (Exception e) {
            logger.error("test rabbit connect exception", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "MqServerKey:" + this.k + "," + this.poolmap.get(this.k).getAddress() + ":" + this.poolmap.get(this.k).getPort();
    }

    @Override
    public String getDes() {
        return "publish message to the demo queue";
    }
}

