/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.serviceindicator;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class CompletableUtils {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("failAfter-%d");
        thread.setDaemon(true);
        return thread;
    });

    private static <T> CompletableFuture<T> failAfter(Duration duration) {
        CompletableFuture promise = new CompletableFuture();
        scheduler.schedule(() -> {
            TimeoutException ex = new TimeoutException("timeout after " + duration.getSeconds() + "s");
            return promise.completeExceptionally(ex);
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public static Object runAsyc(Runnable runner, int timeSecond) throws InterruptedException, ExecutionException {
        Supplier<Long> supplier = () -> {
            long time = System.currentTimeMillis();
            runner.run();
            return System.currentTimeMillis() - time;
        };
        CompletableFuture<Long> taskFuture = CompletableFuture.supplyAsync(supplier);
        CompletionStage timeoutFuture = CompletableUtils.failAfter(Duration.ofSeconds(timeSecond)).exceptionally(xxx -> xxx);
        return CompletableFuture.anyOf(new CompletableFuture[]{taskFuture, timeoutFuture}).get();
    }
}

