/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.serviceindicator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.action.Action;
import kd.bos.mservice.monitor.action.ActionFactory;
import kd.bos.mservice.monitor.action.ActionParam;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;

public class RabbitMqChannelIndicator
implements Indicator,
IndicatorConfigurable {
    private ItemConfig config = new ItemConfig();

    public HealthLevel getHealthLevel() {
        int count = this.getNullChannelCount();
        if (count > this.config.maxTryCount) {
            return HealthLevel.ERROR;
        }
        if (count > 0) {
            return HealthLevel.BUSY;
        }
        return HealthLevel.NORMAL;
    }

    private int getNullChannelCount() {
        try {
            return ChannelFactory.getChannnelNullCount();
        }
        catch (Error | Exception e) {
            return 0;
        }
    }

    public String getName() {
        return "rabbitmqchannel";
    }

    public String getDesc() {
        return this.getName() + ":" + kd.bos.eye.enterprise.LangRes.get("RabbitMqIndicator_1", "The current node is obtaining Rabbitmq channels. When there are no available channels, the node is busy or in an abnormal state.", new Object[0]);
    }

    public String getHealthDetail() {
        return "rabbit mq channel get null times: " + this.getNullChannelCount();
    }

    public void touch() {
    }

    public boolean canResponse() {
        return this.getNullChannelCount() == 0;
    }

    public boolean isOnlyMservice() {
        return false;
    }

    public boolean $configEnable() {
        return this.config.isEnable();
    }

    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    public List<Action> actionsWhenExceptions() {
        ArrayList<Action> ls = new ArrayList<Action>(2);
        int leve = this.getHealthLevel().getLevel();
        ls.add(ActionFactory.getExcutor((String)"pause").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withLevel(leve)));
        if (this.config.autoRestart) {
            ls.add(ActionFactory.getExcutor((String)"restart").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withWaitSeconds(this.config.restartAfterSeconds).withLevel(leve)));
        }
        return ls;
    }

    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("stack");
        return s;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private boolean autoRestart = false;
        private int restartAfterSeconds = 120;
        private int maxTryCount = 20;

        private ItemConfig() {
        }

        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("autoRestart").withDefaultValue((Object)false).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "RabbitMqIndicator_2", "Automatic restart on exception"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("restartAfterSeconds").withDefaultValue((Object)120).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "RabbitMqIndicator_3", "Restart delay (ms)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
            ConfigItemMeta overloadMaxValueFiledMeta = new ConfigItemMeta("maxTryCount").withDefaultValue((Object)20).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "RabbitMqIndicator_4", "Exception count threshold"));
            this.initInfosMap.put(overloadMaxValueFiledMeta.getFiledName(), overloadMaxValueFiledMeta);
        }
    }
}

