/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.serviceindicator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.instance.Instance;
import kd.bos.monitor.testspeed.serviceindicator.AbstractIndicator;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.action.Action;
import kd.bos.mservice.monitor.action.ActionFactory;
import kd.bos.mservice.monitor.action.ActionParam;
import kd.bos.mservice.monitor.assistant.RedisAssistDiagnose;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.lang.LangSupplier;
import kd.bos.util.EnvUtils;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisIndicator
extends AbstractIndicator
implements IndicatorConfigurable {
    private DistributeSessionlessCache dcache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private String cacheUrl = null;
    private RedisAssistDiagnose assist = RedisAssistDiagnose.getInstance();
    private ItemConfig config = new ItemConfig();
    private static final String redisKey = "redishealthtest_" + Instance.getAppName() + "_" + Instance.getInstanceId();

    public HealthLevel getHealthLevel() {
        if (this.getTestException() != null) {
            this.assist.setException(this.getTestException());
            return this.isError() ? HealthLevel.ERROR : HealthLevel.OVERLOAD;
        }
        this.assist.setException(null);
        if (this.count.get() > 3) {
            this.assist.setHealthDetail(this.getHealthDetail());
            return HealthLevel.OVERLOAD;
        }
        int avgMs = this.getAvgMs();
        if (avgMs <= this.config.normalMaxValue) {
            return HealthLevel.NORMAL;
        }
        if (avgMs <= this.config.busyMaxValue) {
            return HealthLevel.BUSY;
        }
        if (avgMs <= this.config.overloadMaxValue) {
            if (this.getOverTimeCount(this.config.overloadMaxValue) > 2) {
                this.assist.setHealthDetail(this.getTestTime());
                return HealthLevel.OVERLOAD;
            }
            return HealthLevel.BUSY;
        }
        if (this.getOverTimeCount(this.config.overloadMaxValue) > 2) {
            this.assist.setHealthDetail(this.getTestTime());
            return HealthLevel.OVERLOAD;
        }
        return HealthLevel.BUSY;
    }

    public String getName() {
        return "redis";
    }

    public String getDesc() {
        return this.getName() + ":" + LangRes.get("RedisIndicator_1", "Current node access time to Redis. When it exceeds the threshold, the node is busy or overloaded.", new Object[0]);
    }

    @Override
    public void doTest() {
        this.dcache.remove(redisKey);
        this.dcache.put(redisKey, (Object)Instance.getInstanceId(), 60);
        this.dcache.get(redisKey);
    }

    @Override
    protected boolean checkException(Exception e) {
        if ("true".equals(System.getProperty("bos.redis.indicator.errorcanrecover", "true"))) {
            return false;
        }
        ErrorCode code = ((KDException)e).getErrorCode();
        String msg = e.getMessage();
        boolean isError = (!(e instanceof KDException) || !BosErrorCode.redisNotAvailable.equals((Object)code) && !BosErrorCode.redisConnection.equals((Object)code) && (msg == null || msg.indexOf("LOADING Redis is loading") < 0 && msg.indexOf("READONLY") <= 0)) && !(e.getCause() instanceof JedisConnectionException) && !(e.getCause() instanceof JedisClusterException);
        return isError;
    }

    public boolean isOnlyMservice() {
        return false;
    }

    public String getHealthDetail() {
        if (this.count.get() > 3) {
            return "over 3 times speedTest not response";
        }
        Throwable th = this.getTestException();
        return "avg access time(ms): " + this.getAvgMs() + (th == null ? "" : this.getRedisUrl() + "," + th.getMessage());
    }

    private String getRedisUrl() {
        if (this.cacheUrl != null) {
            return this.cacheUrl;
        }
        String url = System.getProperty(CacheConfigKeys.getSessionlessConfigKey(null), "");
        int index = url.indexOf(47);
        this.cacheUrl = index > 0 ? url.substring(0, index) : url;
        return this.cacheUrl;
    }

    public boolean $configEnable() {
        return this.config.isEnable();
    }

    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("redisAssist");
        s.add("backendthreadstack");
        return s;
    }

    public List<Action> actionsWhenExceptions() {
        ArrayList<Action> ls = new ArrayList<Action>(2);
        int leve = this.getHealthLevel().getLevel();
        ls.add(ActionFactory.getExcutor((String)"pause").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withLevel(leve)));
        if (this.config.autoRestart) {
            ls.add(ActionFactory.getExcutor((String)"restart").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withWaitSeconds(this.config.restartAfterSeconds).withLevel(leve)));
        }
        return ls;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private int normalMaxValue = 50;
        private int busyMaxValue = 100;
        private int overloadMaxValue = 1000;
        private boolean autoRestart = EnvUtils.isRunningInsideContainer();
        private int restartAfterSeconds = 60;

        private ItemConfig() {
        }

        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue((Object)50).withDisplayLabelName(new LangSupplier(kd.bos.mservice.monitor.lang.LangRes.eyeapienterprise, "RedisIndicator_2", "Normal maximum threshold (ms)"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue((Object)100).withDisplayLabelName(new LangSupplier(kd.bos.mservice.monitor.lang.LangRes.eyeapienterprise, "RedisIndicator_3", "Busy maximum threshold (ms)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
            ConfigItemMeta overloadMaxValueFiledMeta = new ConfigItemMeta("overloadMaxValue").withDefaultValue((Object)1000).withDisplayLabelName(new LangSupplier(kd.bos.mservice.monitor.lang.LangRes.eyeapienterprise, "RedisIndicator_4", "Overloaded maximum threshold (ms)"));
            this.initInfosMap.put(overloadMaxValueFiledMeta.getFiledName(), overloadMaxValueFiledMeta);
            ConfigItemMeta autoRestartFiledMeta = new ConfigItemMeta("autoRestart").withDefaultValue((Object)EnvUtils.isRunningInsideContainer()).withDisplayLabelName(new LangSupplier(kd.bos.mservice.monitor.lang.LangRes.eyeapienterprise, "RedisIndicator_5", "Automatic restart on exception"));
            this.initInfosMap.put(autoRestartFiledMeta.getFiledName(), autoRestartFiledMeta);
            ConfigItemMeta restartAfterSecondsFiledMeta = new ConfigItemMeta("restartAfterSeconds").withDefaultValue((Object)60).withDisplayLabelName(new LangSupplier(kd.bos.mservice.monitor.lang.LangRes.eyeapienterprise, "RedisIndicator_6", "Restart delay (s)"));
            this.initInfosMap.put(restartAfterSecondsFiledMeta.getFiledName(), restartAfterSecondsFiledMeta);
        }
    }
}

