/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom;

import java.io.Serializable;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.ksql.visitor.ASTVisitor;

public class SqlJoinedTableSource
extends SqlTableSourceBase
implements Serializable {
    private static final long serialVersionUID = 1775634703603447149L;
    public SqlTableSourceBase left;
    public SqlTableSourceBase right;
    public SqlExpr condition;
    public int joinType;
    private String joinWord;
    private String onWord;

    public SqlJoinedTableSource() {
    }

    public SqlJoinedTableSource(SqlTableSourceBase left, SqlTableSourceBase right, int joinType, SqlExpr condition) {
        this.left = left;
        this.right = right;
        this.condition = condition;
        this.joinType = joinType;
        this.setOnWord("ON");
        switch (this.joinType) {
            case 4: {
                this.setJoinWord(",");
                break;
            }
            case 3: {
                this.setJoinWord("FULL OUTER JOIN");
                break;
            }
            case 0: {
                this.setJoinWord("INNER JOIN");
                break;
            }
            case 1: {
                this.setJoinWord("LEFT OUTER JOIN");
                break;
            }
            case 2: {
                this.setJoinWord("RIGHT OUTER JOIN");
                break;
            }
            default: {
                this.setJoinWord("");
            }
        }
    }

    public SqlJoinedTableSource(SqlTableSourceBase left, SqlTableSourceBase right, int joinType, SqlExpr condition, String joinWord, String onWord) {
        this.left = left;
        this.right = right;
        this.condition = condition;
        this.joinType = joinType;
        this.setOnWord(onWord);
        this.setJoinWord(joinWord);
    }

    @Override
    public Object clone() {
        SqlJoinedTableSource new_object = new SqlJoinedTableSource();
        if (this.left != null) {
            if (this.left instanceof SqlJoinedTableSource) {
                new_object.left = (SqlJoinedTableSource)this.left.clone();
            } else if (this.left instanceof SqlTableSource) {
                new_object.left = (SqlTableSource)this.left.clone();
            } else {
                throw new NotSupportedException("unexcept TableSource:" + this.left);
            }
        }
        if (this.right != null) {
            if (this.right instanceof SqlJoinedTableSource) {
                new_object.right = (SqlJoinedTableSource)this.right.clone();
            } else if (this.right instanceof SqlTableSource) {
                new_object.right = (SqlTableSource)this.right.clone();
            } else {
                throw new NotSupportedException("unexcept TableSource:" + this.right);
            }
        }
        if (this.condition != null) {
            new_object.condition = (SqlExpr)this.condition.clone();
        }
        new_object.joinType = this.joinType;
        new_object.setOrgAlias(this.getOrgAlias());
        new_object.setJoinWord(this.getJoinWord());
        new_object.setOnWord(this.getOnWord());
        return new_object;
    }

    public String getJoinWord() {
        if (this.joinWord == null) {
            switch (this.joinType) {
                case 4: {
                    this.setJoinWord(",");
                    break;
                }
                case 3: {
                    this.setJoinWord("FULL OUTER JOIN");
                    break;
                }
                case 0: {
                    this.setJoinWord("INNER JOIN");
                    break;
                }
                case 1: {
                    this.setJoinWord("LEFT OUTER JOIN");
                    break;
                }
                case 2: {
                    this.setJoinWord("RIGHT OUTER JOIN");
                    break;
                }
                default: {
                    this.setJoinWord("");
                }
            }
        }
        return this.joinWord;
    }

    public void setJoinWord(String joinWord) {
        this.joinWord = joinWord;
    }

    public String getOnWord() {
        if (this.onWord == null || this.onWord.trim().length() == 0) {
            return "ON";
        }
        return this.onWord;
    }

    public void setOnWord(String onWord) {
        this.onWord = onWord;
    }

    @Override
    protected void collectChildren() {
        this.addChild(this.left);
        this.addChild(this.right);
        this.addChild(this.condition);
    }

    @Override
    public <T> T accept(ASTVisitor<? extends T> visitor) {
        return visitor.visitSqlJoinedTableSource(this);
    }
}

