/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom.expr;

import java.io.Serializable;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.visitor.ASTVisitor;

public class SqlBinaryOpExpr
extends SqlExpr
implements Serializable {
    private static final long serialVersionUID = 4202490669974809694L;
    public SqlExpr left;
    public SqlExpr right;
    public int operator;

    public SqlBinaryOpExpr() {
        super(0);
    }

    public SqlBinaryOpExpr(SqlExpr left, int operator, SqlExpr right) {
        super(0);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public String getExprWord() {
        String str = super.getExprWord();
        if (str == null || str.length() == 0) {
            switch (this.operator) {
                case 7: {
                    str = "AND";
                    break;
                }
                case 8: {
                    str = "OR";
                    break;
                }
                case 18: {
                    str = "LIKE";
                    break;
                }
                case 44: {
                    str = "MATCH";
                    break;
                }
                case 13: {
                    str = "IS";
                    break;
                }
                case 41: {
                    str = "IS NOT";
                    break;
                }
                case 43: {
                    str = "ESCAPE";
                    break;
                }
                case 27: {
                    str = "UNION";
                    break;
                }
                case 1: {
                    str = "AS";
                    break;
                }
                case 40: {
                    str = "NOT LIKE";
                    break;
                }
            }
        }
        return str;
    }

    @Override
    public Object clone() {
        SqlBinaryOpExpr new_obj = new SqlBinaryOpExpr();
        if (this.left != null) {
            new_obj.left = (SqlExpr)this.left.clone();
        }
        if (this.right != null) {
            new_obj.right = (SqlExpr)this.right.clone();
        }
        new_obj.operator = this.operator;
        return new_obj;
    }

    @Override
    protected void collectChildren() {
        this.addChild(this.left);
        this.addChild(this.right);
    }

    @Override
    public <T> T accept(ASTVisitor<? extends T> visitor) {
        return visitor.visitSqlBinaryOpExpr(this);
    }
}

