/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom.expr;

import java.io.Serializable;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.visitor.ASTVisitor;

public class SqlCharExpr
extends SqlExpr
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8873119992791788170L;
    public String text;

    public SqlCharExpr() {
        super(5);
    }

    public SqlCharExpr(String text) {
        super(5);
        if (text == null) {
            throw new IllegalArgumentException("text");
        }
        this.text = text;
    }

    public String getJavaString() {
        return SqlCharExpr.getJavaString(this.text);
    }

    public static String getJavaString(String char_expr_value) {
        if (char_expr_value == null) {
            return "NULL";
        }
        StringBuilder buff = new StringBuilder();
        int length = char_expr_value.length();
        for (int i = 0; i < length; ++i) {
            char c = char_expr_value.charAt(i);
            if (c == '\'' && i != length - 1 && char_expr_value.charAt(i + 1) == '\'') continue;
            buff.append(c);
        }
        return buff.toString();
    }

    @Override
    public void output(StringBuilder buff) {
        buff.append(this.getJavaString());
    }

    @Override
    public Object clone() {
        return new SqlCharExpr(this.text);
    }

    @Override
    public <T> T accept(ASTVisitor<? extends T> visitor) {
        return visitor.visitSqlCharExpr(this);
    }
}

