/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.extension;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kd.bos.extension.ExtensionFactory;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.extension.KSQLExtensions;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.shell.KDConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSQLExtensionsRegister {
    private static final Logger logger = LoggerFactory.getLogger(KSQLExtensionsRegister.class);
    private static ExtensionFactory<KSQLExtensions> extensionFactory = ExtensionFactory.getExtensionFacotry(KSQLExtensions.class);

    private KSQLExtensionsRegister() {
    }

    private static KSQLExtensions getExtension() {
        try {
            return (KSQLExtensions)extensionFactory.getExtension(System.getProperty("ksql.extension.type", "bos"));
        }
        catch (Error | Exception e) {
            logger.error("KSQLExtensionsRegister init extension implement fail: " + e.getMessage(), e);
            e.printStackTrace();
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.exit(-1);
            return null;
        }
    }

    public static String handleKSQLBeforeTrans(String ksql) throws SqlTranslateException {
        return KSQLExtensionsRegister.getExtension().handleKSQLBeforeTrans(ksql);
    }

    public static String handleKSQLAfterTrans(String ksql) throws SqlTranslateException {
        return KSQLExtensionsRegister.getExtension().handleKSQLAfterTrans(ksql);
    }

    public static SQLFormater getPostgreSQLFormater() throws SqlTranslateException {
        String formatClassName = KSQLExtensionsRegister.getExtension().getExtensionSQLFormaterClassName();
        try {
            Class<?> aClass = Class.forName(formatClassName);
            return (SQLFormater)aClass.newInstance();
        }
        catch (Exception e) {
            throw new SqlTranslateException("KSQLExtensionsRegister getPostgreSQLFormater error:" + e.getMessage());
        }
    }

    public static List<SqlStmt> handleStmtsAfterParser(List<SqlStmt> stmtCol) throws SqlTranslateException {
        return KSQLExtensionsRegister.getExtension().handleStmtCollectionsAfterParser(stmtCol);
    }

    public static Connection handleDelegateConnectionAfterInit(Connection connection) {
        return KSQLExtensionsRegister.getExtension().handleDelegateConnectionAfterInit(connection);
    }

    public static Connection handleLoginConnectionAfterInit(Connection connection) {
        return KSQLExtensionsRegister.getExtension().handleLoginConnectionAfterInit(connection);
    }

    public static Statement extendKDStatement(Statement stmt, KDConnection kdConnection) {
        return KSQLExtensionsRegister.getExtension().extendStatement(stmt, kdConnection);
    }

    public static PreparedStatement extendPreparedStatement(PreparedStatement preparedStatement, KDConnection kdConnection, String kSql, String dialectSql, FormaterContext formaterContext) throws SQLException {
        return KSQLExtensionsRegister.getExtension().extendPreparedStatement(preparedStatement, kdConnection, kSql, dialectSql, formaterContext);
    }
}

