/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import kd.bos.ksql.KSqlUtil;
import kd.bos.ksql.datatype.DataType;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.KHints;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlAllColumnExpr;
import kd.bos.ksql.dom.expr.SqlAllExpr;
import kd.bos.ksql.dom.expr.SqlAnyExpr;
import kd.bos.ksql.dom.expr.SqlBetweenExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCaseExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlIdentityExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNotExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlSomeExpr;
import kd.bos.ksql.dom.expr.SqlVarRefExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlTrancateTableStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public class DB2SQLFormater
extends SQLFormater {
    public DB2SQLFormater() {
        this(null);
    }

    public DB2SQLFormater(StringBuilder sb) {
        super(sb);
        this.max_length_of_index_name = 128;
        this.max_length_of_constraint_name = 18;
        this.max_length_of_column_name = 30;
        this.max_length_of_column_count = 255;
        this.max_length_of_row_size = -1;
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        this.buffer.append("SELECT NAME, CREATOR, CTIME, REMARKS, PACKED_DESC, COLCOUNT ").append("FROM ").append(this.sysSchema()).append(".SYSTABLES WHERE TYPE = 'T' AND CREATOR != '").append(this.sysSchema()).append("' ORDER BY NAME");
    }

    private String getReorgTable() {
        return (String)this.context.get("ReorgTable");
    }

    private void setReorgTable(String table) {
        if (KSqlUtil.isAutoReorgWhenAlterTableInDB2()) {
            this.context.put("ReorgTable", table);
        }
    }

    private void clearReorgTable() {
        this.context.remove("ReorgTable");
    }

    @Override
    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        boolean hasRowNum = false;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        this.buffer.append(this.formatTableName(insert.tableName));
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                Object colItem;
                if (flag) {
                    this.buffer.append(", ");
                }
                if ((colItem = iterator.next()) instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    this.buffer.append(identExpr.value);
                } else if (colItem instanceof String) {
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = true;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery, hasRowNum);
        }
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "SELECT NAME AS COLUMN_NAME, TYPENAME AS DATA_TYPE, LENGTH AS DEFAULT_LENGTH,-1 DATA_PRECISION, SCALE DATA_SCALE, NULLS, TBNAME TABLE_NAME FROM " + this.sysSchema() + ".SYSCOLUMNS ";
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            sql = sql + "WHERE TBNAME = UCASE('" + stmt.tableName + "') ";
        }
        sql = sql + " ORDER BY COLNO";
        this.buffer.append(sql);
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        this.buffer.append("EXEC ");
        this.buffer.append(stmt.processName);
        if (stmt.paramList.size() != 0) {
            this.buffer.append(" ");
            boolean flag = false;
            Iterator iter = stmt.paramList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iter.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
    }

    @Override
    protected String getIndexName(SqlDropIndexStmt stmt) {
        if (stmt.tableName != null && stmt.tableName.startsWith("GZT")) {
            return "session." + stmt.indexName;
        }
        return stmt.indexName;
    }

    protected void formatAlterTableStmtOld(SqlAlterTableStmt stmt, boolean useProcedure) throws FormaterException {
        if (stmt.item instanceof SqlAlterTableDropItem) {
            Iterator dropConstraintIterator;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            Iterator dropColumnIterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean isDropColumn = dropColumnIterator.hasNext();
            if (useProcedure) {
                boolean flag = false;
                StringBuilder columns = new StringBuilder();
                while (dropColumnIterator.hasNext()) {
                    if (!flag) {
                        this.buffer.append("CALL drop_column('").append(stmt.tableName).append("', '");
                        flag = true;
                    }
                    columns.append(",").append(dropColumnIterator.next());
                }
                if (flag) {
                    this.buffer.append(columns.substring(1)).append("')");
                    return;
                }
            } else if (dropColumnIterator.hasNext()) {
                this.buffer.append("ALTER TABLE ");
                this.buffer.append(stmt.tableName);
                while (dropColumnIterator.hasNext()) {
                    this.buffer.append(" DROP COLUMN ");
                    this.buffer.append(dropColumnIterator.next());
                }
                this.setReorgTable(stmt.tableName);
            }
            if ((dropConstraintIterator = dropColumnDefItem.constraintItemList.iterator()).hasNext()) {
                if (isDropColumn) {
                    if (this.isInsertSplitTag()) {
                        this.buffer.append("~9^Nz");
                    } else {
                        this.buffer.append(";\r\n");
                    }
                }
                this.buffer.append("ALTER TABLE ");
                this.buffer.append(stmt.tableName);
                while (dropConstraintIterator.hasNext()) {
                    this.buffer.append(" DROP CONSTRAINT ");
                    String columnDef = (String)dropConstraintIterator.next();
                    this.buffer.append(columnDef);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            if (useProcedure) {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
                SqlColumnDef column = alterColumnDefItem.columnDef;
                this.buffer.append("CALL modify_column('").append(stmt.tableName).append("',");
                this.buffer.append("'").append(column.name).append("','").append(column.name).append("','");
                StringBuilder oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatAlterColumnType(alterColumnDefItem.columnDef);
                this.handleComma(this.buffer, 0);
                oldBuffer.append((CharSequence)this.buffer);
                this.buffer = oldBuffer;
                this.buffer.append("')");
            } else {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
                String alterTable = "ALTER TABLE " + stmt.tableName;
                this.formatAlterColumnDef(alterTable, alterColumnDefItem.columnDef, stmt.tableName);
            }
        } else if (stmt.item instanceof SqlAlterTableAddItem) {
            if (useProcedure) {
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
                Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
                if (addColumnDefItem.columnDefItemList.size() == 0) {
                    this.buffer.append("ALTER TABLE ");
                    this.buffer.append(stmt.tableName);
                    this.buffer.append(" ADD ");
                }
                if (iterator.hasNext()) {
                    SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                    this.buffer.append("CALL add_column(");
                    this.buffer.append("'").append(stmt.tableName).append("', ");
                    this.buffer.append("'").append(columnDef.name).append("', '");
                    StringBuilder oldBuffer = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatAlterColumnType(columnDef);
                    this.handleComma(this.buffer, 0);
                    oldBuffer.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer;
                    this.buffer.append("')");
                }
                for (SqlTableConstraint constraint : addColumnDefItem.constraintItemList) {
                    this.formatTableConstraint(constraint);
                }
            } else {
                this.buffer.append("ALTER TABLE ");
                this.buffer.append(stmt.tableName);
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
                Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
                boolean isAddColumn = iterator.hasNext();
                while (iterator.hasNext()) {
                    this.buffer.append(" ADD ");
                    SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                    this.formatColumnDef(columnDef);
                }
                iterator = addColumnDefItem.constraintItemList.iterator();
                while (iterator.hasNext()) {
                    if (!isAddColumn) {
                        this.buffer.append(" ADD ");
                    }
                    SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                    this.formatTableConstraint(constraint);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            this.buffer.append("ALTER TABLE ");
            this.buffer.append(stmt.tableName);
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(addDefaultItem.columnName);
            this.buffer.append(" SET DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            this.buffer.append("ALTER TABLE ");
            this.buffer.append(stmt.tableName);
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append(" DROP DEFAULT");
        } else {
            throw new FormaterException("not support statement:" + stmt.item.toString());
        }
    }

    protected boolean isAlterTableWithProcedure() {
        return KSqlUtil.isAlterTableWithProcedureInDB2();
    }

    @Override
    protected void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        if (stmt.items == null || stmt.items.size() <= 1) {
            this.formatAlterTableStmtOld(stmt, this.isAlterTableWithProcedure());
            return;
        }
        Iterator itemsIterator = stmt.items.iterator();
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        while (itemsIterator.hasNext()) {
            Object columnDef;
            Iterator iterator;
            if (!flag) {
                sb.append("call xalter_table('").append(stmt.tableName).append("', '(");
            } else {
                sb.append("), (");
            }
            Object obj = itemsIterator.next();
            if (obj instanceof SqlAlterTableAddItem) {
                StringBuilder oldBuffer;
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)obj;
                iterator = addColumnDefItem.columnDefItemList.iterator();
                if (addColumnDefItem.columnDefItemList.size() == 0) {
                    sb.append(" ADD ");
                }
                boolean addItemFlag = false;
                while (iterator.hasNext()) {
                    if (addItemFlag) {
                        sb.append("), (add__column(");
                    } else {
                        sb.append("add__column(");
                    }
                    columnDef = (SqlColumnDef)iterator.next();
                    sb.append(((SqlColumnDef)columnDef).name);
                    sb.append(";");
                    oldBuffer = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatAlterColumnType((SqlColumnDef)columnDef);
                    this.handleComma(this.buffer, 0);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer;
                    sb.append(")");
                    addItemFlag = true;
                }
                iterator = addColumnDefItem.constraintItemList.iterator();
                addItemFlag = false;
                while (iterator.hasNext()) {
                    SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                    oldBuffer = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatTableConstraint(constraint);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer;
                }
            } else if (obj instanceof SqlAlterTableDropItem) {
                SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)obj;
                iterator = dropColumnDefItem.columnDefItemList.iterator();
                boolean dropItemFlag = false;
                while (iterator.hasNext()) {
                    if (dropItemFlag) {
                        sb.append("), (drop_column(");
                    } else {
                        sb.append("drop_column(");
                    }
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    sb.append(")");
                    dropItemFlag = true;
                }
                iterator = dropColumnDefItem.constraintItemList.iterator();
                dropItemFlag = false;
                while (iterator.hasNext()) {
                    if (dropItemFlag) {
                        sb.append(", ");
                    } else {
                        sb.append(" DROP CONSTRAINT ");
                    }
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    dropItemFlag = true;
                }
            } else if (obj instanceof SqlAlterTableAlterColumnItem) {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)obj;
                sb.append("modi_column(");
                SqlColumnDef column = alterColumnDefItem.columnDef;
                sb.append(column.name);
                sb.append(";");
                StringBuilder oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatAlterColumnType(alterColumnDefItem.columnDef);
                this.handleComma(this.buffer, 0);
                sb.append((CharSequence)this.buffer);
                this.buffer = oldBuffer;
                sb.append(")");
            } else if (obj instanceof SqlAlterTableAddDefaultItem) {
                SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)obj;
                sb.append(" ALTER COLUMN ");
                sb.append(addDefaultItem.columnName);
                sb.append(" SET DEFAULT ");
                StringBuilder oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatExpr(addDefaultItem.value);
                sb.append(this.buffer.toString().replaceAll("'", "''"));
                this.buffer = oldBuffer;
            } else if (obj instanceof SqlAlterTableDropDefaultItem) {
                SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)obj;
                sb.append(" ALTER COLUMN ");
                sb.append(dropDefaultItem.columnName);
                sb.append(" DROP DEFAULT ");
            } else {
                throw new FormaterException("not support statement:" + stmt);
            }
            flag = true;
        }
        if (flag) {
            this.buffer.append((CharSequence)sb);
            this.buffer.append(")'");
        }
        this.buffer.append(")");
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        if (stmt.name.startsWith("GZT")) {
            this.formatDeclareGlobalTemporaryTable(stmt);
        } else {
            this.formatCommonTable(stmt);
        }
    }

    protected void formatCommonTable(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE TABLE ");
        this.buffer.append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        String ts = null;
        if (UUTN.isTempTable(stmt.name) && this.options != null) {
            ts = this.options.getTempTableSpace();
        }
        if (ts == null) {
            ts = stmt.tableSpace;
        }
        this.formatTableSpace(ts);
    }

    private void formatDeclareGlobalTemporaryTable(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("DECLARE GLOBAL TEMPORARY TABLE");
        this.buffer.append(" ").append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
    }

    protected void formatAlterColumnType(SqlColumnDef column) throws FormaterException {
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARGRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("GRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            DisCardUtil.discard();
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    protected void formatAlterColumnDef(String alterTable, SqlColumnDef column, String tableName) throws FormaterException {
        boolean isMultiClause = false;
        if (column.dataType != null) {
            isMultiClause = true;
            this.buffer.append(alterTable);
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(column.name);
            this.buffer.append(" ");
            this.buffer.append("SET DATA TYPE ");
            if (column.dataType.equalsIgnoreCase("DECIMAL")) {
                this.buffer.append("DECIMAL (");
                this.buffer.append(column.precision);
                this.buffer.append(", ");
                this.buffer.append(column.scale);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
                this.buffer.append("SMALLINT");
            } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
                this.buffer.append("TIMESTAMP");
            } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
                this.buffer.append("VARCHAR (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
                this.buffer.append("VARGRAPHIC (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("CHAR")) {
                this.buffer.append("CHAR (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
                this.buffer.append("GRAPHIC (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("CLOB")) {
                this.buffer.append("CLOB (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
                this.buffer.append("CLOB (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("BINARY")) {
                this.buffer.append("VARCHAR (");
                this.buffer.append(column.length);
                this.buffer.append(") FOR BIT DATA");
            } else if (column.dataType.equalsIgnoreCase("BLOB")) {
                this.buffer.append("BLOB (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
                this.buffer.append("VARCHAR (");
                this.buffer.append(column.length);
                this.buffer.append(") FOR BIT DATA");
            } else {
                this.buffer.append(column.dataType);
            }
            this.setReorgTable(tableName);
        }
        if (column.allowNull != null) {
            if (column.allowNull == Boolean.TRUE) {
                if (!column.isPrimaryKey) {
                    if (isMultiClause) {
                        if (this.isInsertSplitTag()) {
                            this.buffer.append("~9^Nz");
                        } else {
                            this.buffer.append(";\r\n");
                        }
                    } else {
                        isMultiClause = true;
                    }
                    this.buffer.append(alterTable);
                    this.buffer.append(" ALTER COLUMN ");
                    this.buffer.append(column.name);
                    this.buffer.append(" ");
                    this.buffer.append("DROP NOT NULL");
                    this.setReorgTable(tableName);
                }
            } else {
                if (isMultiClause) {
                    if (this.isInsertSplitTag()) {
                        this.buffer.append("~9^Nz");
                    } else {
                        this.buffer.append(";\r\n");
                    }
                } else {
                    isMultiClause = true;
                }
                this.buffer.append(alterTable);
                this.buffer.append(" ALTER COLUMN ");
                this.buffer.append(column.name);
                this.buffer.append(" ");
                this.buffer.append("SET NOT NULL");
                this.setReorgTable(tableName);
            }
        }
        if (column.defaultValueExpr != null) {
            if (isMultiClause) {
                if (this.isInsertSplitTag()) {
                    this.buffer.append("~9^Nz");
                } else {
                    this.buffer.append(";\r\n");
                }
            } else {
                isMultiClause = true;
            }
            this.buffer.append(alterTable);
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(column.name);
            this.buffer.append(" ");
            this.buffer.append(" SET DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        boolean isAdd = false;
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            if (isMultiClause) {
                if (this.isInsertSplitTag()) {
                    this.buffer.append("~9^Nz");
                } else {
                    this.buffer.append(";\r\n");
                }
            } else {
                isMultiClause = true;
            }
            this.buffer.append(alterTable);
            this.buffer.append(" ADD");
            isAdd = true;
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            if (isMultiClause) {
                if (this.isInsertSplitTag()) {
                    this.buffer.append("~9^Nz");
                } else {
                    this.buffer.append(";\r\n");
                }
            } else {
                isMultiClause = true;
            }
            if (!isAdd) {
                this.buffer.append(alterTable);
                this.buffer.append(" ADD");
            }
            this.buffer.append(" PRIMARY KEY (");
            this.buffer.append(column.name);
            this.buffer.append(")");
        }
        if (column.isUnique) {
            if (isMultiClause) {
                if (this.isInsertSplitTag()) {
                    this.buffer.append("~9^Nz");
                } else {
                    this.buffer.append(";\r\n");
                }
            } else {
                isMultiClause = true;
            }
            if (!isAdd) {
                this.buffer.append(alterTable);
                this.buffer.append(" ADD");
            }
            this.buffer.append(" UNIQUE(");
            this.buffer.append(column.name);
            this.buffer.append(")");
        }
        if (column.checkExpr != null) {
            if (isMultiClause) {
                if (this.isInsertSplitTag()) {
                    this.buffer.append("~9^Nz");
                } else {
                    this.buffer.append(";\r\n");
                }
            } else {
                isMultiClause = true;
            }
            if (!isAdd) {
                this.buffer.append(alterTable);
                this.buffer.append(" ADD");
            }
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARGRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("GRAPHIC (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(") FOR BIT DATA");
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INT");
            this.context.put("Identity", column.name);
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                DisCardUtil.discard();
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    public void formatHierarchicalSelect(SqlSelect select) throws FormaterException {
        Map optionMap;
        this.buffer.append("WITH KSQL_SUB_TABLE (");
        boolean commaFlag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlSelectItem selectItem = (SqlSelectItem)select.selectList.get(i);
            if (selectItem.expr instanceof SqlIdentifierExpr && ((SqlIdentifierExpr)selectItem.expr).value.equalsIgnoreCase("LEVEL")) continue;
            if (commaFlag) {
                this.buffer.append(", ");
            }
            commaFlag = true;
            if (selectItem.alias != null && selectItem.alias.length() != 0) {
                this.buffer.append(selectItem.alias);
                continue;
            }
            if (selectItem.expr instanceof SqlIdentifierExpr) {
                this.buffer.append(((SqlIdentifierExpr)selectItem.expr).value);
                continue;
            }
            throw new FormaterException("DB2 NOT SUPPORT this HierarchicalQuery.");
        }
        this.buffer.append(", Level");
        this.buffer.append(") AS (SELECT ");
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.expr instanceof SqlIdentifierExpr && ((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase("LEVEL")) continue;
            if (flag) {
                this.buffer.append(", ");
            }
            if (item.alias != null && item.alias.length() != 0) {
                this.formatExpr(item.expr);
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        this.buffer.append(", 0");
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM ").append(this.sysSchema("SYSDUMMY1")).append(".SYSDUMMY1");
        }
        if (select.hierarchicalQueryClause.startWithCondition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.hierarchicalQueryClause.startWithCondition);
        }
        this.buffer.append(" UNION ALL SELECT ");
        flag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlSelectItem selectItem = (SqlSelectItem)select.selectList.get(i);
            if (selectItem.expr instanceof SqlIdentifierExpr && ((SqlIdentifierExpr)selectItem.expr).value.equalsIgnoreCase("LEVEL")) continue;
            if (flag) {
                this.buffer.append(", ");
            }
            this.buffer.append("PRIOR_TAB.");
            if (selectItem.alias != null && selectItem.alias.length() != 0) {
                this.buffer.append(selectItem.alias);
            } else if (selectItem.expr instanceof SqlIdentifierExpr) {
                this.buffer.append(((SqlIdentifierExpr)selectItem.expr).value);
            } else {
                throw new FormaterException("DB2 NOT SUPPORT this HierarchicalQuery");
            }
            flag = true;
        }
        this.buffer.append(", KSQL_SUB_TABLE.Level + 1");
        this.buffer.append(" FROM (SELECT ");
        iterator = select.selectList.iterator();
        flag = false;
        while (iterator.hasNext()) {
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.expr instanceof SqlIdentifierExpr && ((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase("LEVEL")) continue;
            if (flag) {
                this.buffer.append(", ");
            }
            if (item.alias != null && item.alias.length() != 0) {
                this.formatExpr(item.expr);
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM ").append(this.sysSchema()).append(".SYSDUMMY1");
        }
        this.buffer.append(") PRIOR_TAB, KSQL_SUB_TABLE WHERE ");
        SqlExpr connectBy_expr = this.replaceHierarchicalQueryClauseConnectByCondition(select.hierarchicalQueryClause.connectByCondition);
        if (connectBy_expr == null) {
            throw new FormaterException("Error");
        }
        this.formatExpr(connectBy_expr);
        this.buffer.append(") SELECT ");
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlSelectItem selectItem = (SqlSelectItem)select.selectList.get(i);
            if (i != 0) {
                this.buffer.append(", ");
            }
            if (selectItem.alias != null && selectItem.alias.length() != 0) {
                this.buffer.append(selectItem.alias);
                continue;
            }
            if (selectItem.expr instanceof SqlIdentifierExpr) {
                this.buffer.append(((SqlIdentifierExpr)selectItem.expr).value);
                continue;
            }
            throw new FormaterException("DB2 NOT SUPPORT this HierarchicalQuery.");
        }
        this.buffer.append(" FROM KSQL_SUB_TABLE");
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1 && KSqlUtil.isICUEnableInDb2()) {
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append("COLLATION_KEY_BIT (");
                        } else {
                            this.buffer.append("ICU.SORTKEY(");
                        }
                    }
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append(",'UCA500R1_LZH_AN_CX_EX_FX_HX_NX_S3')");
                        } else {
                            this.buffer.append(",'LZH_KPINYIN')");
                        }
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            if (select.limit.rowCount == 1) {
                this.buffer.append(" FETCH FIRST 1 ROW ONLY");
            } else {
                this.buffer.append(" FETCH FIRST ");
                this.buffer.append(select.limit.rowCount);
                this.buffer.append(" ROWS ONLY");
            }
        }
        if ((optionMap = select.getOptionMapDirect()) != null && optionMap.containsKey("FOR UPDATE")) {
            this.buffer.append(" FOR UPDATE");
        }
    }

    private SqlExpr replaceHierarchicalQueryClauseConnectByCondition(SqlExpr expr) throws FormaterException {
        if (expr instanceof SqlIdentifierExpr) {
            SqlBinaryOpExpr binaryExpr = new SqlBinaryOpExpr();
            binaryExpr.left = new SqlIdentifierExpr("PRIOR_TAB");
            binaryExpr.operator = 20;
            binaryExpr.right = expr;
            return binaryExpr;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryExpr = (SqlBinaryOpExpr)expr;
            binaryExpr.left = this.replaceHierarchicalQueryClauseConnectByCondition(binaryExpr.left);
            binaryExpr.right = this.replaceHierarchicalQueryClauseConnectByCondition(binaryExpr.right);
            return binaryExpr;
        }
        if (expr instanceof SqlMethodInvokeExpr) {
            SqlMethodInvokeExpr methodInvokeExpr = (SqlMethodInvokeExpr)expr;
            for (int i = 0; i < methodInvokeExpr.parameters.size(); ++i) {
                SqlExpr pramExpr = this.replaceHierarchicalQueryClauseConnectByCondition((SqlExpr)methodInvokeExpr.parameters.get(i));
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
        } else {
            if (expr instanceof SqlAggregateExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlAllExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlAnyExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlBetweenExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlCaseExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlExistsExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlInListExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlInSubQueryExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlNotExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
            if (expr instanceof SqlSomeExpr) {
                throw new FormaterException("not support expression:" + expr);
            }
        }
        return expr;
    }

    @Override
    protected void handleSqlSelectInUnionSelect(SqlSelectBase select) throws FormaterException {
        if (select instanceof SqlSelect && ((SqlSelect)select).limit != null) {
            this.buffer.append("SELECT * FROM (");
            super.handleSqlSelectInUnionSelect(select);
            this.buffer.append(") ");
            this.buffer.append(this.getTempName("TS_"));
        } else {
            super.handleSqlSelectInUnionSelect(select);
        }
    }

    protected void formatSelectBase(SqlSelectBase select, boolean hasRowNum) throws FormaterException {
        if (select instanceof SqlSelect) {
            this.formatSelect((SqlSelect)select, hasRowNum);
        } else if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (unionSelect.left instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.left).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.left);
                this.buffer.append(')');
            } else {
                this.handleSqlSelectInUnionSelect(unionSelect.left);
            }
            if (unionSelect.option == 0) {
                this.buffer.append(" UNION ");
            } else if (unionSelect.option == 1) {
                this.buffer.append(" UNION ALL ");
            } else {
                throw new FormaterException("Eorr Union Option.");
            }
            if (unionSelect.right instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.right).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.right);
                this.buffer.append(')');
            } else {
                this.handleSqlSelectInUnionSelect(unionSelect.right);
            }
            if (unionSelect.orderBy.size() != 0) {
                this.buffer.append(" ORDER BY ");
                boolean flag = false;
                Iterator iterator = unionSelect.orderBy.iterator();
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                    if (orderByIterm.chineseOrderByMode != -1 && KSqlUtil.isICUEnableInDb2()) {
                        if (orderByIterm.chineseOrderByMode == 2) {
                            if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                                this.buffer.append("COLLATION_KEY_BIT (");
                            } else {
                                this.buffer.append("ICU.SORTKEY(");
                            }
                        }
                        this.formatExpr(orderByIterm.expr);
                        if (orderByIterm.chineseOrderByMode == 2) {
                            if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                                this.buffer.append(",'UCA500R1_LZH_AN_CX_EX_FX_HX_NX_S3')");
                            } else {
                                this.buffer.append(",'LZH_KPINYIN')");
                            }
                        }
                    } else {
                        this.formatExpr(orderByIterm.expr);
                    }
                    if (orderByIterm.mode == 0) {
                        this.buffer.append(" ASC");
                    } else {
                        this.buffer.append(" DESC");
                    }
                    flag = true;
                }
            }
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        this.formatSelect(select, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void formatSelect(SqlSelect select, boolean hasRowNum) throws FormaterException {
        Map optionMap;
        String schema = "DB2ADMIN";
        if (this.options != null && this.options.getDbSchema() != null) {
            schema = this.options.getDbSchema();
        }
        boolean flag2 = false;
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS (");
        }
        if (select.hierarchicalQueryClause != null) {
            this.formatHierarchicalSelect(select);
            return;
        }
        this.buffer.append("SELECT ");
        if (hasRowNum) {
            this.buffer.append("ROW_NUMBER() OVER(");
            boolean flag = false;
            Iterator iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(flag ? ", " : "ORDER BY ");
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1 && KSqlUtil.isICUEnableInDb2()) {
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append("COLLATION_KEY_BIT (");
                        } else {
                            this.buffer.append("ICU.SORTKEY(");
                        }
                    }
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append(",'UCA500R1_LZH_AN_CX_EX_FX_HX_NX_S3')");
                        } else {
                            this.buffer.append(",'LZH_KPINYIN')");
                        }
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
            this.buffer.append(") AS KSQL_SEQ, ");
            if (select.distinct == 1) {
                this.buffer.append(" KSQL_V1.* FROM ( SELECT DISTINCT ");
            } else {
                if (select.distinct != 0) throw new FormaterException("distinct option not support.");
                DisCardUtil.discard();
            }
        } else if (select.distinct == 1) {
            flag2 = this.checkHaveChineseOrderBy(select.orderBy);
            if (flag2) {
                this.buffer.append("KSQL_V2.* FROM ( SELECT DISTINCT ");
            } else {
                this.buffer.append("DISTINCT ");
            }
        } else {
            if (select.distinct != 0) throw new FormaterException("distinct option not support.");
            DisCardUtil.discard();
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        boolean sysTableFlag = false;
        boolean sysIndexFlag = false;
        boolean sysConstraintFlag = false;
        while (iterator.hasNext()) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block118: {
                block116: {
                    block128: {
                        block127: {
                            block126: {
                                block125: {
                                    block124: {
                                        block123: {
                                            block122: {
                                                block121: {
                                                    block120: {
                                                        block119: {
                                                            block117: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)iterator.next();
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block116;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block117;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block118;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block119;
                                                            item.alias = Token.KSQL_COL_TABNAME.value;
                                                            break block118;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block120;
                                                        item.alias = Token.KSQL_COL_TYPE.value;
                                                        break block118;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block121;
                                                    item.alias = Token.KSQL_COL_LENGTH.value;
                                                    break block118;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block122;
                                                item.alias = Token.KSQL_COL_NULLABLE.value;
                                                break block118;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block123;
                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                            break block118;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block124;
                                        item.alias = Token.TABNAME.value;
                                        sysTableFlag = true;
                                        break block118;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block125;
                                    item.alias = Token.KSQL_CREATETIME.value;
                                    sysTableFlag = true;
                                    break block118;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block126;
                                item.alias = Token.INDNAME.value;
                                sysIndexFlag = true;
                                break block118;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block127;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            sysConstraintFlag = true;
                            break block118;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block128;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        sysConstraintFlag = true;
                        break block118;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block118;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    sysConstraintFlag = true;
                    break block118;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                            ((SqlIdentifierExpr)param).value = "CTIME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TBNAME";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "CONSTRAINTYP";
                    }
                }
            }
            if (item.expr instanceof SqlNullExpr) {
                this.buffer.append("CASE 1 WHEN 1 THEN NULL ELSE 'Stupid DB2!' END");
                if (item.alias != null && item.alias.length() != 0) {
                    this.buffer.append(" ");
                    this.buffer.append(item.alias.toUpperCase());
                }
            } else if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "NAME";
                        this.formatExpr(columnNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CTIME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TBNAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINTYP";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CTIME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TBNAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINTYP";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.into != null) {
            DisCardUtil.discard();
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM ").append(this.sysSchema("SYSDUMMY1")).append(".SYSDUMMY1");
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            if (sysTableFlag) {
                this.buffer.append("CREATOR='").append(schema).append("' AND (TYPE ='T' OR TYPE ='V') AND ");
            } else if (sysIndexFlag) {
                this.buffer.append("CREATOR='").append(schema).append("' AND ");
            } else if (sysConstraintFlag) {
                DisCardUtil.discard();
            }
            this.formatExpr(select.condition);
        } else if (sysTableFlag) {
            this.buffer.append(" WHERE CREATOR='").append(schema).append("' AND (TYPE='T' OR TYPE='V')");
        } else if (sysIndexFlag) {
            this.buffer.append(" WHERE CREATOR='").append(schema).append("'");
        } else if (sysConstraintFlag) {
            DisCardUtil.discard();
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (flag2 && select.distinct == 1) {
            this.buffer.append(") KSQL_V2");
        }
        if (select.orderBy.size() != 0 && !hasRowNum) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1 && KSqlUtil.isICUEnableInDb2()) {
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append("COLLATION_KEY_BIT (");
                        } else {
                            this.buffer.append("ICU.SORTKEY(");
                        }
                    }
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.chineseOrderByMode == 2) {
                        if (KSqlUtil.isICUinDb2UseCOLLATION_KEY_BIT()) {
                            this.buffer.append(",'UCA500R1_LZH_AN_CX_EX_FX_HX_NX_S3')");
                        } else {
                            this.buffer.append(",'LZH_KPINYIN')");
                        }
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            if (select.limit.rowCount == 1) {
                this.buffer.append(" FETCH FIRST 1 ROW ONLY");
            } else {
                this.buffer.append(" FETCH FIRST ");
                this.buffer.append(select.limit.rowCount);
                this.buffer.append(" ROWS ONLY");
            }
        }
        if ((optionMap = select.getOptionMapDirect()) != null) {
            if (optionMap.containsKey("FOR UPDATE")) {
                this.buffer.append(" FOR UPDATE");
            }
            if (optionMap.containsKey("FAST")) {
                Integer val = (Integer)optionMap.get("FAST");
                if (val == null) {
                    this.buffer.append(" OPTIMIZE FOR 1 ROW");
                } else {
                    this.buffer.append(" OPTIMIZE FOR ");
                    if (val == 1) {
                        this.buffer.append("1 ROW");
                    } else {
                        this.buffer.append(val);
                        this.buffer.append(" ROWS");
                    }
                }
            }
        }
        if (select.into != null) {
            this.buffer.append(")");
            this.buffer.append(" WITH NO DATA;\r\n");
            SqlSelect select_clone = (SqlSelect)select.clone();
            if (select_clone.tableSource != null && select.tableSource != null) {
                select_clone.tableSource.alias = select.tableSource.alias;
            }
            select_clone.into = null;
            this.buffer.append("INSERT INTO ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" ");
            this.formatSelect(select_clone, false);
            this.buffer.append(";");
        }
        if (!hasRowNum || select.distinct != 1) return;
        this.buffer.append(") KSQL_V1");
    }

    @Override
    protected void formatNChar(SqlNCharExpr expr) throws FormaterException {
        this.buffer.append("G'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    protected final void formatTableSpace(String tableSpace) {
        if (tableSpace != null && tableSpace.length() > 0) {
            this.buffer.append(" IN ").append(tableSpace);
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append(this.sysSchema()).append(".SYSTABLES");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append(this.sysSchema()).append(".SYSCOLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append(this.sysSchema()).append(".SYSINDEXES");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append(this.sysSchema()).append(".").append(this.constraintTable());
            } else if (simpleTableSource.name.startsWith("GZT")) {
                this.buffer.append("session.").append(simpleTableSource.name);
            } else {
                this.buffer.append(simpleTableSource.name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toUpperCase());
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            if (joinedTable.joinType == 4) {
                DisCardUtil.discard();
            }
            this.formatTableSource(joinedTable.left);
            tableSource.subQueries.addAll(joinedTable.left.subQueries);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            tableSource.subQueries.addAll(joinedTable.right.subQueries);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            tableSource.subQueries.addAll(subQueryTableSource.subQuery.subQueries);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toUpperCase());
            }
        } else {
            throw new FormaterException("not support tableSource:" + tableSource);
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("'");
        if (expr.timeType() == -19000) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        } else if (expr.timeType() == -19001) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(" 00:00:00");
        } else if (expr.timeType() == -19002) {
            this.buffer.append(expr.getHour() < 10 ? "0" : "");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        }
        this.buffer.append("'");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ATAN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("MOD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOG(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            SqlExpr thirdExpr = (SqlExpr)expr.parameters.get(2);
            if (!(thirdExpr instanceof SqlIntExpr)) {
                throw new FormaterException("ERROR");
            }
            int val = Integer.parseInt(((SqlIntExpr)thirdExpr).text);
            if (val == 0) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            this.buffer.append("TRUNC(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SIGN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SQRT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("TAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOCATE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONCAT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                }
                if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 0.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UCASE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) return;
            String targetTypeName = ((SqlIdentifierExpr)expr.parameters.get((int)0)).value;
            if (targetTypeName.compareToIgnoreCase("DATETIME") == 0) {
                this.buffer.append("TIMESTAMP(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (targetTypeName.compareToIgnoreCase("VARCHAR") != 0) throw new FormaterException("not support Type:" + targetTypeName);
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT DATE");
            return;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CHAR(CURRENT TIME)");
            return;
        }
        if (methodNameI.compareTo("DATEADD") == 0 || methodNameI.compareTo("DATETIMEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" SECOND");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" YEAR");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MONTH");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" DAY");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" HOUR");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" MINUTE");
                return;
            }
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart)) {
                if (!"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            }
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" SECOND");
            return;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("(DAYS(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") - DAYS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")) * 60 * 60 * 24 + MIDNIGHT_SECONDS(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") - MIDNIGHT_SECONDS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) return;
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append("(YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append("((YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 12 + MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append("(DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("))");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append("((DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 24)");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append("((DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(") - DAYS (");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) * 24 * 60)");
                return;
            }
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart)) {
                if (!"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            }
            this.buffer.append("((DAYS (");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(") - DAYS (");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")) * 24 * 60 * 60)");
            return;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DAYNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAY(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYOFWEEK(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYOFYEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT TIMESTAMP");
            return;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("HOUR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MINUTE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MONTHNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT TIMESTAMP");
            return;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("QUARTER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SECOND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("WEEK(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            this.format_TO_DATE_Invoke(expr);
            return;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("((YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") - YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")) * 12 +");
            this.buffer.append("MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") - MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MONTH)");
            return;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" YEAR)");
            return;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" DAY)");
            return;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" HOUR)");
            return;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MINUTE)");
            return;
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formateDateExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" SECOND)");
            return;
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("coalesce(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                if (expr.parameters.get(0) instanceof SqlNullExpr) {
                    this.buffer.append("CAST (");
                    this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                    this.buffer.append(" AS CHAR(1))");
                    return;
                }
                if (!(expr.parameters.get(0) instanceof SqlIntExpr || expr.parameters.get(0) instanceof SqlLongExpr || expr.parameters.get(0) instanceof SqlDoubleExpr)) {
                    this.buffer.append("LTRIM(RTRIM(CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")))");
                    return;
                }
                this.buffer.append("LTRIM(RTRIM(");
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS CHAR(50)");
                this.buffer.append(")))");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD HH24:MI:SS")) {
                this.buffer.append("VARCHAR_FORMAT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD")) {
                this.buffer.append("SUBSTR(TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS'), 1, 10)");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            if (!expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("ERROR");
            if (expr.parameters.get(2) instanceof SqlCharExpr) {
                String style = expr.parameters.get(2).toString();
                if (style.split("D").length <= 0) throw new FormaterException("TO_CHAR()'s NUMBER style: " + expr.parameters.get(2) + " is not valid.");
                if (style.split("D").length >= 3) throw new FormaterException("TO_CHAR()'s NUMBER style: " + expr.parameters.get(2) + " is not valid.");
                char[] integerStyle = style.split("D")[0].toCharArray();
                char[] radixStyle = style.split("D")[1].toCharArray();
                int countInteger = 0;
                for (int i = 0; i < integerStyle.length; ++i) {
                    if (integerStyle[i] != '9') continue;
                    ++countInteger;
                }
                int countradix = 0;
                int i = 0;
                while (true) {
                    if (i >= radixStyle.length) {
                        this.buffer.append("LTRIM(RTRIM(CHAR(");
                        this.buffer.append("DECIMAL(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.buffer.append(countInteger + countradix);
                        this.buffer.append(", ");
                        this.buffer.append(countradix);
                        this.buffer.append("))))");
                        return;
                    }
                    if (radixStyle[i] == '9') {
                        ++countradix;
                    }
                    ++i;
                }
            }
            if (!(expr.parameters.get(2) instanceof SqlIntExpr)) return;
            SqlIntExpr intExpr = (SqlIntExpr)expr.parameters.get(2);
            if (intExpr.value <= 0) {
                this.buffer.append("RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(",");
                this.formatExpr(intExpr);
                this.buffer.append("), 31, 0)))))");
                return;
            }
            this.buffer.append("CASE WHEN ((");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("<0) AND (");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(">-1)) THEN ");
            this.buffer.append("'-' || RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")))))");
            this.buffer.append(" ELSE RTRIM(LTRIM(CHAR(BIGINT(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("))))) END");
            this.buffer.append("||'.'||RTRIM(LTRIM(SUBSTR(CHAR(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")),LOCATE('.' ,CHAR(DECIMAL(ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append("), 31,");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")))+1)))");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("DECIMAL(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(1));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(2));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.buffer.append("CAST (");
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                this.buffer.append(" AS DECIMAL(1))");
                return;
            }
            this.buffer.append("DECIMAL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_BLOB") == 0 || methodNameI.compareTo("BLOB") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(0) instanceof SqlNullExpr)) return;
            this.buffer.append("CAST (");
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            this.buffer.append(" AS BLOB)");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0 || methodNameI.compareTo("DOUBLE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DOUBLE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_INTEGER") == 0 || methodNameI.compareTo("INT") == 0 || methodNameI.compareTo("INTEGER") == 0 || methodNameI.compareTo("TO_INT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.buffer.append("CAST (");
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                this.buffer.append(" AS INT)");
                return;
            }
            this.buffer.append("FLOOR(INT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS VARGRAPHIC(1)");
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS VARGRAPHIC(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_VARCHAR") == 0 || methodNameI.compareTo("TOVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS VARCHAR(1)");
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS VARCHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(NEWID())");
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("NEWBOSID(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
            SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
            String type = cexpr.text;
            type = DataType.getDataType(1).nativeType(type);
            this.formatExpr(new SqlCharExpr(type));
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    private void formateDateExpr(SqlExpr expr) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr.type == 21) {
            SqlDateTimeExpr dtExpr = (SqlDateTimeExpr)expr;
            if (dtExpr.timeType() == -19000) {
                this.buffer.append("TIMESTAMP(");
            } else if (dtExpr.timeType() == -19001) {
                this.buffer.append("DATE(");
            } else if (dtExpr.timeType() == -19002) {
                this.buffer.append("TIME(");
            } else {
                throw new IllegalArgumentException("invalid date time type!");
            }
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
            this.buffer.append(")");
        } else {
            this.formatExpr(expr);
        }
    }

    protected void format_TO_DATE_Invoke(SqlMethodInvokeExpr expr) throws FormaterException {
        if (expr.parameters.size() != 1) {
            throw new FormaterException("ERROR");
        }
        boolean needFormat = true;
        String format = "'YYYY-MM-DD HH24:MI:SS'";
        if (expr.parameters.get(0) instanceof SqlNullExpr) {
            this.buffer.append("CAST(");
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            this.buffer.append(" AS TIMESTAMP)");
        } else {
            if (expr.parameters.get(0) instanceof SqlCharExpr) {
                SqlCharExpr dateTimeSqlExpr = (SqlCharExpr)expr.parameters.get(0);
                if (dateTimeSqlExpr.text.indexOf(".") > 0) {
                    this.buffer.append("TIMESTAMP");
                    this.buffer.append("(");
                    this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text));
                    needFormat = false;
                } else if (dateTimeSqlExpr.text.indexOf(":") < 0) {
                    this.buffer.append("TO_DATE");
                    this.buffer.append("(");
                    if (dateTimeSqlExpr.text.endsWith(" ")) {
                        this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + "00:00:00"));
                    } else {
                        this.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + " 00:00:00"));
                    }
                } else {
                    this.buffer.append("TO_DATE");
                    this.buffer.append("(");
                    this.formatExpr(dateTimeSqlExpr);
                }
            } else {
                this.buffer.append("TO_DATE");
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
            }
            if (needFormat) {
                this.buffer.append(", ").append(format).append(")");
            } else {
                this.buffer.append(")");
            }
        }
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 21) {
            this.buffer.append("MOD (");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 42) {
            this.buffer.append("CONCAT(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.left instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) && expr.right instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        expr.subQueries().addAll(expr.left.subQueries());
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        expr.subQueries().addAll(expr.right.subQueries());
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatTrancateTableStmt(SqlTrancateTableStmt stmt) throws FormaterException {
        this.buffer.append("DELETE FROM ");
        this.buffer.append(this.formatTableName(stmt.tableName));
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        this.buffer.append("KSQL_SUB_TABLE.");
        this.buffer.append(expr.value);
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(this.formatTableName(update.updateTable.name));
        if (update.updateTable.alias != null) {
            this.buffer.append(" AS ");
            this.buffer.append(update.updateTable.alias);
        }
        this.buffer.append(" SET ");
        boolean flag = false;
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (flag) {
                this.buffer.append(", ");
            }
            this.formateUpdateItem(abstract_item);
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("not support");
        }
        boolean whereFlag = false;
        if (update.condition != null) {
            whereFlag = true;
            this.buffer.append(" WHERE ");
            this.formatExpr(update.condition);
        }
        if (!KHints.containHint(update.getHints(), "NOT_GEN_EXISTS")) {
            for (AbstractUpdateItem abstract_item : update.updateList) {
                if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
                if (whereFlag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                    whereFlag = true;
                }
                this.buffer.append("EXISTS (");
                this.formatSelectBase(((SubQueryUpdateItem)abstract_item).subQuery);
                this.buffer.append(")");
            }
        }
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        int i;
        int size;
        this.buffer.append("BEGIN atomic \n");
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                SqlBlockStmt.DeclItem item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem varItem = (SqlBlockStmt.DeclVarItem)item;
                    this.buffer.append("DECLARE ");
                    String name = varItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" ");
                    if (varItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        this.buffer.append("DECIMAL (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("TINYINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (varItem.dataType.equalsIgnoreCase("DATETIME")) {
                        this.buffer.append("TIMESTAMP");
                    } else if (varItem.dataType.equalsIgnoreCase("VARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NVARCHAR")) {
                        this.buffer.append("VARGRAPHIC (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("CHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("GRAPHIC (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("CLOB (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("CLOB (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BINARY")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(") FOR BIT DATA");
                    } else if (varItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("BLOB (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(") FOR BIT DATA");
                    } else {
                        this.buffer.append(varItem.dataType);
                    }
                    if (varItem.defaultValueExpr != null) {
                        this.buffer.append(" DEFAULT ");
                        this.formatExpr(varItem.defaultValueExpr);
                    }
                } else if (item instanceof SqlBlockStmt.DeclCurItem) {
                    this.buffer.append("-- DECLARE CURSOR FOR ").append(item.name);
                } else {
                    throw new FormaterException("not support statement:" + item);
                }
                this.buffer.append(";\n");
            }
        }
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(stmt, itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("end");
    }

    protected void formatStmt(SqlBlockStmt block, SqlStmt stmt) throws FormaterException {
        if (stmt instanceof SqlIfStmt) {
            this.formatIfStmt(block, (SqlIfStmt)stmt);
        } else if (stmt instanceof SqlWhileStmt) {
            this.formatWhileStmt(block, (SqlWhileStmt)stmt);
        } else if (stmt instanceof SqlCursorLoopStmt) {
            this.formatCursorLoopStmt(block, (SqlCursorLoopStmt)stmt);
        } else if (stmt instanceof SqlBreakStmt) {
            this.formatBreakStmt(block, (SqlBreakStmt)stmt);
        } else if (stmt instanceof SqlContinueStmt) {
            this.formatContinueStmt(block, (SqlContinueStmt)stmt);
        } else {
            this.formatStmt(stmt);
        }
    }

    private void handleSplitInIfStmt(StringBuilder buffer, int pos) {
        int splitIndex = buffer.indexOf("~9^Nz", pos);
        String relace = "'; EXECUTE IMMEDIATE SQL_STR; SET SQL_STR = '";
        while (splitIndex > 0) {
            buffer.replace(splitIndex, splitIndex + "~9^Nz".length(), relace);
            splitIndex = buffer.indexOf("~9^Nz", splitIndex + relace.length());
        }
    }

    private String getTempName(String prefix) {
        long randomNum = ThreadLocalRandom.current().nextInt(9999999);
        String randomNumStr = "" + randomNum;
        if (randomNum < 10L) {
            randomNumStr = "0" + randomNumStr;
        }
        if (randomNum < 100L) {
            randomNumStr = "0" + randomNumStr;
        }
        if (randomNum < 1000L) {
            randomNumStr = "0" + randomNumStr;
        }
        if (randomNum < 10000L) {
            randomNumStr = "0" + randomNumStr;
        }
        if (randomNum < 100000L) {
            randomNumStr = "0" + randomNumStr;
        }
        if (randomNum < 1000000L) {
            randomNumStr = "0" + randomNumStr;
        }
        return prefix + System.currentTimeMillis() + randomNumStr;
    }

    protected void formatIfStmt(SqlBlockStmt block, SqlIfStmt stmt) throws FormaterException {
        String schema = "DB2ADMIN";
        if (this.options != null && this.options.getDbSchema() != null) {
            schema = this.options.getDbSchema();
        }
        this.buffer.append("CREATE PROCEDURE ");
        if (this.needTemporarySchema()) {
            this.buffer.append(schema);
            this.buffer.append(".");
        }
        String tempProcedureName = this.getTempName("KTP_");
        this.buffer.append(tempProcedureName);
        this.buffer.append("() ");
        if (this.procedureBodyIsSQL()) {
            this.buffer.append("LANGUAGE SQL ");
        }
        this.buffer.append("BEGIN ");
        this.buffer.append("DECLARE SQL_STR VARCHAR(32672);");
        this.buffer.append("IF ");
        this.formatExpr(stmt.condition);
        this.buffer.append(" THEN ");
        this.context.put("isScriptContext", "1");
        this.enableSplitTag();
        for (int i = 0; i < stmt.trueStmtList.size(); ++i) {
            this.buffer.append("SET SQL_STR='");
            this.context.put("isScriptContext", "1");
            int pos = this.buffer.length();
            SqlStmt itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            this.formatStmt(block, itemStmt);
            this.buffer = this.handleComma(this.buffer, pos);
            this.handleSplitInIfStmt(this.buffer, pos);
            this.buffer.append("';");
            this.buffer.append("EXECUTE IMMEDIATE SQL_STR;");
            this.context.put("isScriptContext", null);
        }
        this.disableSplitTag();
        String reorgTable = this.getReorgTable();
        if (reorgTable != null) {
            this.buffer.append("call admin_cmd('REORG TABLE ");
            this.buffer.append(reorgTable);
            this.buffer.append("'); ");
            this.clearReorgTable();
        }
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            this.buffer.append("ELSE ");
            this.enableSplitTag();
            for (int i = 0; i < stmt.falseStmtList.size(); ++i) {
                this.buffer.append("SET SQL_STR='");
                this.context.put("isScriptContext", "1");
                int pos = this.buffer.length();
                SqlStmt itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                this.formatStmt(block, itemStmt);
                this.buffer = this.handleComma(this.buffer, pos);
                this.handleSplitInIfStmt(this.buffer, pos);
                this.buffer.append("';");
                this.buffer.append("EXECUTE IMMEDIATE SQL_STR;");
                this.context.put("isScriptContext", null);
            }
            this.disableSplitTag();
        }
        this.buffer.append("END IF; ");
        this.buffer.append("END;\r\n");
        this.buffer.append("CALL ");
        if (this.needTemporarySchema()) {
            this.buffer.append(schema);
            this.buffer.append(".");
        }
        this.buffer.append(tempProcedureName);
        this.buffer.append("();\r\n");
        this.buffer.append("DROP PROCEDURE ");
        if (this.needTemporarySchema()) {
            this.buffer.append(schema);
            this.buffer.append(".");
        }
        this.buffer.append(tempProcedureName);
        this.buffer.append(";");
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        this.formatIfStmt(null, stmt);
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.formatWhileStmt(null, stmt);
    }

    protected void formatWhileStmt(SqlBlockStmt block, SqlWhileStmt stmt) throws FormaterException {
        Integer loopCount = null;
        Map attrs = block.extendedAttributes();
        loopCount = (Integer)attrs.get("LOOP_COUNT");
        loopCount = loopCount == null ? Integer.valueOf(0) : Integer.valueOf(loopCount + 1);
        attrs.put("LOOP_COUNT", loopCount);
        attrs.put("CURRENT_LOOP_COUNT", loopCount);
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append(loopName);
        this.buffer.append(":\n");
        this.buffer.append("WHILE (");
        this.formatExpr(stmt.condition);
        this.buffer.append(") DO\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            if (itemStmt instanceof SqlBreakStmt) {
                this.formatBreakStmt(loopName, (SqlBreakStmt)itemStmt);
            } else {
                this.formatStmt(block, itemStmt);
            }
            this.buffer.append(";\n");
        }
        this.buffer.append("END WHILE");
        Map attrs2 = block.extendedAttributes();
        loopCount = (Integer)attrs2.get("LOOP_COUNT");
        if (loopCount != null) {
            loopCount = loopCount - 1;
            attrs2.put("CURRENT_LOOP_COUNT", loopCount);
        }
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.buffer.append("SET ");
        this.formatExpr(stmt.variant);
        this.buffer.append(" = ");
        this.formatExpr(stmt.value);
    }

    @Override
    protected void formatVarRef(SqlVarRefExpr expr) throws FormaterException {
        String name = expr.text;
        if (name != null && name.length() > 0 && name.charAt(0) == '@') {
            this.buffer.append(name);
        } else {
            this.buffer.append(expr.text);
        }
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("-- DEALLOCATE CURSOR ").append(stmt.curName);
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        this.formatCursorLoopStmt(null, stmt);
    }

    protected void formatCursorLoopStmt(SqlBlockStmt block, SqlCursorLoopStmt stmt) throws FormaterException {
        int i;
        Integer loopCount = null;
        Map attrs = block.extendedAttributes();
        loopCount = (Integer)attrs.get("LOOP_COUNT");
        loopCount = loopCount == null ? Integer.valueOf(0) : Integer.valueOf(loopCount + 1);
        attrs.put("LOOP_COUNT", loopCount);
        attrs.put("CURRENT_LOOP_COUNT", loopCount);
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append(loopName);
        this.buffer.append(":\n");
        SqlBlockStmt.DeclCurItem curItem = null;
        int size = block.declItemList.size();
        for (i = 0; i < size; ++i) {
            SqlBlockStmt.DeclItem item = (SqlBlockStmt.DeclItem)block.declItemList.get(i);
            if (!(item instanceof SqlBlockStmt.DeclCurItem) || !item.name.equals(stmt.curName)) continue;
            curItem = (SqlBlockStmt.DeclCurItem)item;
        }
        if (curItem == null) {
            throw new FormaterException("Error." + stmt.curName);
        }
        this.buffer.append("FOR ");
        this.buffer.append(stmt.curName);
        this.buffer.append(" AS ");
        this.formatSelectBase(curItem.select);
        this.buffer.append(" DO \n");
        for (i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            if (itemStmt instanceof SqlBreakStmt) {
                this.formatBreakStmt(loopName, (SqlBreakStmt)itemStmt);
            } else {
                this.formatStmt(block, itemStmt);
            }
            this.buffer.append(";\n");
        }
        this.buffer.append("END FOR");
        Map attrs2 = block.extendedAttributes();
        loopCount = (Integer)attrs2.get("LOOP_COUNT");
        if (loopCount != null) {
            loopCount = new Integer(loopCount - 1);
            attrs2.put("CURRENT_LOOP_COUNT", loopCount);
        }
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("not support format fetch statement");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("not support format break statement");
    }

    protected void formatBreakStmt(SqlBlockStmt block, SqlBreakStmt stmt) throws FormaterException {
        Integer loopCount = null;
        if (block != null) {
            Map attrs = block.extendedAttributes();
            loopCount = (Integer)attrs.get("CURRENT_LOOP_COUNT");
        }
        if (loopCount == null) {
            throw new FormaterException("Fatal Error.");
        }
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append("LEAVE ");
        this.buffer.append(loopName);
    }

    protected void formatBreakStmt(String loopName, SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("LEAVE ");
        this.buffer.append(loopName);
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("not support format continue statement");
    }

    protected void formatContinueStmt(SqlBlockStmt block, SqlContinueStmt stmt) throws FormaterException {
        Integer loopCount = null;
        if (block != null) {
            Map attrs = block.extendedAttributes();
            loopCount = (Integer)attrs.get("CURRENT_LOOP_COUNT");
        }
        if (loopCount == null) {
            throw new FormaterException("Fatal Error.");
        }
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append("ITERATE ");
        this.buffer.append(loopName);
    }

    protected void formatContinueStmt(String loopName, SqlContinueStmt stmt) throws FormaterException {
        this.buffer.append("ITERATE ");
        this.buffer.append(loopName);
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        this.buffer.append("GOTO ");
        this.buffer.append(stmt.name);
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("not support format label statement");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    @Override
    protected String getIndexName(SqlCreateIndexStmt stmt) {
        if (stmt.tableName != null && stmt.tableName.startsWith("GZT")) {
            return "session." + stmt.indexName;
        }
        return stmt.indexName;
    }

    @Override
    protected String formatTableName(String tableName) {
        if (tableName != null && tableName.startsWith("GZT")) {
            return "session." + tableName;
        }
        return tableName;
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            this.buffer.append(" PRIMARY KEY (");
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("not support constraint:" + constraint);
        }
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        } else {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(this.getIndexName(stmt));
        this.buffer.append(" ON ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.mode == 0) {
                DisCardUtil.discard();
            } else {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
        if (stmt.isCluster) {
            this.buffer.append(" CLUSTER");
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "TBNAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "NULLS";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "\"DEFAULT\"";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "TYPENAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "LENGTH";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "CTIME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "TBNAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "CONSTRAINTYP";
        } else if (ident.startsWith("GZT")) {
            ident = "session." + ident;
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase());
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "P";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "F";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "U";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "K";
        }
        this.buffer.append("'");
        if (this.context.get("toUpperCase") != null) {
            this.buffer.append(text.toUpperCase());
        } else {
            this.buffer.append(text);
        }
        this.buffer.append("'");
    }

    @Override
    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr instanceof SqlAllColumnExpr) {
            this.buffer.append("*");
        } else if (expr instanceof SqlIdentifierExpr) {
            this.formatIdentifierExpr(expr);
        } else if (expr instanceof SqlIntExpr) {
            this.buffer.append(((SqlIntExpr)expr).text);
        } else if (expr instanceof SqlLongExpr) {
            this.buffer.append(((SqlLongExpr)expr).text);
        } else if (expr instanceof SqlDoubleExpr) {
            this.buffer.append(((SqlDoubleExpr)expr).text);
        } else if (expr instanceof SqlBinaryOpExpr) {
            this.formatBinaryOpExpr((SqlBinaryOpExpr)expr, appendBrace);
        } else if (expr instanceof SqlMethodInvokeExpr) {
            this.formatMethodInvokeExpr((SqlMethodInvokeExpr)expr);
        } else if (expr instanceof SqlAggregateExpr) {
            this.formatAggregateExprExpr((SqlAggregateExpr)expr);
        } else if (expr instanceof SqlCharExpr) {
            this.formatChar((SqlCharExpr)expr);
        } else if (expr instanceof SqlNCharExpr) {
            this.formatNChar((SqlNCharExpr)expr);
        } else if (expr instanceof SqlVarRefExpr) {
            this.formatVarRef((SqlVarRefExpr)expr);
        } else if (expr instanceof SqlCaseExpr) {
            this.formatCaseExpr((SqlCaseExpr)expr);
        } else if (expr instanceof SqlInListExpr) {
            this.formatInListExpr((SqlInListExpr)expr);
        } else if (expr instanceof SqlExistsExpr) {
            this.formatExiststExpr((SqlExistsExpr)expr);
        } else if (expr instanceof SqlInSubQueryExpr) {
            this.formatInSubQueryExpr((SqlInSubQueryExpr)expr);
        } else if (expr instanceof SqlAllExpr) {
            this.formatAllExpr((SqlAllExpr)expr);
        } else if (expr instanceof SqlBetweenExpr) {
            this.formatBetweenExpr((SqlBetweenExpr)expr);
        } else if (expr instanceof SqlAnyExpr) {
            this.formatAnyExpr((SqlAnyExpr)expr);
        } else if (expr instanceof SqlSomeExpr) {
            this.formatSomeExpr((SqlSomeExpr)expr);
        } else if (expr instanceof SqlNullExpr) {
            this.formatNullExpr((SqlNullExpr)expr);
        } else if (expr instanceof SqlDateTimeExpr) {
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
        } else if (expr instanceof QueryExpr) {
            this.formatQueryExpr((QueryExpr)expr);
        } else if (expr instanceof SqlPriorIdentifierExpr) {
            this.formatPriorIdentifierExpr((SqlPriorIdentifierExpr)expr);
        } else if (expr instanceof SqlNotExpr) {
            this.formatNotExpr((SqlNotExpr)expr);
        } else if (expr.type == 28) {
            this.formatIdentityExpr(expr);
        } else {
            throw new FormaterException("not support Expr.  Type:" + expr.typename() + " , Value:" + expr.toString());
        }
    }

    protected void formatIdentityExpr(SqlExpr expr) {
        if (this.context.get("Identity") != null) {
            SqlIdentityExpr identityExpr = (SqlIdentityExpr)expr;
            StringBuilder createSequenceSql = new StringBuilder();
            this.context.put("Identity", identityExpr.name);
            createSequenceSql.append("CREATE SEQUENCE ");
            createSequenceSql.append(identityExpr.name);
            createSequenceSql.append(" START WITH ");
            createSequenceSql.append(identityExpr.seed);
            createSequenceSql.append(" INCREMENT BY ");
            createSequenceSql.append(identityExpr.increment);
            createSequenceSql.append(" NO MAXVALUE NO CYCLE CACHE 1000;\r\n");
            this.buffer.insert(0, createSequenceSql);
            this.buffer.append("NEXT VALUE FOR ");
            this.buffer.append(identityExpr.name);
        } else {
            this.context.put("Identity", "Identity");
            this.buffer.append("0");
        }
    }

    protected String sysSchema() {
        return this.sysSchema("");
    }

    protected String sysSchema(String key) {
        return "SYSIBM";
    }

    protected String constraintTable() {
        return "SYSTABCONST";
    }

    protected boolean needTemporarySchema() {
        return true;
    }

    protected boolean procedureBodyIsSQL() {
        return false;
    }

    @Override
    protected void afterFormat(StringBuilder buffer) {
        super.afterFormat(buffer);
        String reorgTable = this.getReorgTable();
        if (reorgTable != null) {
            boolean hasSemicolon;
            boolean bl = hasSemicolon = buffer.charAt(buffer.length() - 1) == ';';
            if (!hasSemicolon) {
                buffer.append(";");
            }
            buffer.append("\r\n");
            buffer.append("call admin_cmd('REORG TABLE ");
            buffer.append(reorgTable);
            buffer.append("')");
            if (hasSemicolon) {
                buffer.append(";");
            }
            this.clearReorgTable();
        }
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
    }
}

