/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Stack;

class FormaterStack {
    private final Stack<Item> stack = new Stack();

    FormaterStack() {
    }

    public void acquire() {
        this.stack.push(new Item());
    }

    public void release() {
        this.stack.pop();
    }

    public StringBuilder getBuffer(StringBuilder defaultBuffer) {
        if (this.stack.empty()) {
            return defaultBuffer;
        }
        Item item = this.stack.peek();
        while (item.next != null) {
            item = item.next;
        }
        return item.buf;
    }

    public StringBuilder acquireNewBuffer(StringBuilder defaultBuffer) {
        if (this.stack.empty()) {
            return defaultBuffer;
        }
        Item item = this.stack.peek();
        while (item.next != null) {
            item = item.next;
        }
        item.next = new Item();
        return item.next.buf;
    }

    public StringBuilder[] getBuffers() {
        if (this.stack.empty()) {
            return new StringBuilder[0];
        }
        Item item = this.stack.peek();
        if (item.next == null) {
            return new StringBuilder[]{item.buf};
        }
        ArrayList<StringBuilder> lst = new ArrayList<StringBuilder>(4);
        while (item != null) {
            lst.add(item.buf);
            item = item.next;
        }
        return lst.toArray(new StringBuilder[0]);
    }

    static class Item {
        private final StringBuilder buf;
        private Item next = null;

        private Item(StringBuilder buf) {
            this.buf = buf;
        }

        private Item() {
            this.buf = new StringBuilder();
        }

        Item next() {
            return this.next;
        }
    }
}

