/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kd.bos.ksql.CONSTANT;
import kd.bos.ksql.datatype.DataType;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.KHints;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlDelete;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropViewStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.schema.KSQLSchemaContext;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public class Gauss200SQLFormater
extends SQLFormater {
    private boolean saveColumnName2Context = true;

    public Gauss200SQLFormater() {
        this(null);
    }

    public Gauss200SQLFormater(StringBuilder sb) {
        super(sb);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        KSQLSchemaContext schemaContext;
        String sql = "select table_name as name from information_schema.tables where table_schema ='public' and table_type = 'BASE TABLE' order by table_name";
        if (CONSTANT.CONNECTION_SHARD && (schemaContext = KSQLSchemaContext.get()) != null) {
            sql = sql.replace("public", schemaContext.getSchema());
        }
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        KSQLSchemaContext schemaContext;
        String sql = "select column_name, data_type, character_maximum_length default_length, numeric_precision as data_precision,numeric_scale data_scale, is_nullable nullable, table_name  from information_schema.columns where table_schema ='public' ";
        if (CONSTANT.CONNECTION_SHARD && (schemaContext = KSQLSchemaContext.get()) != null) {
            sql = sql.replace("public", schemaContext.getSchema());
        }
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            sql = sql + "and table_name = '" + stmt.tableName.toLowerCase() + "' ";
        }
        this.buffer.append(sql);
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        this.buffer.append("CALL ");
        this.buffer.append(stmt.processName);
        this.buffer.append(" (");
        if (stmt.paramList.size() != 0) {
            boolean flag = false;
            for (Object expr : stmt.paramList) {
                if (flag) {
                    this.buffer.append(", ");
                }
                this.formatExpr((SqlExpr)expr);
                flag = true;
            }
        }
        this.buffer.append(')');
    }

    @Override
    protected void formatDropViewStmt(SqlDropViewStmt stmt) throws FormaterException {
        this.buffer.append("DROP VIEW ");
        this.buffer.append(stmt.viewName);
        this.buffer.append(" CASCADE ");
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name == null) {
            throw new FormaterException("column name is null");
        }
        if (this.max_length_of_constraint_name != -1 && column.name != null && column.name.length() > this.max_length_of_constraint_name) {
            throw new FormaterException("column name greate than " + this.max_length_of_column_name + ", column name is '" + column.name + "'");
        }
        this.buffer.append(column.name.toLowerCase());
        this.buffer.append(" ");
        this.addColumnDataType(column);
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected final void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName.toLowerCase());
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDefForAlterColumn(alterColumnDefItem.columnDef);
            this.formatColumnDefForAlterColumnNotNull(stmt, alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(addDefaultItem.columnName);
            this.buffer.append(" SET DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append(" DROP DEFAULT");
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        if (expr.getYear() < 10) {
            this.buffer.append("'0");
        } else {
            this.buffer.append("'");
        }
        this.buffer.append(expr.getYear());
        if (expr.getMonth() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getMonth());
        if (expr.getDate() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getDate());
        if (expr.getHour() < 10) {
            this.buffer.append(" 0");
        } else {
            this.buffer.append(" ");
        }
        this.buffer.append(expr.getHour());
        if (expr.getMinute() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getMinute());
        if (expr.getSecond() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getSecond());
        this.buffer.append("'");
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        this.saveColumnName2Context = this.saveColumnName2Context && this.options != null && this.options.isSaveColumnName2Context();
        ArrayList<String> realColumnNames = new ArrayList<String>();
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            boolean currentSaveColumnName2Context;
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlCharExpr || item.expr instanceof SqlNCharExpr) {
                    this.buffer.append("CAST(");
                    this.formatExpr(item.expr);
                    this.buffer.append(" AS VARCHAR)");
                } else {
                    currentSaveColumnName2Context = this.saveColumnName2Context;
                    if (currentSaveColumnName2Context) {
                        this.saveColumnName2Context = false;
                    }
                    this.formatExpr(item.expr);
                    if (currentSaveColumnName2Context) {
                        this.saveColumnName2Context = true;
                    }
                }
                this.buffer.append(" AS ");
                this.buffer.append(item.alias.toLowerCase());
                if (this.saveColumnName2Context) {
                    realColumnNames.add(this.parseRealNameOrAlias(item.alias).toUpperCase());
                }
            } else {
                currentSaveColumnName2Context = this.saveColumnName2Context;
                if (currentSaveColumnName2Context) {
                    this.saveColumnName2Context = false;
                }
                this.formatExpr(item.expr, false);
                if (currentSaveColumnName2Context) {
                    this.saveColumnName2Context = true;
                }
                if (this.saveColumnName2Context) {
                    String columnName = item.expr.type == 4 ? this.parseRealNameOrAlias(item.expr.toString()) : (item.expr.type == 0 ? this.parseRealNameOrAlias(((SqlBinaryOpExpr)item.expr).right.toString()) : item.expr.toString());
                    if (columnName.startsWith(Token.MulToken.value)) {
                        this.saveColumnName2Context = false;
                    }
                    realColumnNames.add(columnName);
                }
            }
            flag = true;
        }
        if (this.formaterContext.getProperty("realColumnNames") == null && this.saveColumnName2Context) {
            this.formaterContext.setProperty("realColumnNames", realColumnNames);
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (CONSTANT.CONNECTION_SHARD && select.tableSource != null && select.tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)select.tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value) || simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value) || simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append(" and table_schema = '").append(KSQLSchemaContext.get().getSchema()).append("'");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append(" and schemaname = '").append(KSQLSchemaContext.get().getSchema()).append("'");
            }
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null && select.limit.rowCount != -1) {
            this.buffer.append(" LIMIT ");
            this.buffer.append(select.limit.rowCount);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
            if (select.limit.offset != 0) {
                this.buffer.append(" OFFSET ");
                this.buffer.append(select.limit.offset);
            }
        }
    }

    private String parseRealNameOrAlias(String columnName) {
        boolean removeFirstAndLast = columnName.charAt(0) == '\"' && columnName.charAt(columnName.length() - 1) == '\"';
        boolean bl = removeFirstAndLast = removeFirstAndLast || columnName.charAt(0) == '[' && columnName.charAt(columnName.length() - 1) == ']';
        if (removeFirstAndLast) {
            columnName = columnName.substring(1, columnName.length() - 1);
        }
        return columnName;
    }

    public boolean formatSelectColumnList(SqlSelect select) throws FormaterException {
        boolean flag = false;
        ArrayList<String> realColumnNames = new ArrayList<String>();
        boolean hasStar = false;
        Iterator iterator = select.selectList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlCharExpr || item.expr instanceof SqlNCharExpr) {
                    this.buffer.append("CAST(");
                    this.formatExpr(item.expr);
                    this.buffer.append(" AS VARCHAR)");
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" AS ");
                this.buffer.append(item.alias.toLowerCase());
                realColumnNames.add(item.alias);
            } else {
                this.formatExpr(item.expr, false);
                realColumnNames.add(item.expr.toString());
            }
            flag = true;
        }
        if (this.formaterContext.getProperty("realColumnNames") != null) {
            this.formaterContext.setProperty("realColumnNames", realColumnNames);
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" % ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            SqlExpr thirdExpr = (SqlExpr)expr.parameters.get(2);
            if (!(thirdExpr instanceof SqlIntExpr)) {
                throw new FormaterException("ERROR");
            }
            int val = Integer.parseInt(((SqlIntExpr)thirdExpr).text);
            if (val == 0) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            this.buffer.append("TRUNC(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        } else {
            if (methodNameI.compareToIgnoreCase("SIGN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIGN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SIN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SQRT") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SQRT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("TAN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("TAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CONVERT") == 0) {
                if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) return;
                SqlIdentifierExpr identExpr = (SqlIdentifierExpr)expr.parameters.get(0);
                if (identExpr.value.compareToIgnoreCase("DATETIME") == 0) {
                    this.buffer.append("TO_TIMESTAMP(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                    return;
                }
                if (identExpr.value.compareToIgnoreCase("VARCHAR") != 0 && identExpr.value.compareToIgnoreCase("NVARCHAR") != 0 && identExpr.value.compareToIgnoreCase("CHAR") != 0 && identExpr.value.compareToIgnoreCase("NCHAR") != 0) throw new FormaterException("TODO");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                return;
            }
            if (methodNameI.compareTo("CURDATE") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("current_date");
                return;
            }
            if (methodNameI.compareTo("CURTIME") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("now()");
                return;
            }
            if (methodNameI.compareTo("DATEADD") == 0) {
                if (expr.parameters.size() == 2) {
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" + ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" * ").append("interval ");
                    this.buffer.append("'1 second'");
                    return;
                }
                if (expr.parameters.size() != 3) return;
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" * interval '1 ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("'");
                return;
            }
            if (methodNameI.compareTo("DATEDIFF") == 0) {
                if (expr.parameters.size() == 2) {
                    this.buffer.append("trunc(date_part('epoch',(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" - ");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")))");
                    return;
                }
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
                String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                if (datepart == null || datepart.length() == 0) {
                    throw new FormaterException("illegal datepart.");
                }
                if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                    this.buffer.append("date_part('year',age(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(",");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append("))");
                    return;
                }
                if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    this.buffer.append("(date_part('year',age(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(",");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append("))*12 ");
                    this.buffer.append(" + date_part('month',age(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(",");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")))");
                    return;
                }
                if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    this.buffer.append("date_part('day',(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" - ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append("))");
                    return;
                }
                if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                    this.buffer.append("date_part('day',(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" - ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")) *24");
                    return;
                }
                if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    this.buffer.append("date_part('day',(");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(" - ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")) *24 *60");
                    return;
                }
                if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                this.buffer.append("date_part('day',(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" - ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")) *24 *60 *60");
                return;
            }
            if (methodNameI.compareTo("DATENAME") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
                String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                if (datepart == null || datepart.length() == 0) {
                    throw new FormaterException("illegal datepart.");
                }
                if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                    this.buffer.append("DATE_PART('year', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    this.buffer.append("DATE_PART('month', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("QUARTER".equals(datepart) || "QQ".equals(datepart) || "Q".equals(datepart)) {
                    this.buffer.append("DATE_PART('quarter', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("DAYOFYEAR".equals(datepart) || "DY".equals(datepart) || "Y".equals(datepart)) {
                    this.buffer.append("DATE_PART('doy', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    this.buffer.append("DATE_PART('day', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("WEEK".equals(datepart) || "WK".equals(datepart) || "WW".equals(datepart)) {
                    this.buffer.append("DATE_PART('week', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(") + 1");
                    return;
                }
                if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                    this.buffer.append("DATE_PART('hour', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    this.buffer.append("DATE_PART('minute', ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                this.buffer.append("DATE_PART('second', ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("DAYNAME") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 'Day')");
                return;
            }
            if (methodNameI.compareTo("DAYOFMONTH") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('day', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("DAYOFWEEK") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('isodow', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("DAYOFYEAR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('doy', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("GETDATE") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("LOCALTIMESTAMP");
                return;
            }
            if (methodNameI.compareTo("HOUR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('hour', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("MINUTE") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('minute', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("MONTH") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('month', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("MONTHNAME") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("to_char(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(",'Month')");
                return;
            }
            if (methodNameI.compareTo("NOW") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("LOCALTIMESTAMP");
                return;
            }
            if (methodNameI.compareTo("QUARTER") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('quarter', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SECOND") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('second', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("WEEK") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('week', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("YEAR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("DATE_PART('year', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("TO_DATE") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS TIMESTAMP)");
                return;
            }
            if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("DATEDIFF(MM, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("ADD_MONTHS") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("(date_trunc('second',");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(") + interval '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" month')");
                return;
            }
            if (methodNameI.compareTo("ADD_YEARS") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                if (!(expr.parameters.get(0) instanceof SqlBinaryOpExpr) && !(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                    throw new FormaterException("ADD_YEARS parameter(0) error");
                }
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" + '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" year'");
                return;
            }
            if (methodNameI.compareTo("ADD_DAYS") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                if (!(expr.parameters.get(0) instanceof SqlBinaryOpExpr) && !(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                    throw new FormaterException("ADD_DAYS parameter(0) error");
                }
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" + '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" day'");
                return;
            }
            if (methodNameI.compareTo("ADD_HOURS") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                if (!(expr.parameters.get(0) instanceof SqlBinaryOpExpr) && !(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                    throw new FormaterException("ADD_HOURS parameter(0) error");
                }
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" + '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" hour'");
                return;
            }
            if (methodNameI.compareTo("ADD_MINUTES") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                if (!(expr.parameters.get(0) instanceof SqlBinaryOpExpr) && !(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                    throw new FormaterException("ADD_MINUTES parameter(0) error");
                }
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" + '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" minute'");
                return;
            }
            if (methodNameI.compareTo("ADD_SECONDS") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                if (!(expr.parameters.get(0) instanceof SqlBinaryOpExpr) && !(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                    throw new FormaterException("ADD_SECONDS parameter(0) error");
                }
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" + '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" second'");
                return;
            }
            if (methodNameI.compareTo("ASCII") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("ASCII(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CHAR") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CHR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareToIgnoreCase("CHARINDEX") == 0) {
                if (expr.parameters.size() == 2) {
                    this.buffer.append("POSITION(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" IN ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                this.buffer.append("POSITION(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" IN ");
                this.buffer.append("SUBSTRING(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" from ");
                this.buffer.append((SqlExpr)expr.parameters.get(2));
                this.buffer.append("))");
                return;
            }
            if (methodNameI.compareTo("NEWID") == 0) {
                if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                this.buffer.append("LOWER(NEWID())");
                return;
            }
            if (methodNameI.compareTo("NEWBOSID") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
                this.buffer.append("NEWBOSID(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CONCAT") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
                this.buffer.append("CONCAT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareToIgnoreCase("LEFT") == 0) {
                if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                this.buffer.append("SUBSTR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 0, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LEN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CHAR_LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LENGTH") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("CHAR_LENGTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LOWER") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LOWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LCASE") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LOWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("LTRIM") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("LTRIM(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("REPLACE") == 0) {
                if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                this.buffer.append("REPLACE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")");
                return;
            } else {
                if (methodNameI.compareTo("RIGHT") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("RIGHT(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("RTRIM") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("RTRIM(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("SOUNDEX") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("SOUNDEX(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("SUBSTRING") == 0) {
                    if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                    this.buffer.append("SUBSTRING(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TRIM") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("LTRIM(RTRIM(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append("))");
                    return;
                }
                if (methodNameI.compareTo("UCASE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("UPPER(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("UPPER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("UPPER(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
                    if (expr.parameters.size() == 1) {
                        this.buffer.append("CAST(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" AS VARCHAR)");
                        return;
                    }
                    if (expr.parameters.size() == 2 && ((SqlCharExpr)expr.parameters.get((int)1)).text.compareToIgnoreCase("YYYY-MM-DD") == 0) {
                        this.buffer.append("TO_CHAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", 'YYYY-MM-DD')");
                        return;
                    }
                    if (expr.parameters.size() == 2 && ((SqlCharExpr)expr.parameters.get((int)1)).text.compareToIgnoreCase("YYYY-MM-DD HH24:MI:SS") == 0) {
                        this.buffer.append("TO_CHAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                        return;
                    }
                    if (expr.parameters.size() == 2 && ((SqlCharExpr)expr.parameters.get((int)1)).text.compareToIgnoreCase("YYYY-MM-DD HH24:MI:SS.FF9") == 0) {
                        this.buffer.append("TO_CHAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS.FF9')");
                        return;
                    }
                    if (expr.parameters.size() != 3 || ((SqlCharExpr)expr.parameters.get((int)1)).text.compareToIgnoreCase("NUMBER") != 0) throw new FormaterException("not support function " + methodNameI);
                    if (expr.parameters.get(2).getClass() == SqlCharExpr.class) {
                        this.buffer.append("TO_CHAR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(")");
                        return;
                    }
                    if (expr.parameters.get(2).getClass() != SqlIntExpr.class) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
                    this.buffer.append("Trim(TO_CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", '999999999999999999999999999990D");
                    int precision = ((SqlIntExpr)expr.parameters.get((int)2)).value;
                    for (int i = 0; i < precision; ++i) {
                        this.buffer.append("9");
                    }
                    this.buffer.append("'))");
                    return;
                }
                if (methodNameI.compareTo("ISNULL") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("CASE WHEN ");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" IS NULL THEN ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" ELSE ");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" END");
                    return;
                }
                if (methodNameI.compareTo("NULLIF") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                    this.buffer.append("NULLIF(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (methodNameI.compareTo("TO_NUMBER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS FLOAT)");
                    return;
                }
                if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                    this.buffer.append("CAST(CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS FLOAT) AS INTEGER)");
                    return;
                }
                if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
                    if (expr.parameters.size() == 1) {
                        this.buffer.append("CAST(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" AS DECIMAL)");
                        return;
                    }
                    if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS DECIMAL(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", ");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append("))");
                    return;
                }
                if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
                    SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
                    String type = cexpr.text;
                    type = DataType.getDataType(5).nativeType(type);
                    this.formatExpr(new SqlCharExpr(type));
                    return;
                }
                if (methodNameI.compareTo("FIND_IN_SET") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append(expr.parameters.get(0));
                    this.buffer.append(" =any(?) ");
                    return;
                } else if (methodNameI.compareTo("NOT_FIND_IN_SET") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append(expr.parameters.get(0));
                    this.buffer.append(" !=any(?) ");
                    return;
                } else if (methodNameI.compareTo("ST_ASTEXT") == 0) {
                    if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append("ST_ASTEXT");
                    this.buffer.append("(").append(expr.parameters.get(0));
                    this.buffer.append(")");
                    return;
                } else if (methodNameI.compareTo("ST_DISTANCE") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append("ST_DISTANCE");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(",");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                } else if (methodNameI.compareTo("ST_POINT") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append("ST_POINT");
                    this.buffer.append("(").append(expr.parameters.get(0));
                    this.buffer.append(",").append(expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                } else if (methodNameI.compareTo("ST_SETSRID") == 0) {
                    if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
                    this.buffer.append("ST_SETSRID");
                    this.buffer.append("(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(",").append(expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                } else {
                    this.formeatUnkownMethodInvokeExpr(expr);
                }
            }
        }
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.right instanceof SqlCharExpr && expr.left instanceof SqlIdentifierExpr) {
                String ident = ((SqlIdentifierExpr)expr.left).value.toUpperCase(Locale.ENGLISH);
                if (Token.KSQL_COL_NAME.value.equals(ident) || Token.KSQL_COL_DEFAULT.value.equals(ident) || Token.KSQL_COL_TABNAME.value.equals(ident) || Token.INDNAME.value.equals(ident) || Token.TABNAME.value.equals(ident) || Token.KSQL_CONS_NAME.value.equals(ident) || Token.KSQL_CONS_TABNAME.value.equals(ident) || Token.KSQL_CONS_TYPE.value.equals(ident)) {
                    this.formatChar((SqlCharExpr)expr.right, true);
                } else {
                    this.formatExpr(expr.right);
                }
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 1) {
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                String alias = ((SqlIdentifierExpr)expr.right).value.toLowerCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                String alias = ((SqlCharExpr)expr.right).text.toLowerCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                String alias = ((SqlNCharExpr)expr.right).text.toLowerCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" || ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 45: {
                this.buffer.append(" ILIKE ");
                break;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 46: {
                this.buffer.append(" NOT ILIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE");
        int temporary_table_type = 0;
        if (UUTN.isGlobalTempTable(stmt.name)) {
            this.buffer.append(" TEMPORARY");
            stmt.name = stmt.name.substring(2);
            temporary_table_type = 1;
        } else if (UUTN.isTempTable(stmt.name)) {
            this.buffer.append(" TEMPORARY");
            stmt.name = stmt.name.substring(1);
            temporary_table_type = 2;
        }
        this.buffer.append(" TABLE ");
        this.buffer.append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        if (temporary_table_type == 1) {
            this.buffer.append(" ON COMMIT DELETE ROWS ");
        } else if (temporary_table_type == 2) {
            this.buffer.append(" ON COMMIT PRESERVE ROWS ");
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("information_schema.tables");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("information_schema.columns");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("pg_indexes");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("information_schema.table_constraints");
            } else {
                this.buffer.append(simpleTableSource.name.toLowerCase());
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toLowerCase());
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toLowerCase());
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        throw new FormaterException("Not Support. PriorIdentifierExpr");
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        } else {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(stmt.indexName);
        this.buffer.append(" ON ");
        this.buffer.append(stmt.tableName);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.mode == 1) {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
    }

    @Override
    protected void formatChar(SqlCharExpr expr) {
        this.formatChar(expr, false);
    }

    private void formatChar(SqlCharExpr expr, boolean toLower) {
        String text = toLower ? expr.text.toLowerCase() : expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "P";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "R";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "U";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "C";
        }
        this.buffer.append("'");
        this.buffer.append(text);
        this.buffer.append("'");
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "column_name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "table_name";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "indexname";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = this.buffer.toString().toLowerCase().contains("pg_indexes") ? "tablename" : (!this.buffer.toString().toLowerCase().contains("where") ? "table_name" : "table_schema = current_schema() and table_name");
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "constraint_name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "table_name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "data_default";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "is_nullable";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "constraint_type";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "character_maximum_length";
        }
        if (!ident.isEmpty() && ident.startsWith("\"")) {
            this.buffer.append(ident.toLowerCase());
        } else if (ident.equalsIgnoreCase("KSQL_SEQ")) {
            this.formatIdentity(expr);
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    public void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        String tableName = this.formatTableName(insert.tableName);
        this.buffer.append(tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            boolean hasRowNum = false;
            while (iterator.hasNext()) {
                Object colItem = iterator.next();
                if (colItem instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    if (!hasRowNum) {
                        if (flag) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(identExpr.value);
                    }
                } else if (colItem instanceof String) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = !hasRowNum || flag;
                hasRowNum = false;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery);
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(update.updateTable.name);
        if (update.updateTable.alias != null) {
            this.buffer.append(" ");
            this.buffer.append(update.updateTable.alias);
        }
        this.buffer.append(" SET ");
        boolean flag = false;
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (flag) {
                this.buffer.append(", ");
            }
            this.formateUpdateItem(abstract_item);
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("not support");
        }
        boolean whereFlag = false;
        if (update.condition != null) {
            whereFlag = true;
            this.buffer.append(" WHERE ");
            this.formatExpr(update.condition);
        }
        if (!KHints.containHint(update.getHints(), "NOT_GEN_EXISTS")) {
            for (AbstractUpdateItem abstract_item : update.updateList) {
                if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
                if (whereFlag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                    whereFlag = true;
                }
                this.buffer.append("EXISTS (");
                this.formatSelectBase(((SubQueryUpdateItem)abstract_item).subQuery);
                this.buffer.append(")");
            }
        }
    }

    private SqlExpr replaceLiteral(SqlExpr expr, Map literalMap) {
        if (expr instanceof SqlBinaryOpExpr) {
            expr = this.replaceLiteral((SqlBinaryOpExpr)expr, literalMap);
        }
        return expr;
    }

    private SqlExpr replaceLiteral(SqlBinaryOpExpr expr, Map literalMap) {
        if (expr.left instanceof SqlIdentifierExpr && expr.right instanceof SqlIdentifierExpr && expr.operator == 20) {
            SqlIdentifierExpr leftIdentExpr = (SqlIdentifierExpr)expr.left;
            SqlIdentifierExpr rightIdentExpr = (SqlIdentifierExpr)expr.right;
            String name = leftIdentExpr.value.toLowerCase() + "." + rightIdentExpr.value.toLowerCase();
            SqlExpr literalExpr = (SqlExpr)literalMap.get(name);
            if (literalExpr != null) {
                return literalExpr;
            }
        } else {
            expr.left = this.replaceLiteral(expr.left, literalMap);
            expr.right = this.replaceLiteral(expr.right, literalMap);
        }
        return expr;
    }

    @Override
    protected void formatDeleteStmt(SqlDeleteStmt stmt) throws FormaterException {
        SqlDelete delete = stmt.delete;
        this.buffer.append("DELETE ");
        if (delete.tableName != null && delete.tableName.length() > 0) {
            if (delete.tableSource != null) {
                this.buffer.append(" FROM ");
                this.buffer.append(delete.tableName);
                this.buffer.append(" using ");
                this.formatTableSource(delete.tableSource);
                if (delete.condition != null) {
                    this.buffer.append(" AND ");
                    this.formatExpr(delete.condition);
                }
            } else {
                this.buffer.append("FROM ");
                this.buffer.append(this.formatTableName(delete.tableName));
                if (delete.condition != null) {
                    this.buffer.append(" WHERE ");
                    this.formatExpr(delete.condition);
                }
            }
        } else {
            this.buffer.append("FROM ");
            if (delete.tableSource != null) {
                if (delete.tableSource.getClass() == SqlJoinedTableSource.class) {
                    this.FormatDeleteUsing(delete.tableSource);
                    if (delete.condition != null) {
                        this.buffer.append(" AND ");
                        this.formatExpr(delete.condition);
                    }
                } else {
                    this.FormatDeleteUsing(delete.tableSource);
                    if (delete.condition != null) {
                        this.buffer.append(" WHERE ");
                        this.formatExpr(delete.condition);
                    }
                }
            }
        }
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        SqlStmt itemStmt;
        int i;
        this.buffer.append("DO $do$ BEGIN ");
        this.buffer.append("IF ");
        this.formatExpr(stmt.condition);
        this.buffer.append(" THEN\n");
        for (i = 0; i < stmt.trueStmtList.size(); ++i) {
            itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            this.buffer.append("ELSE\n");
            for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                this.formatStmt(itemStmt);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END IF; END $do$;");
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            this.buffer.append(" PRIMARY KEY (");
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
        this.buffer.append(" Serial ");
    }

    protected void formatColumnDefForAlterColumnNotNull(SqlAlterTableStmt stmt, SqlColumnDef column) throws FormaterException {
        if ((column.allowNull == null || column.allowNull != Boolean.TRUE) && column.allowNull != null && column.allowNull == Boolean.FALSE && this.buffer.indexOf(" INTEGER") < 0) {
            this.buffer.append(";ALTER TABLE ").append(stmt.tableName.toLowerCase()).append(" ALTER COLUMN ");
            this.buffer.append(column.name.toLowerCase());
            this.buffer.append(" set NOT NULL");
        }
    }

    protected void formatColumnDefForAlterColumn(SqlColumnDef column) throws FormaterException {
        if (column.name == null) {
            throw new FormaterException("column name is null");
        }
        if (this.max_length_of_constraint_name != -1 && column.name != null && column.name.length() > this.max_length_of_constraint_name) {
            throw new FormaterException("column name greate than " + this.max_length_of_column_name + ", column name is '" + column.name + "'");
        }
        this.buffer.append(column.name.toLowerCase());
        this.buffer.append(" type ");
        this.addColumnDataType(column);
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    private void addColumnDataType(SqlColumnDef column) throws FormaterException {
        if (column.dataType.equalsIgnoreCase("BIGINT") || column.dataType.equalsIgnoreCase("INT8")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("BIGSERIAL") || column.dataType.equalsIgnoreCase("SERIAL8")) {
            this.buffer.append("BIGSERIAL");
        } else if (column.dataType.equalsIgnoreCase("BIT")) {
            this.buffer.append("BIT (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BIT VARYING") || column.dataType.equalsIgnoreCase("VARBIT")) {
            this.buffer.append("BIT VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BOOLEAN") || column.dataType.equalsIgnoreCase("BOOL")) {
            this.buffer.append("BOOLEAN");
        } else if (column.dataType.equalsIgnoreCase("BOX")) {
            this.buffer.append("BOX");
        } else if (column.dataType.equalsIgnoreCase("BYTEA")) {
            this.buffer.append("BYTEA");
        } else if (column.dataType.equalsIgnoreCase("CHARACTER") || column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHARACTER (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHARACTER VARYING") || column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("CHARACTER VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CIDR")) {
            this.buffer.append("CIDR");
        } else if (column.dataType.equalsIgnoreCase("CIRCLE")) {
            this.buffer.append("CIRCLE");
        } else if (column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("DATE");
        } else if (column.dataType.equalsIgnoreCase("DOUBLE PRECISION")) {
            this.buffer.append("DOUBLE PRECISION");
        } else if (column.dataType.equalsIgnoreCase("INET")) {
            this.buffer.append("INET");
        } else if (column.dataType.equalsIgnoreCase("INTEGER") || column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INT4")) {
            if (column.autoIncrement) {
                this.buffer.append("SERIAL");
            } else {
                this.buffer.append("INTEGER");
            }
        } else if (column.dataType.equalsIgnoreCase("INTERVAL")) {
            this.buffer.append("INTERVAL (");
            this.buffer.append(column.precision);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("LINE")) {
            this.buffer.append("LINE");
        } else if (column.dataType.equalsIgnoreCase("LSEG")) {
            this.buffer.append("LSEG");
        } else if (column.dataType.equalsIgnoreCase("MACADDR")) {
            this.buffer.append("MACADDR");
        } else if (column.dataType.equalsIgnoreCase("MONEY")) {
            this.buffer.append("MONEY");
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("PATH")) {
            this.buffer.append("PATH");
        } else if (column.dataType.equalsIgnoreCase("POINT")) {
            this.buffer.append("POINT");
        } else if (column.dataType.equalsIgnoreCase("POLYGON")) {
            this.buffer.append("POLYGON");
        } else if (column.dataType.equalsIgnoreCase("REAL") || column.dataType.equalsIgnoreCase("FLOAT4")) {
            this.buffer.append("REAL");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT") || column.dataType.equalsIgnoreCase("INT2")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("SERIAL") || column.dataType.equalsIgnoreCase("SERIAL4")) {
            this.buffer.append("SERIAL");
        } else if (column.dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("TIME") || column.dataType.equalsIgnoreCase("TIME WITHOUT TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIME WITHOUT TIME ZONE");
            } else {
                this.buffer.append("TIME (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITHOUT TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMETZ") || column.dataType.equalsIgnoreCase("TIME WITH TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIME WITH TIME ZONE");
            } else {
                this.buffer.append("TIME (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITH TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMP") || column.dataType.equalsIgnoreCase("TIMESTAMP WITHOUT TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIMESTAMP WITHOUT TIME ZONE");
            } else {
                this.buffer.append("TIMESTAMP (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITHOUT TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMPZ") || column.dataType.equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIMESTAMP WITH TIME ZONE");
            } else {
                this.buffer.append("TIMESTAMP (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITH TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BYTEA");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP WITHOUT TIME ZONE");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("CHARACTER (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("BIT VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BYTEA");
        } else if (column.dataType.equalsIgnoreCase("XMLTYPE") || column.dataType.equalsIgnoreCase("XML")) {
            this.buffer.append("xml");
        } else if (column.dataType.equalsIgnoreCase("GEOMETRY") || column.dataType.equalsIgnoreCase("GEOGRAPHY")) {
            this.buffer.append(column.dataType);
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
    }

    protected void formatValueKSQL_COL_NULLABLE(SqlBinaryOpExpr expr) {
        SqlCharExpr charExpr = (SqlCharExpr)expr.right;
        if (charExpr.text.equalsIgnoreCase("Y")) {
            this.buffer.append("'YES'");
        } else if (charExpr.text.equalsIgnoreCase("N")) {
            this.buffer.append("'NO'");
        } else {
            throw new NotSupportedException("unexpected expression: " + expr.toString());
        }
    }

    private void FormatDeleteUsing(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource.getClass() == SqlTableSource.class) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            String sAlias = "";
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("(select table_name, case when table_type = 'BASE TABLE' then 'U' else 'V' end table_xtype from information_schema.tables)");
                sAlias = " AS KSQL_USERTABLES";
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("(SELECT table_name, column_name, ordinal_position AS column_id, data_type, 0 data_length, NUMERIC_PRECISION DATA_PRECISION, NUMERIC_SCALE DATA_SCALE, IS_NULLABLE AS NULLABLE, COLUMN_DEFAULT AS DATA_DEFAULT FROM information_schema.columns)");
                sAlias = " AS KSQL_USERCOLUMNS";
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("(SELECT bc.relname AS table_name, ic.relname AS index_name FROM pg_namespace n, pg_class bc, pg_class ic, pg_index i WHERE bc.relnamespace = n.oid and i.indrelid = bc.oid and i.indexrelid = ic.oid and n.nspname = 'public')");
                sAlias = " AS KSQL_INDEXES";
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("(SELECT table_name, CONSTRAINT_NAME, CONSTRAINT_TYPE, NULL AS COLUMN_ID FROM information_schema.table_constraints)");
                sAlias = " AS KSQL_CONSTRAINTS";
            } else {
                String name = simpleTableSource.name.toLowerCase();
                this.buffer.append(name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toLowerCase());
            } else {
                this.buffer.append(sAlias);
            }
        } else if (tableSource.getClass() == SqlJoinedTableSource.class) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 0: {
                    this.buffer.append(" using ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" where ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource.getClass() == SqlSubQueryTableSource.class) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toLowerCase());
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatInListExpr(SqlInListExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        Iterator iterator = expr.targetList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlExpr exprItem = (SqlExpr)iterator.next();
            if (expr.expr instanceof SqlIdentifierExpr) {
                String ident = ((SqlIdentifierExpr)expr.expr).value.toUpperCase(Locale.ENGLISH);
                if ((Token.KSQL_COL_NAME.value.equals(ident) || Token.KSQL_COL_DEFAULT.value.equals(ident) || Token.KSQL_COL_TABNAME.value.equals(ident) || Token.INDNAME.value.equals(ident) || Token.TABNAME.value.equals(ident) || Token.KSQL_CONS_NAME.value.equals(ident) || Token.KSQL_CONS_TABNAME.value.equals(ident) || Token.KSQL_CONS_TYPE.value.equals(ident)) && exprItem instanceof SqlCharExpr) {
                    this.formatChar((SqlCharExpr)exprItem, true);
                } else {
                    this.formatExpr(exprItem);
                }
            } else {
                this.formatExpr(exprItem);
            }
            flag = true;
        }
        this.buffer.append(")");
    }
}

