/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SqlUpdateItem;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.JavaObjectValueExpr;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlAllExpr;
import kd.bos.ksql.dom.expr.SqlAnyExpr;
import kd.bos.ksql.dom.expr.SqlBetweenExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCaseExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlEmptyExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlIdentityExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNotExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlSomeExpr;
import kd.bos.ksql.dom.expr.SqlVarRefExpr;
import kd.bos.ksql.dom.expr.SqlXinListExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public abstract class TSQLFormater
extends SQLFormater {
    public TSQLFormater() {
        super(null);
    }

    public TSQLFormater(StringBuilder sb) {
        super(sb);
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        this.buffer.append("EXEC ");
        this.buffer.append(stmt.processName);
        if (stmt.paramList.size() != 0) {
            this.buffer.append(" ");
            boolean flag = false;
            Iterator iter = stmt.paramList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iter.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void formateUpdateItem(AbstractUpdateItem abstract_item) throws FormaterException {
        if (abstract_item instanceof SqlUpdateItem) {
            SqlUpdateItem item = (SqlUpdateItem)abstract_item;
            this.buffer.append(this.formatColumnName(item.name));
            this.buffer.append(" = ");
            this.formatExpr(item.expr);
            return;
        } else {
            if (!(abstract_item instanceof SubQueryUpdateItem)) throw new FormaterException("unexpect update item: '" + abstract_item + "'");
            SubQueryUpdateItem queryItem = (SubQueryUpdateItem)abstract_item;
            if (queryItem.columnList.size() != 1) throw new FormaterException("unexpect column list size: '" + queryItem.columnList.size() + "'");
            String column = (String)queryItem.columnList.get(0);
            this.buffer.append(this.formatColumnName(column));
            this.buffer.append(" = (");
            this.formatSelectBase(queryItem.subQuery);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        int i;
        SubQueryUpdateItem queryItem;
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        if (update.updateTable.alias != null) {
            this.buffer.append(update.updateTable.alias.toUpperCase());
        } else {
            this.buffer.append(this.formatTableName(update.updateTable.name));
        }
        this.buffer.append(" SET ");
        Iterator iterator = update.updateList.iterator();
        ArrayList<AbstractUpdateItem> subqueryUpdateItemList = new ArrayList<AbstractUpdateItem>();
        int count = 0;
        boolean flag = false;
        while (iterator.hasNext()) {
            AbstractUpdateItem abstract_item = (AbstractUpdateItem)iterator.next();
            if (flag) {
                this.buffer.append(", ");
            }
            if (abstract_item instanceof SqlUpdateItem) {
                SqlUpdateItem item = (SqlUpdateItem)abstract_item;
                this.buffer.append(this.formatColumnName(item.name));
                this.buffer.append(" = ");
                this.formatExpr(item.expr);
            } else if (abstract_item instanceof SubQueryUpdateItem) {
                queryItem = (SubQueryUpdateItem)abstract_item;
                subqueryUpdateItemList.add(abstract_item);
                for (int i2 = 0; i2 < queryItem.columnList.size(); ++i2) {
                    String column = (String)queryItem.columnList.get(i2);
                    if (i2 != 0) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(this.formatColumnName(column));
                    this.buffer.append(" = ");
                    if (!(queryItem.subQuery instanceof SqlSelect)) {
                        throw new FormaterException("unexpect subquery item: '" + queryItem.subQuery + "'");
                    }
                    SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                    SqlSelectItem subSelectItem = (SqlSelectItem)subQuerySelect.selectList.get(i2);
                    this.formatExpr(subSelectItem.expr, false);
                    ++count;
                    flag = true;
                }
            } else {
                throw new FormaterException("unexpect update item: '" + abstract_item + "'");
            }
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("update's tableSource is null");
        }
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            if (i == 0) {
                this.buffer.append(" FROM ");
                if (update.updateTable.alias != null) {
                    this.buffer.append(this.formatTableName(update.updateTable.name));
                    this.buffer.append(" ").append(update.updateTable.alias.toUpperCase()).append(", ");
                }
            } else {
                this.buffer.append(", ");
            }
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (!(queryItem.subQuery instanceof SqlSelect)) {
                throw new FormaterException("unexpect queryItem subQuery: '" + queryItem + "'");
            }
            SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
            this.formatTableSource(subQuerySelect.tableSource);
        }
        flag = false;
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (subQuerySelect.condition == null) continue;
                if (flag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                }
                this.formatExpr(subQuerySelect.condition);
                flag = true;
                continue;
            }
            throw new FormaterException("not support query item:" + queryItem);
        }
        if (update.condition != null) {
            if (flag) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(" WHERE ");
            }
            this.formatExpr(update.condition);
            flag = true;
        }
    }

    protected boolean replaceUpdateStmt(SqlUpdate update) throws FormaterException {
        SubQueryUpdateItem queryItem;
        Map<String, String> updateTableAliasMap = null;
        boolean firstFlag = true;
        boolean updateSelf = false;
        ArrayList<AbstractUpdateItem> subqueryUpdateItemList = new ArrayList<AbstractUpdateItem>();
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
            subqueryUpdateItemList.add(abstract_item);
        }
        for (int i = 0; i < subqueryUpdateItemList.size(); ++i) {
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (update.updateTable.alias == null) continue;
                if (subQuerySelect.tableSource instanceof SqlJoinedTableSource) {
                    SqlTableSourceBase tableSourceBase = subQuerySelect.tableSource;
                    if (tableSourceBase instanceof SqlJoinedTableSource) {
                        updateTableAliasMap = new HashMap();
                        updateTableAliasMap = this.getUpdateStmtReplaceMap(update, updateTableAliasMap, (SqlJoinedTableSource)tableSourceBase, firstFlag);
                        if (!updateSelf) {
                            updateSelf = this.isUpdateSelf(update, (SqlJoinedTableSource)tableSourceBase);
                        }
                    }
                    if (updateTableAliasMap == null) continue;
                    this.replaceUpdateTableAlias(subQuerySelect.tableSource, updateTableAliasMap);
                    continue;
                }
                if (!(subQuerySelect.tableSource instanceof SqlTableSource)) continue;
                SqlTableSource sts = (SqlTableSource)subQuerySelect.tableSource;
                if (!update.updateTable.name.equals(sts.name)) continue;
                if (updateTableAliasMap == null) {
                    updateTableAliasMap = new HashMap();
                }
                updateTableAliasMap.put(subQuerySelect.tableSource.alias, update.updateTable.alias.toUpperCase());
                subQuerySelect.tableSource.alias = update.updateTable.alias.toUpperCase();
                updateSelf = true;
                continue;
            }
            throw new FormaterException("unexpect subQuery item: '" + queryItem + "'");
        }
        if (!updateSelf) {
            return false;
        }
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
            queryItem = (SubQueryUpdateItem)abstract_item;
            for (int i = 0; i < queryItem.columnList.size(); ++i) {
                if (queryItem.subQuery instanceof SqlSelect) {
                    SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                    SqlSelectItem subSelectItem = (SqlSelectItem)subQuerySelect.selectList.get(i);
                    if (updateTableAliasMap == null) continue;
                    this.replaceExpr(subSelectItem.expr, updateTableAliasMap);
                    continue;
                }
                throw new FormaterException("unexpect subQuery item: '" + queryItem + "'");
            }
        }
        for (int i = 0; i < subqueryUpdateItemList.size(); ++i) {
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (subQuerySelect.condition == null || updateTableAliasMap == null) continue;
                this.replaceExpr(subQuerySelect.condition, updateTableAliasMap);
                firstFlag = false;
                continue;
            }
            throw new FormaterException("unexpect subQuery item: '" + queryItem + "'");
        }
        return updateSelf;
    }

    private boolean isUpdateSelf(SqlUpdate update, SqlJoinedTableSource joinTableSource) {
        SqlTableSource ts;
        if (joinTableSource.left instanceof SqlJoinedTableSource) {
            if (this.isUpdateSelf(update, (SqlJoinedTableSource)joinTableSource.left)) {
                return true;
            }
        } else if (joinTableSource.left instanceof SqlTableSource) {
            ts = (SqlTableSource)joinTableSource.left;
            if (ts.name.equalsIgnoreCase(update.updateTable.name)) {
                return true;
            }
        }
        if (joinTableSource.right instanceof SqlJoinedTableSource) {
            if (this.isUpdateSelf(update, (SqlJoinedTableSource)joinTableSource.right)) {
                return true;
            }
        } else if (joinTableSource.right instanceof SqlTableSource) {
            ts = (SqlTableSource)joinTableSource.right;
            if (ts.name.equalsIgnoreCase(update.updateTable.name)) {
                return true;
            }
        }
        return false;
    }

    private Map getUpdateStmtReplaceMap(SqlUpdate update, Map updateTableAliasMap, SqlJoinedTableSource joinTableSource, boolean firstFlag) {
        if (joinTableSource.left instanceof SqlJoinedTableSource) {
            this.getUpdateStmtReplaceMap(update, updateTableAliasMap, (SqlJoinedTableSource)joinTableSource.left, firstFlag);
        } else if (joinTableSource.left instanceof SqlTableSource) {
            SqlTableSource tsl = (SqlTableSource)joinTableSource.left;
            if (tsl.alias == null && update.updateTable.alias != null && tsl.name.equalsIgnoreCase(update.updateTable.name) && firstFlag) {
                tsl.alias = update.updateTable.alias;
                firstFlag = false;
            } else if (tsl.name.equalsIgnoreCase(update.updateTable.name) && tsl.alias != null && update.updateTable.alias != null && !tsl.alias.equalsIgnoreCase(update.updateTable.alias) && firstFlag) {
                updateTableAliasMap.put(tsl.alias.toUpperCase(), update.updateTable.alias.toUpperCase());
                firstFlag = false;
            }
        }
        if (joinTableSource.right instanceof SqlJoinedTableSource) {
            this.getUpdateStmtReplaceMap(update, updateTableAliasMap, (SqlJoinedTableSource)joinTableSource.right, firstFlag);
        } else if (joinTableSource.right instanceof SqlTableSource) {
            SqlTableSource tsr = (SqlTableSource)joinTableSource.right;
            if (tsr.alias == null && update.updateTable.alias != null && tsr.name.equalsIgnoreCase(update.updateTable.name) && firstFlag) {
                tsr.alias = update.updateTable.alias;
                firstFlag = false;
            } else if (tsr.name.equalsIgnoreCase(update.updateTable.name) && tsr.alias != null && update.updateTable.alias != null && !tsr.alias.equalsIgnoreCase(update.updateTable.alias) && firstFlag) {
                updateTableAliasMap.put(tsr.alias.toUpperCase(), update.updateTable.alias.toUpperCase());
                firstFlag = false;
            }
        }
        return updateTableAliasMap;
    }

    protected void formatAlterTableStmtOld(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnDef));
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnDef));
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" ADD CONSTRAINT ");
            this.buffer.append("DEF_").append(stmt.tableName.toUpperCase()).append("_").append(addDefaultItem.columnName.toUpperCase());
            this.buffer.append(" DEFAULT ");
            this.formatExpr(addDefaultItem.value);
            this.buffer.append(" FOR ");
            this.buffer.append(addDefaultItem.columnName);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            int offsetIndex = this.buffer.length() - stmt.tableName.length() - 12;
            this.buffer.delete(offsetIndex, this.buffer.length());
            this.buffer.append("EXEC drop_defaulcons '");
            this.buffer.append(stmt.tableName);
            this.buffer.append("', '");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append("'");
        } else {
            throw new FormaterException("unexpect statement: '" + stmt + "'");
        }
    }

    @Override
    protected void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        if (stmt.items == null || stmt.items.size() <= 1) {
            this.formatAlterTableStmtOld(stmt);
            return;
        }
        Iterator itemsIterator = stmt.items.iterator();
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        while (itemsIterator.hasNext()) {
            StringBuilder oldBuffer;
            Object columnDef;
            Iterator iterator;
            Object obj;
            if (!flag) {
                sb.append("EXEC xalter_table '").append(this.formatTableName(stmt.tableName)).append("', '(");
            }
            if (flag) {
                sb.append("), (");
            }
            if ((obj = itemsIterator.next()) instanceof SqlAlterTableAddItem) {
                StringBuilder oldBuffer2;
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)obj;
                sb.append(" ADD ");
                iterator = addColumnDefItem.columnDefItemList.iterator();
                boolean addItemFlag = false;
                while (iterator.hasNext()) {
                    if (addItemFlag) {
                        sb.append(", ");
                    }
                    columnDef = (SqlColumnDef)iterator.next();
                    oldBuffer2 = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatColumnDef((SqlColumnDef)columnDef);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer2;
                    addItemFlag = true;
                }
                iterator = addColumnDefItem.constraintItemList.iterator();
                flag = false;
                while (iterator.hasNext()) {
                    SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                    try {
                        oldBuffer2 = this.buffer;
                        this.buffer = new StringBuilder();
                        this.formatTableConstraint(constraint);
                        sb.append((CharSequence)this.buffer);
                        this.buffer = oldBuffer2;
                    }
                    catch (FormaterException ex) {
                        throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                    }
                }
            } else if (obj instanceof SqlAlterTableAlterColumnItem) {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)obj;
                sb.append(" ALTER COLUMN ");
                oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatColumnDef(alterColumnDefItem.columnDef);
                sb.append((CharSequence)this.buffer);
                this.buffer = oldBuffer;
            } else if (obj instanceof SqlAlterTableDropItem) {
                SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)obj;
                sb.append(" DROP ");
                iterator = dropColumnDefItem.columnDefItemList.iterator();
                boolean dropItemlag = false;
                while (iterator.hasNext()) {
                    if (dropItemlag) {
                        sb.append(", ");
                    } else {
                        sb.append("COLUMN ");
                    }
                    columnDef = (String)iterator.next();
                    sb.append(this.formatColumnName((String)columnDef));
                    dropItemlag = true;
                }
                iterator = dropColumnDefItem.constraintItemList.iterator();
                dropItemlag = false;
                while (iterator.hasNext()) {
                    if (dropItemlag) {
                        sb.append(", ");
                    } else {
                        sb.append("CONSTRAINT ");
                    }
                    columnDef = (String)iterator.next();
                    sb.append(this.formatColumnName((String)columnDef));
                    dropItemlag = true;
                }
            } else if (obj instanceof SqlAlterTableAddDefaultItem) {
                SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)obj;
                sb.append(" ADD CONSTRAINT ");
                sb.append("DEF_").append(stmt.tableName.toUpperCase()).append("_").append(addDefaultItem.columnName.toUpperCase());
                sb.append(" DEFAULT ");
                oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatExpr(addDefaultItem.value);
                sb.append(this.buffer.toString().replaceAll("'", "''"));
                this.buffer = oldBuffer;
                sb.append(" FOR ");
                sb.append(addDefaultItem.columnName);
            } else if (obj instanceof SqlAlterTableDropDefaultItem) {
                SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.items.get(0);
                this.buffer.append("EXEC drop_defaulcons '");
                this.buffer.append(stmt.tableName);
                this.buffer.append("', '");
                this.buffer.append(dropDefaultItem.columnName);
                this.buffer.append("'");
                flag = false;
                break;
            }
            flag = true;
        }
        if (flag) {
            this.buffer.append((CharSequence)sb);
            this.buffer.append(")'");
        }
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE TABLE ");
        this.buffer.append(this.formatTableName(stmt.name));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        Map optionMap = select.getOptionMapDirect();
        this.buffer.append("SELECT ");
        boolean flag2 = false;
        if (select.distinct == 1 && select.orderBy.size() != 0) {
            flag2 = this.checkHaveChineseOrderBy(select.orderBy);
        }
        select.selectItemAliasMap = null;
        if (this.checkHaveChineseOrderBy(select.orderBy)) {
            select.selectItemAliasMap = new HashMap();
            for (SqlSelectItem selectItem : select.selectList) {
                if (selectItem.alias == null || selectItem.alias.length() <= 0) continue;
                select.selectItemAliasMap.put(selectItem.alias.toUpperCase(), selectItem.expr);
            }
        }
        this.formatSelectDistinct(select);
        this.formatSelectLimit(select);
        if (flag2) {
            this.buffer.append("* ");
            this.formatSelectInto(select);
            this.buffer.append("FROM ( SELECT TOP 2147483647 ");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        boolean sysTableFlag = false;
        boolean sysIndexFlag = false;
        boolean sysConstraintFlag = false;
        while (iterator.hasNext()) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block86: {
                block84: {
                    block96: {
                        block95: {
                            block94: {
                                block93: {
                                    block92: {
                                        block91: {
                                            block90: {
                                                block89: {
                                                    block88: {
                                                        block87: {
                                                            block85: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)iterator.next();
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block84;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block85;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block86;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block87;
                                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                                            break block86;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block88;
                                                        item.alias = Token.KSQL_COL_NULLABLE.value;
                                                        break block86;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block89;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block86;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block90;
                                                item.alias = Token.KSQL_COL_LENGTH.value;
                                                break block86;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block91;
                                            item.alias = Token.KSQL_COL_TYPE.value;
                                            break block86;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block92;
                                        sysTableFlag = true;
                                        item.alias = Token.TABNAME.value;
                                        break block86;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block93;
                                    sysTableFlag = true;
                                    item.alias = Token.KSQL_CREATETIME.value;
                                    break block86;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block94;
                                sysIndexFlag = true;
                                item.alias = Token.INDNAME.value;
                                break block86;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block95;
                            sysConstraintFlag = true;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block86;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block96;
                        sysConstraintFlag = true;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block86;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block86;
                    sysConstraintFlag = true;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block86;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "syscol.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "cdefault";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "isnullable";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "sysobj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            sysTableFlag = true;
                            ((SqlIdentifierExpr)param).value = "sysobj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                            sysTableFlag = true;
                            ((SqlIdentifierExpr)param).value = "sysobj.crdate";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            sysIndexFlag = true;
                            ((SqlIdentifierExpr)param).value = "name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "const_obj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "table_obj.name";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) continue;
                        sysConstraintFlag = true;
                        ((SqlIdentifierExpr)param).value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "syscol.name";
                        this.formatExpr(columnNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "cdefault";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "sysobj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "isnullable";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysTableFlag = true;
                        tableNameExpr.value = "sysobj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysTableFlag = true;
                        tableNameExpr.value = "sysobj.crdate";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysIndexFlag = true;
                        tableNameExpr.value = "name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "const_obj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "table_obj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                        this.formatExpr(tableNameExpr, true);
                    } else {
                        this.formatExpr(item.expr, true);
                    }
                } else {
                    this.formatExpr(item.expr, true);
                }
                if (item.expr instanceof SqlCharExpr || item.expr instanceof SqlNCharExpr) {
                    this.buffer.append(" COLLATE Chinese_PRC_CS_AS");
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "syscol.name";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "cdefault";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "isnullable";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.crdate";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "const_obj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "table_obj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (!flag2) {
            this.formatSelectInto(select);
        }
        this.formatSelectTabSrc(select);
        this.formatSelectCondition(select, sysTableFlag, sysIndexFlag, sysConstraintFlag);
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        this.formatSelectGroupBy(select);
        this.formatSelectHaving(select);
        this.formatSelectOrderBy(select);
        if (optionMap != null && optionMap.size() != 0) {
            this.buffer.append(" OPTION (");
            for (Map.Entry entry : optionMap.entrySet()) {
                String key = (String)entry.getKey();
                if ("HASH GROUP".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH GROUP");
                    continue;
                }
                if ("ORDER GROUP".equalsIgnoreCase(key)) {
                    this.buffer.append(" ORDER GROUP");
                    continue;
                }
                if ("CONCAT UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" CONCAT UNION");
                    continue;
                }
                if ("HASH UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH UNION");
                    continue;
                }
                if ("MERGE UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" MERGE UNION");
                    continue;
                }
                if ("LOOP JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" LOOP JOIN");
                    continue;
                }
                if ("MERGE JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" MERGE JOIN");
                    continue;
                }
                if ("HASH JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH JOIN");
                    continue;
                }
                if ("FAST".equalsIgnoreCase(key)) {
                    this.buffer.append(" FAST ");
                    this.buffer.append(entry.getValue());
                    continue;
                }
                if ("FASTFIRSTROW".equalsIgnoreCase(key)) {
                    this.buffer.append(" FASTFIRSTROW");
                    continue;
                }
                if ("FORCE ORDER".equalsIgnoreCase(key) || "ORDERED".equalsIgnoreCase(key)) {
                    this.buffer.append(" FORCE ORDER");
                    continue;
                }
                if ("MAXDOP".equalsIgnoreCase(key)) {
                    this.buffer.append(" MAXDOP ");
                    this.buffer.append(entry.getValue());
                    continue;
                }
                if ("ROBUST PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" ROBUST PLAN");
                    continue;
                }
                if ("KEEP PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" KEEP PLAN");
                    continue;
                }
                if ("KEEPFIXED PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" KEEPFIXED PLAN");
                    continue;
                }
                if (!"EXPAND VIEWS".equalsIgnoreCase(key)) continue;
                this.buffer.append(" EXPAND VIEWS");
            }
            this.buffer.append(")");
        }
        if (flag2) {
            this.buffer.append(") ");
            this.buffer.append(new UUTN().toString());
        }
    }

    private void formatSelectGroupBy(SqlSelect select) throws FormaterException {
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            boolean flag = false;
            Iterator iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(" WITH ROLLUP");
            }
        }
    }

    private void formatSelectHaving(SqlSelect select) throws FormaterException {
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
    }

    private void formatSelectOrderBy(SqlSelect select) throws FormaterException {
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            boolean flag = false;
            Iterator iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                String ident;
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                SqlExpr expr = orderByIterm.expr;
                if (orderByIterm.chineseOrderByMode != -1 && orderByIterm.expr instanceof SqlIdentifierExpr && select.selectItemAliasMap.containsKey(ident = ((SqlIdentifierExpr)orderByIterm.expr).value.toUpperCase()) && !((expr = (SqlExpr)select.selectItemAliasMap.get(ident)) instanceof SqlIdentifierExpr) && !(expr instanceof SqlBinaryOpExpr)) {
                    expr = orderByIterm.expr;
                }
                this.formatExpr(expr);
                if (orderByIterm.chineseOrderByMode != -1) {
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append(" COLLATE ");
                        this.buffer.append("Chinese_PRC_CI_AS");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append(" COLLATE ");
                        this.buffer.append("Chinese_PRC_STROKE_CI_AS");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        DisCardUtil.discard();
                    }
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
    }

    private void formatSelectCondition(SqlSelect select, boolean sysTableFlag, boolean sysIndexFlag, boolean sysConstraintFlag) throws FormaterException {
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            if (sysTableFlag) {
                this.buffer.append("(XTYPE='U' OR XTYPE='V') AND ");
            } else if (sysIndexFlag) {
                this.buffer.append("INDID >0 AND INDID <255 AND ");
            } else if (sysConstraintFlag) {
                this.buffer.append("");
            }
            this.formatExpr(select.condition);
        } else if (sysTableFlag) {
            this.buffer.append(" WHERE (XTYPE='U' OR XTYPE='V')");
        } else if (sysIndexFlag) {
            this.buffer.append(" WHERE INDID >0 AND INDID <255");
        } else if (sysConstraintFlag) {
            this.buffer.append("");
        }
    }

    private void formatSelectTabSrc(SqlSelect select) throws FormaterException {
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
    }

    private void formatSelectInto(SqlSelect select) {
        if (select.into != null) {
            this.buffer.append(" INTO ");
            this.buffer.append(this.formatTableName(select.into.new_table));
        }
    }

    private void formatSelectLimit(SqlSelect select) {
        if (select.limit != null) {
            this.buffer.append("TOP ");
            this.buffer.append(select.limit.rowCount);
            this.buffer.append(" ");
            if (select.limit.type == 1) {
                this.buffer.append("PERCENT ");
            }
        }
    }

    private void formatSelectDistinct(SqlSelect select) throws FormaterException {
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("unexpect distinct option.");
        }
    }

    protected void replaceUpdateTableAlias(SqlTableSourceBase tableSource, Map updateTableAliasMap) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            if (tableSource.alias != null && updateTableAliasMap.get(tableSource.alias.toUpperCase()) != null) {
                tableSource.alias = (String)updateTableAliasMap.get(tableSource.alias.toUpperCase());
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.replaceUpdateTableAlias(joinedTable.left, updateTableAliasMap);
            this.replaceUpdateTableAlias(joinedTable.right, updateTableAliasMap);
            if (joinedTable.condition != null) {
                this.replaceExpr(joinedTable.condition, updateTableAliasMap);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("unexpect tableSource: '" + tableSource + "'");
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.isVariableTable()) {
                this.buffer.append(" ? ");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("sysobjects sysobj");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("syscolumns syscol left join sysobjects sysobj on syscol.id = sysobj.id left join systypes systype on syscol.xtype=systype.xtype");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("sysindexes sysind INNER JOIN sysobjects SYSOBJ ON SYSOBJ.id = sysind.id and SYSOBJ.xtype = 'U' ");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("sysconstraints const left join sysobjects const_obj on const.constid = const_obj.id left join sysobjects table_obj on const.id = table_obj.id");
            } else {
                this.buffer.append(this.formatTableName(simpleTableSource.name));
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias);
                if (this.buffer.indexOf("DELETE FROM " + this.formatTableName(simpleTableSource.name)) == 0 && this.buffer.indexOf("WHERE") < 0) {
                    this.buffer.insert(7, this.formatTableName(simpleTableSource.name) + " ");
                }
            }
            if (simpleTableSource.lockingHint != null && simpleTableSource.lockingHint.length() > 0) {
                this.buffer.append(" WITH (");
                this.buffer.append(simpleTableSource.lockingHint.toUpperCase());
                this.buffer.append(")");
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("unexpect Join Type: '" + joinedTable.joinType + "'");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias);
            }
        } else {
            throw new FormaterException("unexpect tableSource: '" + tableSource + "'");
        }
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        boolean binaryOpWithEscape;
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            if (expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                this.buffer.append(" = 0)");
                return;
            }
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            if (expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                this.buffer.append(" <> 0)");
                return;
            }
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formaterContext.setProperty("binaryOpWithEscape", "true");
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            this.formaterContext.setProperty("binaryOpWithEscape", "false");
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.right.type == 5 && expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                this.formatValueKSQL_COL_NULLABLE(expr);
                return;
            }
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 1) {
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                String alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                String alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                String alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        if (binaryOpWithEscape = Boolean.parseBoolean((String)this.formaterContext.getProperty("binaryOpWithEscape"))) {
            this.formatExpr(expr.left, false);
        } else {
            this.formatExpr(expr.left);
        }
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 4: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 5: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" + ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                this.context.put("like_predicate", "1");
                break;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                this.context.put("like_predicate", "1");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("unexpect BinaryOpType: '" + expr.operator + "'");
            }
        }
        this.formatExpr(expr.right);
        this.context.put("like_predicate", "0");
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected final void formatDropIndexStmt(SqlDropIndexStmt stmt) throws FormaterException {
        this.buffer.append("DROP INDEX ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        this.buffer.append(".");
        this.buffer.append(this.formateIndexName(stmt.indexName));
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("'");
        if (expr.timeType() == -19000) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        } else if (expr.timeType() == -19001) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
        } else if (expr.timeType() == -19002) {
            this.buffer.append(expr.getHour() < 10 ? "0" : "");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        }
        this.buffer.append("'");
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        throw new FormaterException("Not Support. PriorIdentifierExpr");
    }

    @Override
    protected void formatAggregateExprExpr(SqlAggregateExpr expr) throws FormaterException {
        this.buffer.append(expr.methodName);
        this.buffer.append("(");
        if (expr.option == 0) {
            this.buffer.append("DISTINCT ");
        }
        Iterator iterator = expr.paramList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlExpr param = (SqlExpr)iterator.next();
            this.formatExpr(param, false);
            flag = true;
        }
        this.buffer.append(")");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(this.formatConstraintName(constraint.name));
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            if (primaryKey.clustered) {
                this.buffer.append(" PRIMARY KEY (");
            } else {
                this.buffer.append(" PRIMARY KEY NONCLUSTERED (");
            }
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnName));
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnName));
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(this.formatColumnName(columnName));
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(this.formatTableName(foreignKey.refTableName));
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(this.formatColumnName(refColumnName));
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("unexpect constraint: '" + constraint + "'");
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "syscol.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "cdefault";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "isnullable";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "sysobj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "length";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "systype.name";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "name";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "sysobj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "sysobj.crdate";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "const_obj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "table_obj.name";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "const_obj.xtype";
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase());
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "PK";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "F";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "UQ";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "C";
        }
        if (this.context.get("like_predicate") != null && this.context.get("like_predicate").equals("1")) {
            text = text.replaceAll("\\[", "[[]");
            this.context.put("like_predicate", "0");
        }
        this.buffer.append("'");
        this.buffer.append(text);
        this.buffer.append("'");
    }

    @Override
    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr.type == 8) {
            this.buffer.append("*");
        } else if (expr.type == 4) {
            this.formatIdentifierExpr(expr);
        } else if (expr.type == 1) {
            this.buffer.append(((SqlIntExpr)expr).text);
        } else if (expr.type == 27) {
            this.buffer.append(((SqlLongExpr)expr).text);
        } else if (expr.type == 2) {
            this.buffer.append(((SqlDoubleExpr)expr).text);
        } else if (expr.type == 0) {
            this.formatBinaryOpExpr((SqlBinaryOpExpr)expr, appendBrace);
        } else if (expr.type == 10) {
            this.formatMethodInvokeExpr((SqlMethodInvokeExpr)expr);
        } else if (expr.type == 11) {
            this.formatAggregateExprExpr((SqlAggregateExpr)expr);
        } else if (expr.type == 5) {
            this.formatChar((SqlCharExpr)expr);
        } else if (expr.type == 6) {
            this.formatNChar((SqlNCharExpr)expr);
        } else if (expr.type == 3) {
            this.formatVarRef((SqlVarRefExpr)expr);
        } else if (expr.type == 12) {
            this.formatCaseExpr((SqlCaseExpr)expr);
        } else if (expr.type == 14) {
            this.formatInListExpr((SqlInListExpr)expr);
        } else if (expr.type == 30) {
            this.formatXinListExpr((SqlXinListExpr)expr);
        } else if (expr.type == 15) {
            this.formatExiststExpr((SqlExistsExpr)expr);
        } else if (expr.type == 13) {
            this.formatInSubQueryExpr((SqlInSubQueryExpr)expr);
        } else if (expr.type == 16) {
            this.formatAllExpr((SqlAllExpr)expr);
        } else if (expr.type == 17) {
            this.formatBetweenExpr((SqlBetweenExpr)expr);
        } else if (expr.type == 18) {
            this.formatAnyExpr((SqlAnyExpr)expr);
        } else if (expr.type == 19) {
            this.formatSomeExpr((SqlSomeExpr)expr);
        } else if (expr.type == 20) {
            this.formatNullExpr((SqlNullExpr)expr);
        } else if (expr.type == 29) {
            this.formatEmptyExpr((SqlEmptyExpr)expr);
        } else if (expr.type == 21) {
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
        } else if (expr.type == 24) {
            this.formatQueryExpr((QueryExpr)expr);
        } else if (expr.type == 25) {
            this.formatPriorIdentifierExpr((SqlPriorIdentifierExpr)expr);
        } else if (expr.type == 9) {
            this.formatNotExpr((SqlNotExpr)expr);
        } else if (expr.type == 26) {
            JavaObjectValueExpr java_value_expr = (JavaObjectValueExpr)expr;
            Object val = java_value_expr.value;
            if (val == null) {
                this.buffer.append("NULL");
            } else if (val instanceof String) {
                String str_val = (String)val;
                str_val = str_val.replaceAll("'", "''");
                this.buffer.append(str_val);
            } else if (val instanceof Calendar) {
                Calendar calendar = (Calendar)val;
                this.buffer.append("{").append(calendar.get(1)).append("-").append(calendar.get(2) + 1).append("-").append(calendar.get(5)).append(" ").append(calendar.get(11)).append(":").append(calendar.get(12)).append(":").append(calendar.get(13)).append("}");
            } else {
                this.buffer.append(val.toString());
            }
        } else if (expr.type == 28) {
            this.formatIdentityExpr(expr);
        } else {
            throw new FormaterException("unexpect expression: '" + expr + "'");
        }
    }

    protected void formatIdentityExpr(SqlExpr sqlexpr) throws FormaterException {
        SqlIdentityExpr expr = (SqlIdentityExpr)sqlexpr;
        this.buffer.append("IDENTITY(");
        this.formatDataType(expr.dataType);
        this.buffer.append(", ");
        this.buffer.append(expr.seed);
        this.buffer.append(", ");
        this.buffer.append(expr.increment);
        this.buffer.append(")");
    }

    public void formatDataType(String dataType) throws FormaterException {
        if (dataType.equalsIgnoreCase("BIGINT")) {
            this.buffer.append("BIGINT");
        } else if (dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BINARY");
        } else if (dataType.equalsIgnoreCase("BIT")) {
            this.buffer.append("BIT");
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR");
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("DATETIME");
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL");
        } else if (dataType.equalsIgnoreCase("FLOAT")) {
            this.buffer.append("FLOAT");
        } else if (dataType.equalsIgnoreCase("IMAGE")) {
            this.buffer.append("IMAGE");
        } else if (dataType.equalsIgnoreCase("INT")) {
            this.buffer.append("INT");
        } else if (dataType.equalsIgnoreCase("MONEY")) {
            this.buffer.append("MONEY");
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR");
        } else if (dataType.equalsIgnoreCase("NTEXT")) {
            this.buffer.append("NTEXT");
        } else if (dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC");
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("NVARCHAR");
        } else if (dataType.equalsIgnoreCase("REAL")) {
            this.buffer.append("REAL");
        } else if (dataType.equalsIgnoreCase("SMALLDATETIME")) {
            this.buffer.append("SMALLDATETIME");
        } else if (dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("SMALLINT");
        } else if (dataType.equalsIgnoreCase("SMALLMONEY")) {
            this.buffer.append("SMALLMONEY");
        } else if (dataType.equalsIgnoreCase("SQL_VARIANT")) {
            this.buffer.append("SQL_VARIANT");
        } else if (dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("TEXT");
        } else if (dataType.equalsIgnoreCase("TIMESTAMP")) {
            this.buffer.append("TIMESTAMP");
        } else if (dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("TINYINT");
        } else if (dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            this.buffer.append("UNIQUEIDENTIFIER");
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR");
        } else if (dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARBINARY");
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("IMAGE");
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("TEXT");
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NTEXT");
        } else {
            this.buffer.append(dataType);
        }
    }

    protected void formatValueKSQL_COL_NULLABLE(SqlBinaryOpExpr expr) {
        SqlCharExpr charExpr = (SqlCharExpr)expr.right;
        if (charExpr.text.equalsIgnoreCase("Y")) {
            this.buffer.append("1");
        } else if (charExpr.text.equalsIgnoreCase("N")) {
            this.buffer.append("0");
        } else {
            throw new NotSupportedException("unexpected expression: " + expr.toString());
        }
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
        this.buffer.append(" Identity(int,1,1) ");
    }
}

