/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.ksql.CONSTANT;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlDelete;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SqlUpdateItem;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlCommentStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.procedures.tidb.AlterColumnProcedure;
import kd.bos.ksql.procedures.tidb.AlterPKProcedure;
import kd.bos.ksql.procedures.tidb.CommentProcedure;
import kd.bos.ksql.procedures.tidb.DropIndexProcedure;
import kd.bos.ksql.procedures.tidb.ModifyObjectNameProcedure;
import kd.bos.ksql.schema.KSQLSchemaContext;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public class TiDBFormater
extends SQLFormater {
    static int tempColIndex = 1;
    static int tempTabIndex = 1;
    private static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    protected TiDBFormater() {
        super(null);
    }

    public TiDBFormater(StringBuilder sb) {
        super(sb);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        KSQLSchemaContext schemaContext;
        String sql = "SHOW TABLES";
        this.buffer.append(sql);
        if (CONSTANT.CONNECTION_SHARD && (schemaContext = KSQLSchemaContext.get()) != null) {
            this.buffer.append(" FROM ").append(schemaContext.getSchema());
        }
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        KSQLSchemaContext schemaContext;
        String sql = "SHOW COLUMNS FROM " + stmt.tableName;
        this.buffer.append(sql);
        if (CONSTANT.CONNECTION_SHARD && (schemaContext = KSQLSchemaContext.get()) != null) {
            this.buffer.append(" FROM ").append(schemaContext.getSchema());
        }
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        Statement statement = (Statement)this.formaterContext.getProperty("stmt");
        String processName = stmt.processName.toUpperCase(Locale.ENGLISH);
        List paramList = stmt.paramList;
        try {
            switch (processName) {
                case "P_DROPIDX": {
                    DropIndexProcedure.call(statement, ((SqlCharExpr)paramList.get((int)0)).text, ((SqlCharExpr)paramList.get((int)1)).text);
                    break;
                }
                case "P_MODIFYOBJECTNAME": {
                    ModifyObjectNameProcedure.call(statement, ((SqlCharExpr)paramList.get((int)0)).text, ((SqlCharExpr)paramList.get((int)1)).text, ((SqlCharExpr)paramList.get((int)2)).text, ((SqlCharExpr)paramList.get((int)3)).text, ((SqlCharExpr)paramList.get((int)4)).text);
                    break;
                }
                case "P_ALTERCOLUMN": {
                    AlterColumnProcedure.call(statement, ((SqlCharExpr)paramList.get((int)0)).text, ((SqlCharExpr)paramList.get((int)1)).text, ((SqlCharExpr)paramList.get((int)2)).text, ((SqlCharExpr)paramList.get((int)3)).text, ((SqlCharExpr)paramList.get((int)4)).text, ((SqlCharExpr)paramList.get((int)5)).text);
                    break;
                }
                case "P_ALTERPK": {
                    String isClustered = null;
                    if (paramList.get(3) instanceof SqlIntExpr) {
                        isClustered = ((SqlIntExpr)paramList.get((int)3)).text;
                    } else if (paramList.get(3) instanceof SqlCharExpr) {
                        isClustered = ((SqlCharExpr)paramList.get((int)3)).text;
                    }
                    AlterPKProcedure.call(statement, ((SqlCharExpr)paramList.get((int)0)).text, ((SqlCharExpr)paramList.get((int)1)).text, ((SqlCharExpr)paramList.get((int)2)).text, isClustered);
                }
            }
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("/*ignore*/");
        }
        catch (SQLException e) {
            throw new FormaterException(e.getMessage(), e);
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name.indexOf(" ") >= 0) {
            this.buffer.append("[");
            this.buffer.append(column.name);
            this.buffer.append("] ");
        } else {
            this.buffer.append(column.name);
            this.buffer.append(" ");
        }
        if (column.dataType.equalsIgnoreCase("BIGINT")) {
            this.buffer.append("BIGINT(20)");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("DATETIME");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            this.buffer.append("FLOAT");
        } else if (column.dataType.equalsIgnoreCase("IMAGE") || column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("LONGBLOB");
        } else if (column.dataType.equalsIgnoreCase("INT")) {
            this.buffer.append("INT");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NTEXT")) {
            this.buffer.append("LONGTEXT");
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("REAL")) {
            this.buffer.append("REAL");
        } else if (column.dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("LONGTEXT");
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMP")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("TIME")) {
            this.buffer.append("TIME");
        } else if (column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("DATE");
        } else if (column.dataType.equalsIgnoreCase("YEAR")) {
            this.buffer.append("YEAR");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("TINYBLOB");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("LONGBLOB");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("LONGTEXT");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("LONGTEXT");
        } else if (column.dataType.equalsIgnoreCase("XMLTYPE") || column.dataType.equalsIgnoreCase("XML")) {
            this.buffer.append("LONGTEXT");
        } else if (column.dataType.equalsIgnoreCase("GEOMETRY") || column.dataType.equalsIgnoreCase("GEOGRAPHY")) {
            this.buffer.append("GEOMETRY");
        } else {
            this.buffer.append(column.dataType);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.dataType.equalsIgnoreCase("IMAGE") || column.dataType.equalsIgnoreCase("BLOB") || column.dataType.equalsIgnoreCase("CLOB") || column.dataType.equalsIgnoreCase("NCLOB") || column.dataType.equalsIgnoreCase("TEXT") || column.dataType.equalsIgnoreCase("NTEXT") || column.dataType.equalsIgnoreCase("XMLTYPE") || column.dataType.equalsIgnoreCase("XML")) {
            return;
        }
        if (column.defaultValueExpr != null) {
            String methodName;
            if (column.defaultValueExpr.type == 10 && (methodName = ((SqlMethodInvokeExpr)column.defaultValueExpr).methodName.toUpperCase(Locale.ENGLISH)).compareTo("NEWID") == 0) {
                throw new FormaterException(" The default value of newid function is not supported ");
            }
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.autoIncrement) {
            this.buffer.append(" AUTO_INCREMENT");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatDropIndexStmt(SqlDropIndexStmt stmt) throws FormaterException {
        this.buffer.append("DROP INDEX ");
        this.buffer.append(this.getIndexName(stmt));
        if (stmt.tableName != null && !stmt.tableName.equals("")) {
            this.buffer.append(" ON ");
            this.buffer.append(stmt.tableName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void formatDeleteStmt(SqlDeleteStmt stmt) throws FormaterException {
        SqlDelete delete = stmt.delete;
        this.buffer.append("DELETE ");
        this.formatHintForDelete(stmt);
        this.formatDelStmtTableAlis(delete);
        if (delete.tableName != null && delete.tableName.length() != 0) {
            if (delete.tableSource != null) {
                throw new FormaterException("not support");
            }
            this.buffer.append("FROM ");
            this.buffer.append(this.formatTableName(delete.tableName));
        } else {
            this.buffer.append("FROM ");
            this.formatTableSource(delete.tableSource);
        }
        if (delete.condition == null) return;
        if (delete.condition instanceof SqlInSubQueryExpr) {
            SqlInSubQueryExpr sisqe = (SqlInSubQueryExpr)delete.condition;
            if (sisqe.not) {
                this.buffer.append(" WHERE ");
                this.formatExpr(delete.condition);
                return;
            } else {
                if (delete.tableName != null && delete.tableName.length() != 0) {
                    if (delete.tableSource != null) {
                        throw new FormaterException("not support");
                    }
                    this.buffer.append(" USING ");
                    this.buffer.append(this.formatTableName(delete.tableName));
                } else {
                    this.buffer.append(" USING ");
                    this.formatTableSource(delete.tableSource);
                }
                this.buffer.append(", (");
                this.formatSelectBase(sisqe.subQuery);
                this.buffer.append(") subQueryTempTable where ");
                if (sisqe.expr instanceof SqlIdentifierExpr) {
                    if (delete.tableName != null && delete.tableName.length() != 0) {
                        if (delete.tableSource != null) {
                            throw new FormaterException("not support");
                        }
                        this.buffer.append(this.formatTableName(delete.tableName));
                    } else if (delete.tableSource.alias != null && !delete.tableSource.alias.equals("")) {
                        this.buffer.append(delete.tableSource.alias);
                    } else {
                        if (!(delete.tableSource instanceof SqlTableSource)) throw new FormaterException("not support");
                        SqlTableSource simpleTableSource = (SqlTableSource)delete.tableSource;
                        String name = simpleTableSource.name;
                        this.buffer.append(name);
                    }
                    this.buffer.append(".");
                }
                this.formatExpr(sisqe.expr);
                this.buffer.append(" = subQueryTempTable.");
                SqlSelectBase select = sisqe.subQuery;
                while (select instanceof SqlUnionSelect) {
                    select = ((SqlUnionSelect)select).left;
                }
                if (!(select instanceof SqlSelect)) throw new FormaterException("not support");
                SqlSelect sqlSelect = (SqlSelect)select;
                List selList = sqlSelect.selectList;
                if (selList == null || selList.size() != 1) throw new FormaterException("not support");
                SqlSelectItem item = (SqlSelectItem)selList.get(0);
                if (item.alias != null && item.alias.length() != 0) {
                    this.buffer.append(item.alias.toUpperCase());
                    return;
                } else {
                    SqlExpr expr = item.expr;
                    while (expr instanceof SqlBinaryOpExpr) {
                        expr = ((SqlBinaryOpExpr)expr).right;
                    }
                    if (!(expr instanceof SqlIdentifierExpr)) throw new FormaterException("not support");
                    this.formatExpr(expr);
                }
            }
            return;
        } else {
            this.buffer.append(" WHERE ");
            this.formatExpr(delete.condition);
        }
    }

    protected final void formatAlterTableStmtOld(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName);
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(",");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            if (dropColumnDefItem.columnDefItemList.size() == 0 && dropColumnDefItem.constraintItemList.size() == 1 && "PRIMARYKEY".equals(dropColumnDefItem.constraintItemList.get(0))) {
                this.buffer.append("PRIMARY KEY");
            } else {
                String columnDef;
                Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
                boolean flag = false;
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    } else {
                        this.buffer.append("COLUMN ");
                    }
                    columnDef = (String)iterator.next();
                    this.buffer.append(columnDef);
                    flag = true;
                }
                iterator = dropColumnDefItem.constraintItemList.iterator();
                flag = false;
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    } else {
                        this.buffer.append("CONSTRAINT ");
                    }
                    columnDef = (String)iterator.next();
                    this.buffer.append(columnDef);
                    flag = true;
                }
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(addDefaultItem.columnName);
            this.buffer.append(" SET DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append(" DROP DEFAULT");
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected final void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        if (stmt.items == null || stmt.items.size() <= 1) {
            this.formatAlterTableStmtOld(stmt);
            return;
        }
        Iterator itemsIterator = stmt.items.iterator();
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        while (itemsIterator.hasNext()) {
            Object columnDef;
            Iterator iterator;
            if (!flag) {
                this.buffer.append("ALTER TABLE ");
                this.buffer.append(stmt.tableName);
            } else {
                sb.append(", ");
            }
            Object obj = itemsIterator.next();
            if (obj instanceof SqlAlterTableAddItem) {
                StringBuilder oldBuffer;
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)obj;
                iterator = addColumnDefItem.columnDefItemList.iterator();
                boolean addItemFlag = false;
                while (iterator.hasNext()) {
                    if (addItemFlag) {
                        sb.append(", ");
                    }
                    sb.append(" ADD ");
                    columnDef = (SqlColumnDef)iterator.next();
                    oldBuffer = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatColumnDef((SqlColumnDef)columnDef);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer;
                    addItemFlag = true;
                }
                iterator = addColumnDefItem.constraintItemList.iterator();
                addItemFlag = false;
                while (iterator.hasNext()) {
                    SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                    try {
                        oldBuffer = this.buffer;
                        this.buffer = new StringBuilder();
                        this.formatTableConstraint(constraint);
                        sb.append((CharSequence)this.buffer);
                        this.buffer = oldBuffer;
                    }
                    catch (FormaterException ex) {
                        throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                    }
                }
            } else if (obj instanceof SqlAlterTableDropItem) {
                SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)obj;
                iterator = dropColumnDefItem.columnDefItemList.iterator();
                boolean dropItemlag = false;
                while (iterator.hasNext()) {
                    if (dropItemlag) {
                        sb.append(", ");
                    }
                    sb.append(" DROP COLUMN ");
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    dropItemlag = true;
                }
                iterator = dropColumnDefItem.constraintItemList.iterator();
                dropItemlag = false;
                while (iterator.hasNext()) {
                    if (dropItemlag) {
                        sb.append(", ");
                    } else {
                        sb.append(" DROP CONSTRAINT ");
                    }
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    dropItemlag = true;
                }
            } else if (obj instanceof SqlAlterTableAlterColumnItem) {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)obj;
                sb.append(" MODIFY COLUMN ");
                StringBuilder oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatColumnDef(alterColumnDefItem.columnDef);
                sb.append((CharSequence)this.buffer);
                this.buffer = oldBuffer;
            } else {
                throw new FormaterException("TODO");
            }
            flag = true;
        }
        if (flag) {
            this.buffer.append((CharSequence)sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void formatCommentStmt(SqlCommentStmt stmt) throws FormaterException, SQLException {
        boolean isCreateStatement = false;
        Statement statement = null;
        try {
            statement = (Statement)this.formaterContext.getProperty("stmt");
            if (statement == null) {
                Connection coon = (Connection)this.formaterContext.getProperty("conn");
                statement = coon.createStatement();
                isCreateStatement = true;
            }
            this.buffer.append(CommentProcedure.buildAlterCommentSql(statement, stmt.getSchema(), stmt.getTableName(), stmt.getColumnName(), stmt.getComment()));
        }
        finally {
            if (isCreateStatement && statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new FormaterException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("'");
        if (expr.timeType() == -19000) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        } else if (expr.timeType() == -19001) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
        } else if (expr.timeType() == -19002) {
            this.buffer.append(expr.getHour() < 10 ? "0" : "");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        }
        this.buffer.append("'");
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        int rowNumberColumnCount = 0;
        StringBuilder rowNumberStr = new StringBuilder();
        StringBuilder selectStrBuilder = new StringBuilder();
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(this.formatTableName(select.into.new_table));
            this.buffer.append(" AS (");
            selectStrBuilder = this.buffer;
            this.buffer = new StringBuilder();
            this.buffer.append("SELECT ");
        } else {
            selectStrBuilder = this.buffer;
            this.buffer = new StringBuilder();
            this.buffer.append("SELECT ");
        }
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else if (select.distinct == 2) {
            this.buffer.append("DISTINCTROW ");
        } else {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlSelectItem item;
            block90: {
                block88: {
                    block99: {
                        block98: {
                            block97: {
                                block96: {
                                    block95: {
                                        block94: {
                                            block93: {
                                                block92: {
                                                    block91: {
                                                        block89: {
                                                            if (flag) {
                                                                this.buffer.append(", ");
                                                            }
                                                            item = (SqlSelectItem)iterator.next();
                                                            if (!(item.expr instanceof SqlIdentifierExpr)) break block88;
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block89;
                                                            item.alias = Token.KSQL_COL_NAME.value;
                                                            break block90;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block91;
                                                        item.alias = Token.TABNAME.value;
                                                        break block90;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block92;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block90;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block93;
                                                item.alias = Token.KSQL_COL_LENGTH.value;
                                                break block90;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block94;
                                            item.alias = Token.KSQL_COL_TYPE.value;
                                            break block90;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block95;
                                        item.alias = Token.KSQL_COL_NULLABLE.value;
                                        break block90;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block96;
                                    item.alias = Token.KSQL_COL_DEFAULT.value;
                                    break block90;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block97;
                                item.alias = Token.INDNAME.value;
                                break block90;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block98;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block90;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block99;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block90;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block90;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block90;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "INDEX_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_TYPE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_DEFAULT";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "IS_NULLABLE";
                    }
                }
            }
            boolean itemHasAlias = false;
            if (item.alias != null && item.alias.length() != 0) {
                itemHasAlias = true;
            }
            if (item.expr instanceof SqlIdentifierExpr) {
                SqlIdentifierExpr tableNameExpr;
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    SqlIdentifierExpr columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(columnNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_TYPE";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "COLUMN_DEFAULT";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "IS_NULLABLE";
                    this.formatExpr(tableNameExpr, itemHasAlias);
                } else {
                    this.formatExpr(item.expr, itemHasAlias);
                }
                if (item.alias != null && item.alias.length() != 0) {
                    this.buffer.append(" AS ");
                    this.buffer.append(item.alias.toUpperCase());
                }
                flag = true;
                continue;
            }
            if (item.expr instanceof SqlAggregateExpr) {
                SqlAggregateExpr aggregateExpr = (SqlAggregateExpr)item.expr;
                if (aggregateExpr.methodName.compareToIgnoreCase("ROW_NUMBER") == 0) {
                    this.FormatRowNumberExpr(aggregateExpr, select, rowNumberColumnCount);
                    rowNumberStr.append(", ");
                    rowNumberStr.append(String.format("(@rowNum%1$s:=@rowNum%1$s+1)", rowNumberColumnCount));
                    if (item.alias != null && item.alias.length() != 0) {
                        rowNumberStr.append(" AS ");
                        rowNumberStr.append(item.alias.toUpperCase());
                    }
                    ++rowNumberColumnCount;
                    if (!flag) continue;
                    this.buffer.delete(this.buffer.length() - 2, 2);
                    continue;
                }
                this.formatExpr(item.expr, itemHasAlias);
                if (item.alias != null && item.alias.length() != 0) {
                    this.buffer.append(" AS ");
                    this.buffer.append(item.alias.toUpperCase());
                }
                flag = true;
                continue;
            }
            this.formatExpr(item.expr, itemHasAlias);
            if (item.alias != null && item.alias.length() != 0) {
                this.buffer.append(" AS ");
                this.buffer.append(item.alias.toUpperCase());
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM DUAL ");
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            boolean f = false;
            if (select.tableSource instanceof SqlTableSource) {
                SqlTableSource simpleTableSource = (SqlTableSource)select.tableSource;
                if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value) || simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value) || simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value) || simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                    if (CONSTANT.CONNECTION_SHARD) {
                        KSQLSchemaContext schemaContext = KSQLSchemaContext.get();
                        if (schemaContext != null) {
                            this.buffer.append("TABLE_SCHEMA = '");
                            this.buffer.append(schemaContext.getSchema()).append("' AND (");
                        } else {
                            this.buffer.append("TABLE_SCHEMA = SCHEMA() AND (");
                        }
                    } else {
                        this.buffer.append("TABLE_SCHEMA = SCHEMA() AND (");
                    }
                    f = true;
                }
            }
            this.formatExpr(select.condition);
            if (f) {
                this.buffer.append(")");
            }
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(" WITH ROLLUP");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                String ident;
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                SqlExpr expr = orderByIterm.expr;
                if (orderByIterm.chineseOrderByMode != -1) {
                    this.buffer.append("CONVERT(");
                    if (expr instanceof SqlIdentifierExpr) {
                        ident = ((SqlIdentifierExpr)expr).value;
                        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
                            this.buffer.append(ident.toUpperCase());
                        } else {
                            this.formatExpr(expr);
                        }
                    } else {
                        this.formatExpr(expr);
                    }
                    this.buffer.append(" USING ");
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append("GBK)");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append("GBK)");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        this.buffer.append("GBK)");
                    }
                } else if (expr instanceof SqlIdentifierExpr) {
                    ident = ((SqlIdentifierExpr)expr).value;
                    if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
                        this.buffer.append(ident.toUpperCase());
                    } else {
                        this.formatExpr(expr);
                    }
                } else {
                    this.formatExpr(expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            this.buffer.append(" LIMIT ").append(select.limit.offset).append(", ");
            this.buffer.append(select.limit.rowCount);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
        if (rowNumberColumnCount > 0) {
            selectStrBuilder.append("select row_number_buffer.* ");
            selectStrBuilder.append((CharSequence)rowNumberStr);
            selectStrBuilder.append(" from ( ").append((CharSequence)this.buffer).append(") row_number_buffer ");
            for (int i = 0; i < rowNumberColumnCount; ++i) {
                selectStrBuilder.append(String.format(", (Select (@rowNum%1$s :=0) ) ROW_NUMBER%1$s ", i));
            }
        } else {
            selectStrBuilder.append((CharSequence)this.buffer);
        }
        this.buffer = selectStrBuilder;
        if (select.into != null) {
            this.buffer.append(")");
        }
    }

    public void formatSelectList(SqlSelect select) throws FormaterException {
        boolean sysTableFlag = false;
        boolean sysIndexFlag = false;
        boolean sysConstraintFlag = false;
        this.formatSelectColumnList(select, sysTableFlag, sysIndexFlag, sysConstraintFlag);
    }

    private void formatSelectColumnList(SqlSelect select, boolean sysTableFlag, boolean sysIndexFlag, boolean sysConstraintFlag) throws FormaterException {
        boolean flag = false;
        sysTableFlag = false;
        sysIndexFlag = false;
        sysConstraintFlag = false;
        for (SqlSelectItem item : select.selectList) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            block56: {
                block54: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block57: {
                                                block55: {
                                                    if (flag) {
                                                        this.buffer.append(", ");
                                                    }
                                                    if (item.expr.getClass() != SqlIdentifierExpr.class) break block54;
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block55;
                                                    item.alias = Token.KSQL_COL_NAME.value;
                                                    break block56;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block57;
                                                item.alias = Token.KSQL_COL_DEFAULT.value;
                                                break block56;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block58;
                                            item.alias = Token.KSQL_COL_NULLABLE.value;
                                            break block56;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block59;
                                        item.alias = Token.KSQL_COL_TABNAME.value;
                                        break block56;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block60;
                                    sysTableFlag = true;
                                    item.alias = Token.TABNAME.value;
                                    break block56;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block61;
                                sysIndexFlag = true;
                                item.alias = Token.INDNAME.value;
                                break block56;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block62;
                            sysConstraintFlag = true;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block56;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block63;
                        sysConstraintFlag = true;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block56;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block56;
                    sysConstraintFlag = true;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block56;
                }
                if (item.expr.getClass() == SqlAggregateExpr.class) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (param.getClass() != SqlIdentifierExpr.class) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_DEFAULT";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "ISNULLABLE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            sysTableFlag = true;
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            sysIndexFlag = true;
                            ((SqlIdentifierExpr)param).value = "NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) continue;
                        sysConstraintFlag = true;
                        ((SqlIdentifierExpr)param).value = "CASE CONSTRAINT_TYPE WHEN 'PK' THEN 'P' WHEN 'UQ' THEN 'U' ELSE CONSTRAINT_TYPE END";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr.getClass() == SqlIdentifierExpr.class) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "COLUMN_NAME";
                        this.formatExpr(columnNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_DEFAULT";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "ISNULLABLE";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysTableFlag = true;
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysIndexFlag = true;
                        tableNameExpr.value = "INDEX_NAME";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "CONSTRAINT_NAME";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "CASE CONSTRAINT_TYPE WHEN 'PK' THEN 'P' WHEN 'UQ' THEN 'U' ELSE CONSTRAINT_TYPE END";
                        this.formatExpr(tableNameExpr, true);
                    } else {
                        this.formatExpr(item.expr, true);
                    }
                } else {
                    this.formatExpr(item.expr, true);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toLowerCase());
            } else if (item.expr.getClass() == SqlIdentifierExpr.class) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_DEFAULT";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "ISNULLABLE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CASE CONSTRAINT_TYPE WHEN 'PK' THEN 'P' WHEN 'UQ' THEN 'U' ELSE CONSTRAINT_TYPE END";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
    }

    private void FormatRowNumberExpr(SqlAggregateExpr expr, SqlSelect select, int rowNumberColumnCount) {
        if (expr.hasOver()) {
            for (SqlOrderByItem item : expr.overExpr.orderBy) {
                select.orderBy.add(item);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if (this.formatMathFunc(methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH), expr)) {
            return;
        }
        if (this.formatDateTimeFunc(methodNameI, expr)) {
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("LOCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("LOCATE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("CONCAT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0 || methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LEN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("SUBSTRING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0), false);
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                }
                if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 1S.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1), false);
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2), false);
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS DECIMAL(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS DECIMAL)");
            return;
        }
        if (methodNameI.compareTo("TO_BLOB") == 0 || methodNameI.compareTo("BLOB") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(0) instanceof SqlNullExpr)) return;
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                if (expr.parameters.get(0) instanceof SqlNullExpr) {
                    this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                    return;
                }
                this.buffer.append("CONCAT('', ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD")) {
                this.buffer.append("CONCAT('', DATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD HH24:MI:SS")) {
                this.buffer.append("CONCAT('', TIMESTAMP(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            if (!expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(2) instanceof SqlCharExpr)) {
                if (!(expr.parameters.get(2) instanceof SqlIntExpr)) return;
                this.buffer.append("LTRIM(RTRIM(STR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 38, ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")))");
                return;
            }
            String style = expr.parameters.get(2).toString();
            if (style.split("D").length <= 0) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            if (style.split("D").length >= 3) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            char[] integerStyle = style.split("D")[0].toCharArray();
            char[] radixStyle = style.split("D")[1].toCharArray();
            int countInteger = 0;
            for (int i = 0; i < integerStyle.length; ++i) {
                if (integerStyle[i] != '9') continue;
                ++countInteger;
            }
            int countradix = 0;
            int i = 0;
            while (true) {
                if (i >= radixStyle.length) {
                    this.buffer.append("CONVERT(");
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS DECIMAL(");
                    this.buffer.append(countInteger + countradix);
                    this.buffer.append(", ");
                    this.buffer.append(countradix);
                    this.buffer.append("), CHAR");
                    this.buffer.append("))");
                    return;
                }
                if (radixStyle[i] == '9') {
                    ++countradix;
                }
                ++i;
            }
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("COALESCE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", DECIMAL)");
            return;
        }
        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(CONVERT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", DECIMAL))");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TO_VARCHAR") == 0 || methodNameI.compareTo("TOVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) throw new FormaterException("unexpect parameter:" + expr.parameters.get(0));
            SqlIdentifierExpr identExpr = (SqlIdentifierExpr)expr.parameters.get(0);
            if (identExpr.value.compareToIgnoreCase("DATETIME") == 0) {
                this.buffer.append("CONVERT(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", DATETIME)");
                return;
            }
            if (identExpr.value.compareToIgnoreCase("VARCHAR") != 0 && identExpr.value.compareToIgnoreCase("NVARCHAR") != 0 && identExpr.value.compareToIgnoreCase("CHAR") != 0) {
                if (identExpr.value.compareToIgnoreCase("NCHAR") != 0) throw new FormaterException("unexpect expression:" + identExpr.value);
            }
            this.buffer.append("CONVERT(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", CHAR)");
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(uuid())");
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("NEWBOSID(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FIND_IN_SET") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("FIND_IN_SET");
            this.buffer.append("(").append(expr.parameters.get(0)).append(",").append(expr.parameters.get(1)).append(") ");
            return;
        }
        if (methodNameI.compareTo("NOT_FIND_IN_SET") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("NOT FIND_IN_SET");
            this.buffer.append("(").append(expr.parameters.get(0)).append(",").append(expr.parameters.get(1)).append(") ");
            return;
        }
        if (methodNameI.compareTo("ST_POINT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("POINT");
            this.buffer.append("(").append(expr.parameters.get(0));
            this.buffer.append(",").append(expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ST_ASTEXT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("ST_ASTEXT");
            this.buffer.append("(").append(expr.parameters.get(0));
            this.buffer.append(",axis-order=long-lat)");
            return;
        }
        if (methodNameI.compareTo("ST_SETSRID") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("ST_SRID");
            this.buffer.append("(");
            if (expr.parameters.get(0) instanceof SqlExpr) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
            } else {
                this.buffer.append(expr.parameters.get(0));
            }
            this.buffer.append(",").append(expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ST_DISTANCE") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("ST_DISTANCE");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(",");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean formatDateTimeFunc(String methodNameI, SqlMethodInvokeExpr expr) throws FormaterException {
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURDATE()");
            return true;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CONCAT('', CURTIME())");
            return true;
        }
        if (methodNameI.compareTo("DATEADD") == 0 || methodNameI.compareTo("DATETIMEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATE_ADD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", INTERVAL ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" SECOND)");
                return true;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null || datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append(" YEAR)");
                return true;
            } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append(" MONTH)");
                return true;
            } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append(" DAY)");
                return true;
            } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append(" HOUR)");
                return true;
            } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append(" MINUTE)");
                return true;
            } else {
                if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                this.buffer.append(" SECOND)");
            }
            return true;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("TIMESTAMPDIFF(SECOND, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("TIMESTAMPDIFF(");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (datepartExpr instanceof SqlIdentifierExpr) {
                String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                if (datepart == null || datepart.length() == 0) {
                    throw new FormaterException("illegal datepart.");
                }
                if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                    this.buffer.append("YEAR");
                } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    this.buffer.append("MONTH");
                } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    this.buffer.append("DAY");
                } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                    this.buffer.append("HOUR");
                } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    this.buffer.append("MINUTE");
                } else {
                    if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                    this.buffer.append("SECOND");
                }
            }
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEDIFF(MONTH, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("DAYS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEDIFF(DAY, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) return false;
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null || datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append("YEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append("MONTH(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("QUARTER".equals(datepart) || "QQ".equals(datepart) || "Q".equals(datepart)) {
                this.buffer.append("QUARTER(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("DAYOFYEAR".equals(datepart) || "DY".equals(datepart) || "Y".equals(datepart)) {
                this.buffer.append("DAYOFYEAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append("DAY(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("WEEK".equals(datepart) || "WK".equals(datepart) || "WW".equals(datepart)) {
                this.buffer.append("WEEK(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") + 1");
                return true;
            }
            if ("WEEKDAY".equals(datepart) || "DW".equals(datepart)) {
                this.buffer.append("(WEEKDAY(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(") + 1) % 7 + 1)");
                return true;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append("HOUR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append("MINUTE(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
                this.buffer.append("SECOND(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            if (!"MILLISECOND".equals(datepart) && !"MS".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            this.buffer.append("MICROSECOND(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYOFMONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0 || methodNameI.compareTo("WEEKDAY") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("((WEEKDAY(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") + 1) % 7 + 1)");
            return true;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("DAYOFYEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("NOW()");
            return true;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("HOUR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MINUTE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MONTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("MONTHNAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("NOW()");
            return true;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("QUARTER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SECOND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("WEEK(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") + 1");
            return true;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return true;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", DATETIME)");
            return true;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MONTH)");
            return true;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" YEAR)");
            return true;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" DAY)");
            return true;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" HOUR)");
            return true;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATE_ADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", INTERVAL ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" MINUTE)");
            return true;
        }
        if (methodNameI.compareTo("ADD_SECONDS") != 0) return false;
        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
        this.buffer.append("DATE_ADD(");
        this.formatExpr((SqlExpr)expr.parameters.get(0));
        this.buffer.append(", INTERVAL ");
        this.formatExpr((SqlExpr)expr.parameters.get(1));
        this.buffer.append(" SECOND)");
        return true;
    }

    private boolean formatMathFunc(String methodNameI, SqlMethodInvokeExpr expr) throws FormaterException {
        if (methodNameI.compareTo("ABS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ABS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ACOS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ASIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ATAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ATN2") == 0 || methodNameI.compareTo("ATAN2") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ATAN2(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("CEILING(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("COS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("COT") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("COT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("DEGREE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("DEGREE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("EXP(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("FLOOR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("GREATEAST") == 0) {
            if (expr.parameters.size() > 0) {
                this.buffer.append("GREATEAST(");
                for (int i = 0; i < expr.parameters.size(); ++i) {
                    if (i != 0) {
                        this.buffer.append(", ");
                    }
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                }
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LEAST") == 0) {
            if (expr.parameters.size() > 0) {
                this.buffer.append("LEAST(");
                for (int i = 0; i < expr.parameters.size(); ++i) {
                    if (i != 0) {
                        this.buffer.append(", ");
                    }
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                }
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("MOD(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOG(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("LOG10") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("LOG10(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("PI") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("PI()");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("POW") == 0 || methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("POWER(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("RADIANS") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("RADIANS(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("RAND") == 0) {
            if (expr.parameters.size() == 0) {
                this.buffer.append("RAND()");
                return true;
            }
            if (expr.parameters.size() == 1) {
                this.buffer.append("RAND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SIGN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("SQRT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("TAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        if (methodNameI.compareTo("TRUNCATE") == 0) {
            if (expr.parameters.size() == 1) {
                this.buffer.append("TRUNCATE(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return true;
            }
            throw new FormaterException("ERROR");
        }
        return false;
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 21) {
            this.buffer.append("MOD(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 42) {
            this.buffer.append("CONCAT(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 0) {
            SqlBinaryOpExpr binaryOpExpr;
            SqlMethodInvokeExpr funcExpr;
            if (expr.left instanceof SqlCharExpr || expr.left instanceof SqlNCharExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr) {
                this.buffer.append("CONCAT(");
                this.formatExpr(expr.left);
                this.buffer.append(", ");
                this.formatExpr(expr.right);
                this.buffer.append(")");
                return;
            }
            if (expr.left instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.left;
                if (funcExpr.methodName.equals("CHAR") || funcExpr.methodName.equals("LTRIM") || funcExpr.methodName.equals("RTRIM") || funcExpr.methodName.equals("LCASE") || funcExpr.methodName.equals("LOWER") || funcExpr.methodName.equals("UPPER") || funcExpr.methodName.equals("UCASE") || funcExpr.methodName.equals("SUBSTR")) {
                    this.buffer.append("CONCAT(");
                    this.formatExpr(expr.left);
                    this.buffer.append(", ");
                    this.formatExpr(expr.right);
                    this.buffer.append(")");
                    return;
                }
            }
            if (expr.right instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.right;
                if (funcExpr.methodName.equals("CHAR")) {
                    this.buffer.append("CONCAT(");
                    this.formatExpr(expr.left);
                    this.buffer.append(", ");
                    this.formatExpr(expr.right);
                    this.buffer.append(")");
                    return;
                }
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.left;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.buffer.append("CONCAT(");
                    this.formatExpr(expr.left);
                    this.buffer.append(", ");
                    this.formatExpr(expr.right);
                    this.buffer.append(")");
                    return;
                }
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.right;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.buffer.append("CONCAT(");
                    this.formatExpr(expr.left);
                    this.buffer.append(", ");
                    this.formatExpr(expr.right);
                    this.buffer.append(")");
                    return;
                }
            }
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append("=");
            if (expr.left instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) && expr.right instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 1) {
            String alias;
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 44) {
            this.buffer.append("MATCH(");
            this.formatExpr(expr.left);
            this.buffer.append(")");
            this.buffer.append(" AGAINST(");
            this.formatExpr(expr.right);
            this.buffer.append(" IN BOOLEAN MODE)");
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append("+");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE");
        if (UUTN.isGlobalTempTable(stmt.name)) {
            this.buffer.append(" TEMPORARY");
            stmt.name = stmt.name.substring(2);
        } else if (UUTN.isTempTable(stmt.name)) {
            this.buffer.append(" TEMPORARY");
            stmt.name = stmt.name.substring(1);
        }
        if (stmt.name.indexOf(" ") >= 0) {
            this.buffer.append(" TABLE [");
            this.buffer.append(stmt.name);
            this.buffer.append("] (");
        } else {
            this.buffer.append(" TABLE ");
            this.buffer.append(stmt.name);
            this.buffer.append(" (");
        }
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        String ts = null;
        if (UUTN.isTempTable(stmt.name) && this.options != null) {
            ts = this.options.getTempTableSpace();
        }
        if (ts == null) {
            ts = stmt.tableSpace;
        }
        this.formatTableSpace(ts);
    }

    protected final void formatTableSpace(String tableSpace) {
        if (tableSpace != null && tableSpace.length() > 0) {
            this.buffer.append(" TABLESPACE ").append(tableSpace);
        }
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        } else {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(stmt.indexName);
        this.buffer.append(" ON ");
        this.buffer.append(stmt.tableName);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            if (orderByIterm.chineseOrderByMode != -1) {
                this.buffer.append("CONVERT(");
                this.formatExpr(orderByIterm.expr);
                this.buffer.append(" USING ");
                if (orderByIterm.chineseOrderByMode == 2) {
                    this.buffer.append("GBK)");
                } else if (orderByIterm.chineseOrderByMode == 3) {
                    this.buffer.append("GBK)");
                } else if (orderByIterm.chineseOrderByMode == 4) {
                    this.buffer.append("GBK)");
                }
            } else {
                this.formatExpr(orderByIterm.expr);
            }
            if (orderByIterm.mode == 0) {
                DisCardUtil.discard();
            } else {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
        String ts = null;
        if (UUTN.isTempTable(stmt.tableName) && this.options != null) {
            ts = this.options.getTempTableSpace();
        }
        this.formatTableSpace(ts);
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            if (primaryKey.clustered) {
                this.buffer.append(" PRIMARY KEY (");
            } else {
                this.buffer.append(" PRIMARY KEY (");
            }
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            this.buffer.append(" UNIQUE (");
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("TODO");
        }
    }

    private boolean hasTableSource(SqlTableSourceBase tableSource, String tabName) {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            return simpleTableSource.name.equalsIgnoreCase(tabName);
        }
        if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            boolean flag = this.hasTableSource(joinedTable.left, tabName);
            if (!flag) {
                flag = this.hasTableSource(joinedTable.right, tabName);
            }
            return flag;
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            if (subQueryTableSource.subQuery instanceof SqlSelect) {
                return this.hasTableSource(((SqlSelect)subQueryTableSource.subQuery).tableSource, tabName);
            }
        }
        return false;
    }

    @Override
    protected final void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            KSQLSchemaContext schemaContext;
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            String sAlias = "";
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                if (CONSTANT.CONNECTION_SHARD) {
                    this.buffer.append("(select TABLE_NAME as TABLE_NAME, case when TABLE_TYPE = 'BASE TABLE' then 'U' else 'V' end TABLE_XTYPE, TABLE_SCHEMA from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = ");
                    schemaContext = KSQLSchemaContext.get();
                    if (schemaContext != null) {
                        this.buffer.append("'" + schemaContext.getSchema() + "'");
                    } else {
                        this.buffer.append("SCHEMA()");
                    }
                    this.buffer.append(")");
                } else {
                    this.buffer.append("(select TABLE_NAME as TABLE_NAME, case when TABLE_TYPE = 'BASE TABLE' then 'U' else 'V' end TABLE_XTYPE, TABLE_SCHEMA from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = SCHEMA())");
                }
                sAlias = " AS KSQL_USERTABLES";
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("INFORMATION_SCHEMA.COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.TABLECOLUMNDEFAULTVALUE.value)) {
                this.buffer.append("INFORMATION_SCHEMA.COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("INFORMATION_SCHEMA.STATISTICS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.INDCOLUMNS.value)) {
                this.buffer.append("INFORMATION_SCHEMA.STATISTICS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("INFORMATION_SCHEMA.TABLE_CONSTRAINTS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERVIEWS.value)) {
                if (CONSTANT.CONNECTION_SHARD) {
                    schemaContext = KSQLSchemaContext.get();
                    if (schemaContext != null) {
                        this.buffer.append("(select * from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = '").append(schemaContext.getSchema()).append("' )");
                    } else {
                        this.buffer.append("(select * from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = SCHEMA() )");
                    }
                } else {
                    this.buffer.append("(select * from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = SCHEMA() )");
                }
                sAlias = " AS KSQL_USERVIEWS";
            } else {
                String name = simpleTableSource.name;
                this.buffer.append(name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" AS ");
                String alias = simpleTableSource.alias;
                this.buffer.append(alias);
            } else {
                this.buffer.append(sAlias);
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" AS ");
                String alias = tableSource.alias;
                this.buffer.append(alias);
            }
        } else {
            throw new FormaterException("error");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        throw new FormaterException("Not Support. PriorIdentifierExpr");
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        SqlBlockStmt.DeclItem item;
        int i;
        int size;
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                String name;
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem varItem = (SqlBlockStmt.DeclVarItem)item;
                    this.buffer.append("DECLARE ");
                    name = varItem.name;
                    this.buffer.append(name);
                    this.buffer.append(" ");
                    if (varItem.dataType.equalsIgnoreCase("BIGINT")) {
                        this.buffer.append("BIGINT(20)");
                    } else if (varItem.dataType.equalsIgnoreCase("BINARY")) {
                        this.buffer.append("BINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BIT")) {
                        this.buffer.append("BIT");
                    } else if (varItem.dataType.equalsIgnoreCase("CHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("DATETIME")) {
                        this.buffer.append("DATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        this.buffer.append("DECIMAL (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("FLOAT")) {
                        this.buffer.append("FLOAT");
                    } else if (varItem.dataType.equalsIgnoreCase("IMAGE")) {
                        this.buffer.append("BLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("INT")) {
                        this.buffer.append("INT");
                    } else if (varItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("NCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NTEXT")) {
                        this.buffer.append("LONGTEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NUMERIC")) {
                        this.buffer.append("NUMERIC (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NVARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("REAL")) {
                        this.buffer.append("REAL");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLDATETIME")) {
                        this.buffer.append("DATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (varItem.dataType.equalsIgnoreCase("TEXT")) {
                        this.buffer.append("LONGTEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("TIMESTAMP")) {
                        this.buffer.append("TIMESTAMP");
                    } else if (varItem.dataType.equalsIgnoreCase("TINYINT")) {
                        this.buffer.append("TINYINT");
                    } else if (varItem.dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                        this.buffer.append("UNIQUEIDENTIFIER");
                    } else if (varItem.dataType.equalsIgnoreCase("VARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("VARBINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("LONGBLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("LONGTEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("LONGTEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("XMLTYPE") || varItem.dataType.equalsIgnoreCase("XML")) {
                        this.buffer.append("LONGTEXT");
                    } else {
                        this.buffer.append(varItem.dataType);
                    }
                    if (varItem.defaultValueExpr != null) {
                        this.buffer.append(" DEFAULT ");
                        this.formatExpr(varItem.defaultValueExpr);
                    }
                } else if (item instanceof SqlBlockStmt.DeclCurItem) {
                    SqlBlockStmt.DeclCurItem curItem = (SqlBlockStmt.DeclCurItem)item;
                    this.buffer.append("DECLARE ");
                    name = curItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" CURSOR FOR ");
                    this.formatSelectBase(curItem.select);
                } else {
                    throw new FormaterException("unexpected statement: '" + item + "'");
                }
                this.buffer.append(";\n");
            }
            this.buffer.append("\n");
        }
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (!(item instanceof SqlBlockStmt.DeclCurItem)) continue;
                this.buffer.append("DEALLOCATE ");
                this.buffer.append(item.name);
                this.buffer.append(";\n");
            }
        }
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.buffer.append("SET ");
        this.formatExpr(stmt.variant);
        this.buffer.append(" = ");
        this.formatExpr(stmt.value);
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "upper(COLUMN_NAME)";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "COLUMN_DEFAULT";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "IS_NULLABLE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "upper(TABLE_NAME)";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "upper(INDEX_NAME)";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "upper(TABLE_NAME)";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "upper(CONSTRAINT_NAME)";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "upper(TABLE_NAME)";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "CONSTRAINT_TYPE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "CHARACTER_MAXIMUM_LENGTH";
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase());
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "PRIMARY KEY";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "FOREIGN KEY";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "UNIQUE";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "CHECK";
        }
        this.buffer.append("'");
        if (this.context.get("toUpperCase") != null) {
            this.buffer.append(text.toUpperCase());
        } else {
            this.buffer.append(text);
        }
        this.buffer.append("'");
    }

    private static String generateShortUuid() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 16; ++i) {
            String str = uuid.substring(i * 2, i * 2 + 2);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 36]);
        }
        return shortBuffer.toString();
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        this.formaterContext.setProperty("isIfStmtType", "true");
        boolean isCreateStatement = false;
        Statement statement = null;
        try {
            statement = (Statement)this.formaterContext.getProperty("stmt");
            if (statement == null) {
                Connection coon = (Connection)this.formaterContext.getProperty("conn");
                statement = coon.createStatement();
                isCreateStatement = true;
            }
            boolean isNotExists = ((SqlExistsExpr)stmt.condition).not;
            this.formatSelectBase(((SqlExistsExpr)stmt.condition).subQuery);
            String ifSql = this.buffer.toString();
            this.buffer.delete(0, this.buffer.length());
            ResultSet resultSet = statement.executeQuery(ifSql);
            if (isNotExists && !resultSet.next() || !isNotExists && resultSet.next()) {
                for (int i = 0; i < stmt.trueStmtList.size(); ++i) {
                    SqlStmt itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
                    this.formatStmt(itemStmt);
                    String[] sqls = this.buffer.toString().split("[\\r\\n]", -1);
                    this.buffer.delete(0, this.buffer.length());
                    for (String sql : sqls) {
                        statement.execute(sql);
                    }
                }
            } else if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
                for (int i = 0; i < stmt.falseStmtList.size(); ++i) {
                    String[] sqls;
                    SqlStmt itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                    this.formatStmt(itemStmt);
                    for (String sql : sqls = this.buffer.toString().split("[\\r\\n]", -1)) {
                        statement.execute(sql);
                    }
                    this.buffer.delete(0, this.buffer.length());
                }
            }
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append("/*ignore*/");
        }
        catch (SQLException e) {
            throw new FormaterException(e.getMessage(), e);
        }
        finally {
            if (isCreateStatement && statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new FormaterException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.buffer.append("WHILE ");
        this.formatExpr(stmt.condition);
        this.buffer.append(" DO\n");
        this.buffer.append("BEGIN\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END;\n");
        this.buffer.append("END WHILE;\n");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("DEALLOCATE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        SqlExpr expr;
        int i;
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append("OPEN ");
        this.buffer.append(curName);
        this.buffer.append(";\n");
        this.buffer.append("FETCH ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        int size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append(";\n");
        this.buffer.append("WHILE FETCH_STATUS = 0 DO\n");
        this.buffer.append("BEGIN\n");
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("FETCH ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append(";\n");
        this.buffer.append("END;\nEND WHILE;\n");
        this.buffer.append("CLOSE ");
        this.buffer.append(curName);
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        this.buffer.append("FETCH ");
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        int size = stmt.intoList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            SqlExpr expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("Not Support. BreakExpr");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        this.buffer.append("CONTINUE");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        this.buffer.append("GOTO ");
        this.buffer.append(stmt.name);
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        this.buffer.append(stmt.name);
        this.buffer.append(":");
    }

    @Override
    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        boolean isIfStmtType = Boolean.parseBoolean((String)this.formaterContext.getProperty("isIfStmtType"));
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        this.buffer.append(this.formatTableName(insert.tableName));
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                Object colItem;
                if (flag) {
                    this.buffer.append(", ");
                }
                if ((colItem = iterator.next()) instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) continue;
                    this.buffer.append(this.formatColumnName(identExpr.value));
                } else if (colItem instanceof String) {
                    this.buffer.append(this.formatColumnName((String)colItem));
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = true;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                if (isIfStmtType) {
                    if (valueExpr.type == 5) {
                        ((SqlCharExpr)valueExpr).text = ((SqlCharExpr)valueExpr).text.replaceAll("\\\\\"", "\\\\\\\\\\\\\"");
                    } else if (valueExpr.type == 6) {
                        ((SqlNCharExpr)valueExpr).text = ((SqlNCharExpr)valueExpr).text.replaceAll("\\\\\"", "\\\\\\\\\\\\\"");
                    }
                }
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery);
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(update.updateTable.name);
        if (update.updateTable.alias != null && update.updateTable.alias.length() != 0) {
            this.buffer.append(' ');
            this.buffer.append(update.updateTable.alias.toLowerCase());
        }
        this.buffer.append(" SET ");
        boolean flag = true;
        ArrayList<SubQueryUpdateItem> subQueryUpdateItems = new ArrayList<SubQueryUpdateItem>();
        for (Object each : update.updateList) {
            AbstractUpdateItem updateItem = (AbstractUpdateItem)each;
            if (!flag) {
                this.buffer.append(",");
            }
            flag = false;
            if (updateItem instanceof SqlUpdateItem) {
                SqlUpdateItem item = (SqlUpdateItem)updateItem;
                this.buffer.append(this.formatColumnName(item.name.toLowerCase()));
                this.buffer.append('=');
                this.formatExpr(item.expr);
                continue;
            }
            if (updateItem instanceof SubQueryUpdateItem) {
                SubQueryUpdateItem queryItem = (SubQueryUpdateItem)updateItem;
                if (queryItem.columnList.size() == 1) {
                    String column = (String)queryItem.columnList.get(0);
                    this.buffer.append(this.formatColumnName(column.toLowerCase()));
                    this.buffer.append("=(");
                    this.formatSelectBase(queryItem.subQuery);
                    this.buffer.append(')');
                    continue;
                }
                subQueryUpdateItems.add(queryItem);
                for (int i = 0; i < queryItem.columnList.size(); ++i) {
                    SqlSelectItem subSelectItem;
                    String column = (String)queryItem.columnList.get(i);
                    if (queryItem.extendedAttributes().get("tableSourceAlias") != null) {
                        column = queryItem.extendedAttributes().get("tableSourceAlias") + "." + column;
                    }
                    if (i != 0) {
                        this.buffer.append(',');
                    }
                    this.buffer.append(this.formatColumnName(column.toLowerCase()));
                    this.buffer.append('=');
                    if (queryItem.subQuery instanceof SqlSelect) {
                        SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                        subSelectItem = (SqlSelectItem)subQuerySelect.selectList.get(i);
                        if (subQuerySelect != null && subQuerySelect.tableSource != null && subQuerySelect.tableSource.alias != null && !subQuerySelect.tableSource.alias.trim().equals("")) {
                            subSelectItem.expr.addExtAttr("tableSourceAlias", subQuerySelect.tableSource.alias);
                        }
                    } else {
                        throw new FormaterException("unexpect subquery item: '" + queryItem.subQuery + "'");
                    }
                    this.formatExpr(subSelectItem.expr, false);
                }
                continue;
            }
            throw new FormaterException("unexpect update item: '" + updateItem + "'");
        }
        int insertIndex = this.buffer.indexOf(" SET");
        if (subQueryUpdateItems.size() > 0) {
            StringBuilder oldBuf = this.buffer;
            this.buffer = new StringBuilder();
            for (SubQueryUpdateItem subQueryUpdateItem : subQueryUpdateItems) {
                if (subQueryUpdateItem.subQuery instanceof SqlSelect) {
                    this.buffer.append(", ");
                    this.formatTableSource(((SqlSelect)subQueryUpdateItem.subQuery).tableSource);
                    continue;
                }
                throw new FormaterException("Unsupported sub query:" + subQueryUpdateItem);
            }
            oldBuf.insert(insertIndex, this.buffer.toString());
            this.buffer = oldBuf;
        }
        flag = false;
        for (int i = 0; i < subQueryUpdateItems.size(); ++i) {
            SubQueryUpdateItem queryItem = (SubQueryUpdateItem)subQueryUpdateItems.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (subQuerySelect.condition == null) continue;
                if (flag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                }
                this.formatExpr(subQuerySelect.condition);
                flag = true;
                continue;
            }
            throw new FormaterException("not support query item:" + queryItem);
        }
        if (update.condition != null) {
            if (flag) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(" WHERE ");
            }
            this.formatExpr(update.condition);
            flag = true;
        }
    }

    private SqlExpr replaceLiteral(SqlExpr expr, Map literalMap) {
        if (expr instanceof SqlBinaryOpExpr) {
            expr = this.replaceLiteral((SqlBinaryOpExpr)expr, literalMap);
        }
        return expr;
    }

    private SqlExpr replaceLiteral(SqlBinaryOpExpr expr, Map literalMap) {
        if (expr.left instanceof SqlIdentifierExpr && expr.right instanceof SqlIdentifierExpr && expr.operator == 20) {
            SqlIdentifierExpr leftIdentExpr = (SqlIdentifierExpr)expr.left;
            SqlIdentifierExpr rightIdentExpr = (SqlIdentifierExpr)expr.right;
            String name = leftIdentExpr.value.toLowerCase() + "." + rightIdentExpr.value.toLowerCase();
            SqlExpr literalExpr = (SqlExpr)literalMap.get(name);
            if (literalExpr != null) {
                return literalExpr;
            }
        } else {
            expr.left = this.replaceLiteral(expr.left, literalMap);
            expr.right = this.replaceLiteral(expr.right, literalMap);
        }
        return expr;
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
        this.buffer.append(" AUTO_INCREMENT ");
    }

    @Override
    protected void formatInListExpr(SqlInListExpr expr) throws FormaterException {
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        Iterator iterator = expr.targetList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlExpr exprItem = (SqlExpr)iterator.next();
            if (expr.expr instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.expr) && exprItem instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatExpr(exprItem);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(exprItem);
            }
            flag = true;
        }
        this.buffer.append(")");
    }
}

