/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.function.yasdb;

import java.util.Locale;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.function.KSQLFunction;

public class YasDBDateDiffFunction
implements KSQLFunction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(SqlMethodInvokeExpr expr, SQLFormater formater) throws FormaterException {
        StringBuilder buffer = formater.getBuffer();
        if (expr.parameters.size() == 2) {
            buffer.append("TIMESTAMPDIFF(SECOND,");
            formater.formatExpr((SqlExpr)expr.parameters.get(0));
            buffer.append(" , ");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(") ");
            return;
        }
        if (expr.parameters.size() != 3) return;
        if (expr.parameters.size() != 3) throw new FormaterException("Function datediff support two or three parameters,but now have " + expr.parameters.size() + ".");
        SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
        if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("Function datediff not support datepart:" + datepartExpr.toString());
        String datepart = ((SqlIdentifierExpr)datepartExpr).value;
        if (datepart == null || datepart.length() == 0) {
            throw new FormaterException("Function datediff loss datepart");
        }
        datepart = datepart.toUpperCase(Locale.ENGLISH);
        buffer.append("TIMESTAMPDIFF(");
        if ("YEAR".equals(datepart) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
            buffer.append("YEAR,");
        } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
            buffer.append("MONTH,");
        } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
            buffer.append("DAY,");
        } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
            buffer.append("HOUR,");
        } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
            buffer.append("MINUTE,");
        } else {
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("Function datediff not support datepart:" + datepart);
            buffer.append("SECOND,");
        }
        formater.formatExpr((SqlExpr)expr.parameters.get(1));
        buffer.append(" , ");
        formater.formatExpr((SqlExpr)expr.parameters.get(2));
        buffer.append(") ");
    }
}

