/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import java.util.Collection;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.HintsParser;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SelectParser;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.ksql.rebuild.SqlStmtRebuilder;

public class InsertParser {
    private final TokenList _tokenList;

    public InsertParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
    }

    public InsertParser(TokenList tokenList) {
        this._tokenList = tokenList;
    }

    public final SqlInsert insert() throws ParserException {
        boolean flag;
        String insertWord = this._tokenList.lookup(0).getOrgValue();
        this._tokenList.match(Token.InsertToken);
        String hints = null;
        if (this._tokenList.lookup((int)0).type == 16) {
            hints = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
        }
        String intoWord = "";
        if (this._tokenList.lookup(0).equals(Token.IntoToken)) {
            intoWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
        }
        String tableName = this._tokenList.lookup((int)0).value;
        SqlInsert sqlInsert = new SqlInsert(tableName);
        sqlInsert.setInsertWord(insertWord);
        sqlInsert.setIntoWord(intoWord);
        if (hints != null) {
            sqlInsert.getHints().addAll(HintsParser.parse(hints));
        }
        this._tokenList.match(1);
        if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
            this._tokenList.match();
            sqlInsert.tableName = sqlInsert.tableName + '.' + this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
        }
        this.columnList(sqlInsert.columnList);
        if (this._tokenList.lookup(0).equals(Token.ValuesToken)) {
            sqlInsert.setValuesWord(this._tokenList.lookup(0).getOrgValue());
        }
        if (!(flag = this.valueList(sqlInsert.valueList))) {
            SelectParser selectParser = new SelectParser(this._tokenList);
            sqlInsert.subQuery = selectParser.select();
        }
        SqlStmtRebuilder.rebuild(sqlInsert);
        return sqlInsert;
    }

    public final void columnList(Collection exprCol) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            String colName = this._tokenList.lookup((int)0).value;
            String orgColName = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(1);
            SqlIdentifierExpr expr = new SqlIdentifierExpr(colName, orgColName);
            exprCol.add(expr);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                colName = this._tokenList.lookup((int)0).value;
                orgColName = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(1);
                expr = new SqlIdentifierExpr(colName, orgColName);
                exprCol.add(expr);
            }
            this._tokenList.match(Token.CloseBraceToken);
        }
    }

    public final boolean valueList(Collection exprCol) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.ValuesToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            SqlExprParser parser = new SqlExprParser(this._tokenList);
            SqlExpr expr = parser.expr();
            exprCol.add(expr);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                expr = parser.expr();
                exprCol.add(expr);
            }
            this._tokenList.match(Token.CloseBraceToken);
            return true;
        }
        return false;
    }
}

