/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.procedures.tdsql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class AlterColumnProcedure {
    private static final String queryColumnSql = "SELECT 1 FROM information_schema.columns WHERE TABLE_SCHEMA = SCHEMA() AND table_name = '%s' AND column_name = '%s'";
    private static final String dropColumnSql = "ALTER TABLE %s DROP COLUMN %s";
    private static final String updateDefaultValueSql = "UPDATE %s SET %s = %s WHERE %s IS NULL";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void call(Statement statement, String tableName, String columnName, String columnType, String columnIsNull, String modifyFlag, String defaultValue) throws SQLException {
        Throwable throwable;
        ResultSet resultSet;
        tableName = tableName.toUpperCase(Locale.ENGLISH);
        columnName = columnName.toUpperCase(Locale.ENGLISH);
        columnIsNull = columnIsNull.toUpperCase(Locale.ENGLISH);
        modifyFlag = modifyFlag.toUpperCase(Locale.ENGLISH);
        String realColumnType = AlterColumnProcedure.toColumnType(columnType);
        if ((defaultValue = AlterColumnProcedure.handleDefaultValue(defaultValue)) != null) {
            resultSet = statement.executeQuery(String.format("select concat('%s')", defaultValue));
            throwable = null;
            try {
                if (resultSet.next()) {
                    defaultValue = resultSet.getString(1);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        if ("1".equals(modifyFlag.substring(0, 1)) && "NULL".equals(columnType)) {
            resultSet = statement.executeQuery(String.format(queryColumnSql, tableName, columnName));
            throwable = null;
            try {
                if (!resultSet.next()) return;
                statement.execute(String.format(dropColumnSql, tableName, columnName));
                return;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        } else {
            if ("NOT NULL".equalsIgnoreCase(columnIsNull) && "1".equals(modifyFlag.substring(2, 3)) && defaultValue != null && defaultValue.length() > 0) {
                statement.execute(String.format(updateDefaultValueSql, tableName, columnName, defaultValue, columnName));
            }
            String defaultSql = "";
            if (defaultValue != null) {
                defaultSql = " DEFAULT " + defaultValue;
            }
            statement.execute(String.format("ALTER TABLE %s MODIFY %s %s %s %s", tableName, columnName, realColumnType, columnIsNull, defaultSql));
        }
    }

    private static String handleDefaultValue(String defaultValue) {
        String tempValue = null;
        if (defaultValue != null && defaultValue.length() > 0 && !"NULL".equals(defaultValue.toUpperCase(Locale.ENGLISH))) {
            tempValue = "GETDATE()".equals(defaultValue) ? " CURRENT_TIMESTAMP " : (defaultValue.toLowerCase(Locale.ENGLISH).startsWith("{ts") ? defaultValue.substring(3, defaultValue.length() - 1) : defaultValue);
        }
        return tempValue;
    }

    private static String toColumnType(String columnType) {
        switch (columnType) {
            case "IMAGE": {
                return "LONGBLOB";
            }
            case "NCLOB": 
            case "XMLTYPE": {
                return "LONGTEXT";
            }
        }
        return columnType.replaceAll("NVARCHAR", "VARCHAR");
    }
}

