/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.schema;

import kd.bos.ksql.exception.NotSupportedException;

public class KSQLSchemaContext {
    private static final ThreadLocal<KSQLSchemaContext> schemaContextLocal = new ThreadLocal();
    private String routeKey;
    private String schema;
    private boolean changeSchema;
    private int dbType;

    public static KSQLSchemaContext get() {
        return schemaContextLocal.get();
    }

    public static KSQLSchemaContext getOrCreate() {
        KSQLSchemaContext schemaContext = schemaContextLocal.get();
        if (schemaContext == null) {
            schemaContextLocal.set(new KSQLSchemaContext());
        }
        return schemaContextLocal.get();
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema.trim();
    }

    public boolean isChangeSchema() {
        return this.changeSchema;
    }

    public void setChangeSchema(boolean changeSchema) {
        this.changeSchema = changeSchema;
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        if (this.dbType == 6 || this.dbType == 17 || this.dbType == 19) {
            sb.append("use ");
        } else if (this.dbType == 5) {
            sb.append("set search_path to ");
        } else {
            throw new NotSupportedException("Unsupported database type when multi tenant connection pool sharing is enabled");
        }
        sb.append(this.schema);
        return sb.toString();
    }

    public static void clear() {
        schemaContextLocal.remove();
    }
}

