/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.InspectSqlManageAdpter;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.extension.KSQLExtensionsRegister;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.shell.DtsSqlHandle;
import kd.bos.ksql.shell.KDPreparedStatement;
import kd.bos.ksql.shell.KDStatement;
import kd.bos.ksql.shell.VTUtil;
import kd.bos.ksql.shell.nologging.NativeDataSource;
import kd.bos.ksql.shell.trace.ConnectionInfo;
import kd.bos.ksql.shell.trace.ConnectionLogger;
import kd.bos.ksql.shell.trace.KSqlMonitor;
import kd.bos.ksql.shell.trace.LogItem;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger((String)"KDConnection");
    final int conn_id;
    private final Connection conn;
    TraceInfo traceInfo;
    private final int dbType;
    final ConnectionLogger logger;
    private final String id;
    private NativeDataSource nativeDataSource;
    private Connection connByNativeDataSource;
    private int natativeStatementRef = 0;
    private final boolean pgUseRealColumnName;

    public KDConnection(Connection conn, int dbType, TraceInfo traceInfo) {
        this.conn = conn;
        this.dbType = dbType;
        this.traceInfo = traceInfo;
        this.logger = traceInfo.logFileUrl != null ? ConnectionLogger.getLogger(traceInfo.logFileUrl, traceInfo.filter, traceInfo.bindPort) : null;
        KSqlMonitor.getActivateConnectionMap().put(this, new ConnectionInfo());
        int connid = -1;
        try {
            connid = conn.getMetaData().getConnection().hashCode();
        }
        catch (SQLException e) {
            DisCardUtil.discard();
        }
        this.conn_id = connid;
        this.id = new UUTN(true, "CON").toString();
        boolean enablePGUseRealColumnName = false;
        try {
            enablePGUseRealColumnName = Boolean.parseBoolean(System.getProperty("ksql.pg.use_real_column_name", "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pgUseRealColumnName = enablePGUseRealColumnName;
    }

    public String getId() {
        return this.id;
    }

    public TraceInfo getTraceInfo() {
        return this.traceInfo;
    }

    public Connection getNativeConnection() {
        return this.conn;
    }

    public NativeDataSource getNativeDataSource() {
        return this.nativeDataSource;
    }

    public void setNativeDataSource(NativeDataSource dataSource) {
        this.nativeDataSource = dataSource;
    }

    public synchronized Connection getConnectionByNativeDataSource() throws SQLException {
        if (this.connByNativeDataSource == null) {
            this.connByNativeDataSource = this.nativeDataSource.getConnection();
        }
        return this.connByNativeDataSource;
    }

    public synchronized void closeConnectionByNativeDataSource() throws SQLException {
        if (this.connByNativeDataSource != null && this.natativeStatementRef == 0) {
            try {
                this.connByNativeDataSource.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                log.warn(e.getMessage(), (Throwable)e);
            }
            this.connByNativeDataSource = null;
        }
    }

    public synchronized void incNativeStatementRef() {
        ++this.natativeStatementRef;
    }

    public synchronized void decNativeStatementRef() {
        --this.natativeStatementRef;
    }

    public int getDbType() {
        return this.dbType;
    }

    public boolean isPgUseRealColumnName() {
        return this.pgUseRealColumnName;
    }

    public TraceInfo traceInfo() {
        return this.traceInfo;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        KSqlMonitor.getActivateConnectionMap().remove(this);
        this.conn.close();
        KDConnection kDConnection = this;
        synchronized (kDConnection) {
            if (this.connByNativeDataSource != null) {
                try {
                    this.connByNativeDataSource.close();
                }
                catch (Exception t) {
                    log.warn(t.getMessage(), (Throwable)t);
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return KSQLExtensionsRegister.extendKDStatement(this.conn.createStatement(), this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return KSQLExtensionsRegister.extendKDStatement(this.conn.createStatement(resultSetType, resultSetConcurrency), this);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        if (this.dbType == 1 || this.dbType == 9) {
            return new HashMap();
        }
        return this.conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    private String getSql(String ksql) throws SQLException {
        return this.getSql(ksql, null);
    }

    private String getSql(String ksql, FormaterContext formaterContext) throws SQLException {
        String sql;
        try {
            if (this.traceInfo != null && this.traceInfo.translate) {
                FormatOptions options = new FormatOptions();
                options.setSaveColumnName2Context(this.pgUseRealColumnName && (this.dbType == 5 || this.dbType == 104));
                sql = TransUtil.translate(ksql, this.dbType, options, formaterContext, false);
            } else {
                sql = ksql;
            }
        }
        catch (SqlTranslateException ex) {
            throw new SQLException("translate sql exception, message is \n" + ex.getMessage());
        }
        return sql;
    }

    @Override
    public String nativeSQL(String ksql) throws SQLException {
        String sql = this.getSql(ksql);
        return this.conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String ksql) throws SQLException {
        String sql = this.getSql(ksql);
        return this.conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String ksql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String sql = this.getSql(ksql);
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formarterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formarterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    private LogItem beginLog(long startTime, long transTime, String ksql, String sql) {
        LogItem logItem = null;
        if (ConnectionLogger.isValid()) {
            logItem = new LogItem();
            logItem.url = this.traceInfo.url;
            logItem.username = this.traceInfo.userName;
            logItem.password = this.traceInfo.pwd;
            logItem.method = "KDConnection.prepareStatement";
            logItem.executeTime = new Timestamp(startTime);
            logItem.transtimespan = transTime - startTime;
            logItem.dbType = this.dbType;
            logItem.ksql = ksql;
            logItem.dialect_sql = sql;
            logItem.conn_id = this.conn_id;
            logItem.bytes = sql.length();
        }
        return logItem;
    }

    private void endLog(LogItem logItem, long startTime) {
        if (logItem != null && ConnectionLogger.isValid()) {
            logItem.timespan = System.currentTimeMillis() - startTime;
            this.logger.write(logItem);
        }
        if (InspectSqlManageAdpter.isEnable()) {
            InspectSqlManageAdpter.filter(logItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql, int resultSetType, int resultSetConcurrency) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formarterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formarterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        ArrayList ls = new ArrayList();
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql, resultSetType, resultSetConcurrency), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            ps.setTempTableInfoOfLongIds(ls);
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    private FormaterContext getFormaterContext() {
        FormaterContext formarterContext = new FormaterContext();
        if (this.traceInfo != null) {
            formarterContext.setProperty("routeKey", this.traceInfo.getRouteKey());
        }
        if (this.dbType == 105 || this.dbType == 17 || this.dbType == 19 || this.dbType == 6 || this.dbType == 18) {
            formarterContext.setProperty("conn", this.conn);
        }
        return formarterContext;
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if ((this.dbType == 2 || this.dbType == 7 || this.dbType == 8) && level == 1) {
            return;
        }
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new KDStatement(stmt, this);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public CallableStatement prepareCall(String ksql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String sql = this.getSql(ksql);
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formarterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formarterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql, int autoGeneratedKeys) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formarterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formarterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql, autoGeneratedKeys), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql, autoGeneratedKeys), this, ksql, sql, formarterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql, int[] columnIndexes) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql, columnIndexes), this, ksql, sql, formaterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql, columnIndexes), this, ksql, sql, formaterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String ksql, String[] columnNames) throws SQLException {
        KDPreparedStatement ps;
        long startTime = System.currentTimeMillis();
        long transTime = -1L;
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        DtsSqlHandle.prepareParse(ksql);
        sql = VTUtil.decorate(sql, this.dbType);
        transTime = System.currentTimeMillis();
        LogItem logItem = null;
        try {
            logItem = this.beginLog(startTime, transTime, ksql, sql);
            if (VTUtil.needNewTransaction(this.conn, this.dbType, sql)) {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.getConnectionByNativeDataSource().prepareStatement(sql, columnNames), this, ksql, sql, formaterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
                ps.createByNativeDataSource = true;
                this.incNativeStatementRef();
            } else {
                PreparedStatement preparedStatement = KSQLExtensionsRegister.extendPreparedStatement(this.conn.prepareStatement(sql, columnNames), this, ksql, sql, formaterContext);
                ps = preparedStatement.unwrap(KDPreparedStatement.class);
            }
            this.endLog(logItem, startTime);
        }
        catch (Throwable throwable) {
            this.endLog(logItem, startTime);
            throw throwable;
        }
        return ps;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

