/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

import com.oceanbase.jdbc.OceanBaseConnection;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.util.CharacterSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.InspectSqlManageAdpter;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.XINItem;
import kd.bos.ksql.XINParams;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.shell.DtsSqlHandle;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.KDResultSet;
import kd.bos.ksql.shell.KDResultSetMetaData;
import kd.bos.ksql.shell.KDStatement;
import kd.bos.ksql.shell.KSQLLogOption;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import kd.bos.ksql.shell.trace.ConnectionInfo;
import kd.bos.ksql.shell.trace.ConnectionLogger;
import kd.bos.ksql.shell.trace.KSqlMonitor;
import kd.bos.ksql.shell.trace.LogItem;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.temptable.KsqlTempTableFactory;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;
import org.apache.log4j.Logger;

public class KDPreparedStatement
extends KDStatement
implements PreparedStatement {
    private static final Logger logger = Logger.getLogger(KDPreparedStatement.class);
    public final int MAX_STRING_LENGTH = 1000;
    public final int YASDB_MAX_STRING_LENGTH = 32000;
    public final int YASDB_MAX_BYTES_LENGTH = 32000;
    public final int OB_MAX_STRING_LENGTH = Short.MAX_VALUE;
    private final String ksql;
    private final String dialect_sql;
    private final Object[] params;
    private final Object[] paramsAfterMap;
    private final ParamIndexer indexer;
    private final int conn_id;
    boolean createByNativeDataSource = false;
    protected FormaterContext formaterContext = new FormaterContext();
    private static final String XINITEMS_KEY = "xinitems";
    private List<XINItem> xinItems = new ArrayList<XINItem>();
    private boolean ignore;
    List tempTableInfoOfLongIds = null;

    protected KDPreparedStatement(PreparedStatement stmt, KDConnection cn, String ksql, String dialect_sql) throws SQLException {
        super(stmt, cn);
        this.ksql = ksql;
        this.dialect_sql = dialect_sql;
        this.ignore = dialect_sql.startsWith("/*ignore*/");
        this.conn_id = cn.conn_id;
        int sqlParamCount = KDPreparedStatement.getSqlParamCount(this.ksql);
        int dialectSqlParamCount = KDPreparedStatement.getSqlParamCount(this.dialect_sql);
        this.indexer = dialectSqlParamCount != sqlParamCount ? new MapParamIndexer(sqlParamCount, dialectSqlParamCount, this.ksql, this.dbType, cn.traceInfo()) : new SimpleParamIndexer(dialectSqlParamCount);
        Object[] ps = null;
        Object[] pam = null;
        ps = new Object[sqlParamCount];
        if (dialectSqlParamCount != sqlParamCount) {
            pam = new Object[dialectSqlParamCount];
        }
        this.params = ps;
        this.paramsAfterMap = pam;
    }

    public KDPreparedStatement(PreparedStatement stmt, KDConnection cn, String ksql, String dialect_sql, FormaterContext formaterContext) throws SQLException {
        super(stmt, cn);
        this.ksql = ksql;
        this.dialect_sql = dialect_sql;
        this.ignore = dialect_sql.startsWith("/*ignore*/");
        this.conn_id = cn.conn_id;
        int sqlParamCount = KDPreparedStatement.getSqlParamCount(this.ksql);
        int dialectSqlParamCount = KDPreparedStatement.getSqlParamCount(this.dialect_sql);
        if (this.isContainsXin(formaterContext)) {
            this.xinItems = (List)formaterContext.getProperty(XINITEMS_KEY);
            this.indexer = new XINParamIndexer(dialectSqlParamCount);
        } else {
            this.indexer = dialectSqlParamCount != sqlParamCount ? new MapParamIndexer(sqlParamCount, dialectSqlParamCount, this.ksql, this.dbType, cn.traceInfo()) : new SimpleParamIndexer(dialectSqlParamCount);
        }
        Object[] ps = null;
        Object[] pam = null;
        ps = new Object[sqlParamCount];
        if (dialectSqlParamCount != sqlParamCount) {
            pam = new Object[dialectSqlParamCount];
        }
        this.params = ps;
        this.paramsAfterMap = pam;
        this.formaterContext = formaterContext;
        if (this.formaterContext != null) {
            this.realColumns = (List)formaterContext.getContextProperty("realColumnNames");
        }
    }

    private boolean isContainsXin(FormaterContext formaterContext) {
        return formaterContext != null && formaterContext.getProperty(XINITEMS_KEY) != null;
    }

    private static int getSqlParamCount(String sql) {
        int sqlParamCount = 0;
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch != '?') continue;
            ++sqlParamCount;
        }
        return sqlParamCount;
    }

    private void fillLogParameters(LogItem logItem) {
        int i;
        int size;
        if (this.params != null && this.params.length != 0) {
            if (logItem.parameters == null) {
                logItem.parameters = new ArrayList(this.params.length);
            }
            size = this.params.length;
            for (i = 0; i < size; ++i) {
                logItem.parameters.add(this.params[i]);
                if (this.params[i] == null) continue;
                logItem.bytes += (long)this.params[i].toString().length();
            }
        }
        if (this.paramsAfterMap != null && this.paramsAfterMap.length != 0) {
            if (logItem.parametersMapping == null) {
                logItem.parametersMapping = new ArrayList(this.paramsAfterMap.length);
            }
            size = this.paramsAfterMap.length;
            for (i = 0; i < size; ++i) {
                logItem.parametersMapping.add(this.paramsAfterMap[i]);
            }
        }
    }

    private LogItem beginLog(String method, long startTime) {
        LogItem logItem = null;
        if (ConnectionLogger.isValid()) {
            logItem = new LogItem();
            logItem.url = this.cn.traceInfo.url;
            logItem.username = this.cn.traceInfo.userName;
            logItem.password = this.cn.traceInfo.pwd;
            logItem.method = method;
            logItem.executeTime = new Timestamp(startTime);
            logItem.ksql = this.ksql;
            logItem.dialect_sql = this.dialect_sql;
            logItem.dbType = this.dbType;
            logItem.conn_id = this.conn_id;
            logItem.bytes = 0L;
        }
        return logItem;
    }

    private void endLog(LogItem logItem, long startTime, int updateCount, String activateConnectionTrace) throws SQLException {
        if (InspectSqlManageAdpter.isEnable()) {
            InspectSqlManageAdpter.filter(logItem);
        }
        if (logItem == null) {
            return;
        }
        long endTime = System.currentTimeMillis();
        logItem.timespan = endTime - startTime;
        if (ConnectionLogger.isValid()) {
            if (updateCount != 0) {
                logItem.updateCount = updateCount;
            }
            this.fillLogParameters(logItem);
            this.cn.logger.write(logItem);
            if (activateConnectionTrace != null) {
                this.activateConnectionTrace(activateConnectionTrace);
            }
        }
    }

    private void logSQLException(LogItem logItem, SQLException ex, boolean isOutput) {
        if (ConnectionLogger.isValid() && logItem != null) {
            logItem.errorMessage = ex.getMessage();
        }
        if (!KSQLLogOption.getOption().isLogStatementExecuteError()) {
            return;
        }
        if (isOutput) {
            logger.error((Object)("execute sql error: " + ex.getMessage() + "\r\nsql:" + this.dialect_sql + "\r\nksql:" + this.ksql));
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkInterrupt();
        ((PreparedStatement)this.stmt).addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.stmt).clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean rtnVal;
        if (this.ignore) {
            return false;
        }
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.execute", startTime);
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.execute);
            rtnVal = ((PreparedStatement)this.stmt).execute();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
            this.appendCommit(this.dialect_sql);
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, false);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, this.stmt.getUpdateCount(), this.ksql);
            }
            this.releaseXinTempTable();
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.executePrepare(this.params);
        return rtnVal;
    }

    private void releaseXinTempTable() {
        for (XINItem item : this.xinItems) {
            if (!item.isToTempTable()) continue;
            KsqlTempTableFactory.get().release(item.getPkTempTable());
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        KDResultSet kd_rs;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeQuery", startTime);
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeQuery);
            ResultSet rs = ((PreparedStatement)this.stmt).executeQuery();
            kd_rs = rs == null ? null : new KDResultSet(rs, this);
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, false);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, 0, this.ksql);
            this.releaseXinTempTable();
            this.stopQueryTimer(false, false, oldTimeout);
        }
        if (kd_rs != null) {
            kd_rs.setRealColumns(this.realColumns);
        }
        return kd_rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.ignore) {
            return 0;
        }
        this.checkInterrupt();
        int rtnVal = -1;
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeUpdate", startTime);
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            rtnVal = ((PreparedStatement)this.stmt).executeUpdate();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, false);
            throw ex;
        }
        finally {
            this.releaseXinTempTable();
            this.stopQueryTimer(false, false, oldTimeout);
            this.endLog(logItem, startTime, rtnVal, this.ksql);
        }
        DtsSqlHandle.executePrepare(this.params);
        return rtnVal;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.ignore) {
            return new int[]{0};
        }
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("KDPreparedStatement.executeBatch", startTime);
        int oldTimeout = this.getQueryTimeout();
        int[] rtnVal = null;
        try {
            if (!this.xinItems.isEmpty()) {
                this.releaseXinTempTable();
                throw new RuntimeException("XIN grammar not support executeBatch");
            }
            this.startQueryTimer(oldTimeout, ExecuteType.executeBatch);
            rtnVal = this.stmt.executeBatch();
            if (this.createByNativeDataSource) {
                this.cn.getConnectionByNativeDataSource().commit();
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, false);
            throw ex;
        }
        finally {
            int updateCount = 0;
            if (logItem != null && rtnVal != null) {
                for (int i = 0; i < rtnVal.length; ++i) {
                    updateCount += rtnVal[i];
                }
            }
            this.stopQueryTimer(false, false, oldTimeout);
            this.endLog(logItem, startTime, updateCount, "execute batch.");
        }
        return rtnVal;
    }

    @Override
    public boolean execute(String ksql) throws SQLException {
        return super.execute(ksql);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return 0L;
    }

    @Override
    public ResultSet executeQuery(String ksql) throws SQLException {
        return super.executeQuery(ksql);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        KDResultSetMetaData metaData = new KDResultSetMetaData(((PreparedStatement)this.stmt).getMetaData(), this.dbType);
        metaData.setRealColumns(this.realColumns);
        return metaData;
    }

    @Override
    public void setArray(int index, Array val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setArray(paras[i], val);
            }
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream val, int length) throws SQLException {
        block6: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block6;
            if (this.dbType == 1 || this.dbType == 9 || this.dbType == 2 || this.dbType == 7 || this.dbType == 8) {
                byte[] bytes = new byte[length];
                try {
                    val.read(bytes);
                    val.reset();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                    throw new SQLException("can not read inputstream to bytes." + e.getMessage());
                }
                String str = new String(bytes);
                this.setLogParams(index, str);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], str);
                    ((PreparedStatement)this.stmt).setString(paras[i], str);
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setAsciiStream(paras[i], val, length);
                }
            }
        }
    }

    @Override
    public void setBigDecimal(int index, BigDecimal val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                if (val != null && this.dbType == 3 && val.setScale(0, RoundingMode.HALF_UP).compareTo(val) == 0) {
                    ((PreparedStatement)this.stmt).setObject(paras[i], val.toBigInteger());
                    continue;
                }
                ((PreparedStatement)this.stmt).setBigDecimal(paras[i], val);
            }
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBinaryStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setBlob(int index, Blob val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setBlob(paras[i], val);
            }
        }
    }

    @Override
    public void setBoolean(int index, boolean val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val ? Boolean.TRUE : Boolean.FALSE);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val ? Boolean.TRUE : Boolean.FALSE);
                if (this.dbType == 5 || this.dbType == 104) {
                    ((PreparedStatement)this.stmt).setInt(paras[i], val ? 1 : 0);
                    continue;
                }
                ((PreparedStatement)this.stmt).setBoolean(paras[i], val);
            }
        }
    }

    @Override
    public void setByte(int index, byte val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Byte(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Byte(val));
                ((PreparedStatement)this.stmt).setByte(paras[i], val);
            }
        }
    }

    @Override
    public void setBytes(int index, byte[] val) throws SQLException {
        block4: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block4;
            if (this.dbType == 20 && val != null && val.length > 32000) {
                YasConnection yasConnection = (YasConnection)this.cn.getNativeConnection();
                Blob blob = yasConnection.createBlob();
                blob.setBytes(1L, val);
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setBlob(paras[i], blob);
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setBytes(paras[i], val);
                }
            }
        }
    }

    @Override
    public void setCharacterStream(int index, Reader val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setCharacterStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setClob(int index, Clob val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setClob(paras[i], val);
            }
        }
    }

    @Override
    public void setDate(int index, Date val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setDate(paras[i], val);
            }
        }
    }

    @Override
    public void setDate(int index, Date val, Calendar p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setDate(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setDouble(int index, double val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Double(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Double(val));
                ((PreparedStatement)this.stmt).setDouble(paras[i], val);
            }
        }
    }

    @Override
    public void setFloat(int index, float val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Float(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Float(val));
                ((PreparedStatement)this.stmt).setFloat(paras[i], val);
            }
        }
    }

    @Override
    public void setInt(int index, int val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setInt(paras[i], val);
            }
        }
    }

    @Override
    public void setLong(int index, long val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Long(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Long(val));
                ((PreparedStatement)this.stmt).setLong(paras[i], val);
            }
        }
    }

    @Override
    public void setNull(int index, int sqlType) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, null);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], null);
                ((PreparedStatement)this.stmt).setNull(paras[i], sqlType);
            }
        }
    }

    @Override
    public void setNull(int index, int p2, String p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, null);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], null);
                ((PreparedStatement)this.stmt).setNull(paras[i], p2, p3);
            }
        }
    }

    @Override
    public void setObject(int index, Object val) throws SQLException {
        block10: {
            block9: {
                if (val == null || !(val instanceof XINParams)) break block9;
                this.setXINParams(index, (XINParams)val);
                break block10;
            }
            int[] paras = this.indexer.get(index);
            if (paras == null) break block10;
            if (this.dbType == 5 || this.dbType == 104) {
                if (val instanceof Boolean) {
                    val = (Boolean)val != false ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                if (val instanceof String) {
                    String str = (String)val;
                    if (str.length() == 44 && str.charAt(43) == ' ') {
                        str = str.trim();
                        this.setString(index, str);
                    } else {
                        this.setObject(index, (Object)str, 1111);
                    }
                } else {
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setObject(paras[i], val);
                    }
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setObject(paras[i], val);
                }
            }
        }
    }

    private void setXINParams(int index, XINParams xinParams) throws SQLException {
        int[] paras;
        if (this.xinItems.isEmpty()) {
            throw new RuntimeException("kd.bos.ksql.XINParams is only the XIN grammar param, but the sql not contains XIN grammar.");
        }
        XINItem xinItem = null;
        for (XINItem item : this.xinItems) {
            if (item.isHaveSetObject()) continue;
            xinItem = item;
            break;
        }
        if (xinItem == null) {
            throw new RuntimeException("kd.bos.ksql.XINParams is only the XIN grammar param.");
        }
        xinItem.setParamIndex(index);
        if (xinItem.isToTempTable()) {
            KsqlTempTableFactory.get().insert(xinItem.getPkTempTable(), Arrays.asList(xinParams.getParams()));
            paras = this.indexer.get(index);
            int setIndex = paras[0];
            this.setLogParams(index, xinParams);
            this.setLogParamsMap(index, xinParams);
            ((PreparedStatement)this.stmt).setObject(setIndex, 1);
        } else {
            paras = this.indexer.get(index);
            this.setLogParams(index, xinParams);
            this.setLogParamsMap(index, xinParams);
            int setIndex = paras[0];
            for (Object param : xinParams.getParams()) {
                if (this.dbType == 5 || this.dbType == 104) {
                    if (param instanceof String) {
                        String str = (String)param;
                        if (str.length() == 44 && str.charAt(43) == ' ') {
                            str = str.trim();
                            ((PreparedStatement)this.stmt).setString(setIndex, str);
                        } else {
                            ((PreparedStatement)this.stmt).setObject(setIndex, (Object)str, 1111);
                        }
                    } else {
                        ((PreparedStatement)this.stmt).setObject(setIndex, param);
                    }
                } else {
                    ((PreparedStatement)this.stmt).setObject(setIndex, param);
                }
                xinItem.setMoveBackFlag(xinItem.getMoveBackFlag() + 1);
                ++setIndex;
            }
        }
        xinItem.setHaveSetObject(true);
    }

    @Override
    public void setObject(int index, Object val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setObject(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setObject(int index, Object val, int p3, int p4) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setObject(paras[i], val, p3, p4);
            }
        }
    }

    @Override
    public void setRef(int index, Ref val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setRef(paras[i], val);
            }
        }
    }

    @Override
    public void setShort(int index, short val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, new Short(val));
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], new Short(val));
                ((PreparedStatement)this.stmt).setShort(paras[i], val);
            }
        }
    }

    @Override
    public void setString(int index, String val) throws SQLException {
        block16: {
            int[] paras = this.indexer.get(index);
            if (paras == null) break block16;
            if ((this.dbType == 2 || this.dbType == 7) && val != null && val.length() > 1000) {
                OraclePreparedStatement oracleStmt = (OraclePreparedStatement)this.stmt;
                CLOB clob = CLOB.createTemporary((Connection)this.cn.getNativeConnection(), (boolean)true, (int)1);
                oracleStmt.setFormOfUse(index, (short)2);
                clob.setString(1L, val);
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setClob(paras[i], (Clob)clob);
                }
            } else if (this.dbType == 20 && val != null) {
                YasConnection yasConnection = (YasConnection)this.cn.getNativeConnection();
                if (this.getParamLength(val, yasConnection.getSession().getCharset()) > 32000) {
                    Clob clob = yasConnection.createClob();
                    clob.setString(1L, val);
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setClob(paras[i], clob);
                    }
                } else {
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setString(paras[i], val);
                    }
                }
            } else if (this.dbType == 21 && val != null) {
                OceanBaseConnection oceanBaseConnection = (OceanBaseConnection)this.cn.getNativeConnection();
                if (val.length() > Short.MAX_VALUE) {
                    Clob clob = oceanBaseConnection.createClob();
                    clob.setString(1L, val);
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setClob(paras[i], clob);
                    }
                } else {
                    this.setLogParams(index, val);
                    for (int i = 0; i < paras.length; ++i) {
                        this.setLogParamsMap(paras[i], val);
                        ((PreparedStatement)this.stmt).setString(paras[i], val);
                    }
                }
            } else {
                this.setLogParams(index, val);
                for (int i = 0; i < paras.length; ++i) {
                    this.setLogParamsMap(paras[i], val);
                    ((PreparedStatement)this.stmt).setString(paras[i], val);
                }
            }
        }
    }

    public int getParamLength(String value, short charset) {
        int slen = value.getBytes(CharacterSet.getCharSet((short)charset)).length;
        return slen < 253 ? slen + 1 : slen + 3;
    }

    private void setLogParams(int index, Object val) {
        if (this.params != null && this.params.length >= index) {
            this.params[index - 1] = val;
        }
    }

    private void setLogParamsMap(int index, Object val) {
        if (this.paramsAfterMap != null && this.paramsAfterMap.length >= index) {
            this.paramsAfterMap[index - 1] = val;
        }
    }

    @Override
    public void setTime(int index, Time val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTime(paras[i], val);
            }
        }
    }

    @Override
    public void setTime(int index, Time val, Calendar p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTime(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTimestamp(paras[i], val);
            }
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp val, Calendar p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setTimestamp(paras[i], val, p3);
            }
        }
    }

    @Override
    public void setUnicodeStream(int index, InputStream val, int p3) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                ((PreparedStatement)this.stmt).setUnicodeStream(paras[i], val, p3);
            }
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.stmt).getParameterMetaData();
    }

    @Override
    public void setURL(int index, URL val) throws SQLException {
        int[] paras = this.indexer.get(index);
        if (paras != null) {
            this.setLogParams(index, val);
            for (int i = 0; i < paras.length; ++i) {
                this.setLogParamsMap(paras[i], val);
                PreparedStatement preStmt = (PreparedStatement)this.stmt;
                preStmt.setURL(paras[i], val);
            }
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        ConnectionInfo connInfo;
        Map activateConnInfoMap;
        this.stmt.close();
        if (this.createByNativeDataSource) {
            this.cn.decNativeStatementRef();
            this.cn.closeConnectionByNativeDataSource();
        }
        if (ConnectionLogger.isValid() && (activateConnInfoMap = KSqlMonitor.getActivateConnectionMap()) != null && (connInfo = (ConnectionInfo)activateConnInfoMap.get(this.getConnection())) != null && connInfo.lastStmtInfo != null) {
            connInfo.lastStmtInfo.closedTime = System.currentTimeMillis();
        }
    }

    public void setTempTableInfoOfLongIds(List ls) {
        this.tempTableInfoOfLongIds = ls;
    }

    public void setClob(int index, CLOB val, boolean matchIndex) throws SQLException {
        if (matchIndex) {
            this.setLogParamsMap(index, val);
            ((PreparedStatement)this.stmt).setClob(index, (Clob)val);
        }
    }

    private static class MapParamIndexer
    implements ParamIndexer {
        private final int[][] array;
        private final int totalCount;

        MapParamIndexer(int count, int totalCount, String ksql, int dbType, TraceInfo traceInfo) throws SQLException {
            this.array = new int[count][];
            this.totalCount = totalCount;
            ArrayList params = new ArrayList(count);
            try {
                ArrayList<String> questionMark = new ArrayList<String>(count);
                char ch = '\u0001';
                String tempSql = ksql;
                String character = null;
                while (tempSql.indexOf("?") > -1) {
                    while (ch == '$' || ch == '\'' || ch == '\\' || tempSql.indexOf(String.valueOf(ch)) != -1) {
                        ch = (char)(ch + 1);
                    }
                    character = "'" + ch + "'";
                    tempSql = tempSql.replaceFirst("[?]", character);
                    questionMark.add(character);
                    params.add(new ArrayList(4));
                    ch = (char)(ch + '\u0001');
                }
                String tempDiaSql = TransUtil.translate(tempSql, dbType);
                int len = tempDiaSql.length();
                boolean questionMarkFlag = false;
                String questionMarkCheckStr = "";
                int m = 1;
                for (int i = 0; i < len; ++i) {
                    ch = tempDiaSql.charAt(i);
                    if (questionMarkFlag) {
                        questionMarkCheckStr = questionMarkCheckStr + ch;
                        if (ch != 39) continue;
                        questionMarkFlag = false;
                        int questionMarkIndex = questionMark.indexOf(questionMarkCheckStr);
                        if (questionMarkIndex != -1) {
                            ((List)params.get(questionMarkIndex)).add(m);
                            ++m;
                        }
                        questionMarkCheckStr = "";
                        continue;
                    }
                    if (ch != 39) continue;
                    questionMarkFlag = true;
                    questionMarkCheckStr = "'";
                }
                questionMark = null;
            }
            catch (SqlTranslateException ex) {
                throw new SQLException(ex.getMessage());
            }
            for (int i = 0; i < count; ++i) {
                List lst = (List)params.get(i);
                int size = lst.size();
                int[] item = new int[size];
                for (int j = 0; j < size; ++j) {
                    item[j] = (Integer)lst.get(j);
                }
                this.array[i] = item;
            }
        }

        @Override
        public int[] get(int index) {
            if (index >= 1 && index <= this.array.length) {
                return this.array[index - 1];
            }
            if (index > this.array.length && index <= this.totalCount) {
                return null;
            }
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.totalCount);
        }
    }

    private class XINParamIndexer
    implements ParamIndexer {
        private final int[][] array;

        XINParamIndexer(int count) {
            this.array = new int[count][1];
            for (int i = 0; i < count; ++i) {
                this.array[i][0] = i + 1;
            }
        }

        @Override
        public int[] get(int index) {
            int moveBackIndexFlag = 0;
            for (XINItem item : KDPreparedStatement.this.xinItems) {
                if (index <= item.getParamIndex()) continue;
                moveBackIndexFlag += item.getMoveBackFlag();
            }
            if (moveBackIndexFlag > 0) {
                --moveBackIndexFlag;
            }
            if (index >= 1 && index <= this.array.length) {
                int[] result = new int[]{this.array[index - 1][0] + moveBackIndexFlag};
                return result;
            }
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.array.length);
        }
    }

    private static class SimpleParamIndexer
    implements ParamIndexer {
        private final int[][] array;

        SimpleParamIndexer(int count) {
            this.array = new int[count][1];
            for (int i = 0; i < count; ++i) {
                this.array[i][0] = i + 1;
            }
        }

        @Override
        public int[] get(int index) {
            if (index >= 1 && index <= this.array.length) {
                return this.array[index - 1];
            }
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.array.length);
        }
    }

    private static interface ParamIndexer {
        public int[] get(int var1);
    }
}

