/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell;

import com.huawei.opengauss.jdbc.util.PSQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.InspectSqlManageAdpter;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.shell.DtsSqlHandle;
import kd.bos.ksql.shell.IInterruptListener;
import kd.bos.ksql.shell.InternalDataProcessor;
import kd.bos.ksql.shell.InternalDataResultSet;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.KDResultSet;
import kd.bos.ksql.shell.KSQLLogOption;
import kd.bos.ksql.shell.KSQLSettingFactory;
import kd.bos.ksql.shell.VTUtil;
import kd.bos.ksql.shell.timeout.TimeoutConfig;
import kd.bos.ksql.shell.timeout.timer.KsqlCancelService;
import kd.bos.ksql.shell.timeout.timer.SharedTimer;
import kd.bos.ksql.shell.timeout.timer.TimerExecutorService;
import kd.bos.ksql.shell.timeout.timer.TimerType;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import kd.bos.ksql.shell.timeout.timetask.TimeoutTaskFactory;
import kd.bos.ksql.shell.trace.ConnectionInfo;
import kd.bos.ksql.shell.trace.ConnectionLogger;
import kd.bos.ksql.shell.trace.KSqlMonitor;
import kd.bos.ksql.shell.trace.LogItem;
import kd.bos.ksql.shell.trace.StatementInfo;
import kd.bos.util.DisCardUtil;
import org.apache.log4j.Logger;
import org.gbase.util.PSQLState;

public class KDStatement
implements Statement {
    private static final Logger logger = Logger.getLogger(KDStatement.class);
    private final boolean pgUseRealColumnName;
    private static final HashMap<Integer, Long> conn2TestRecordMap = new HashMap();
    private static final Set<IInterruptListener> listenerSet = new HashSet<IInterruptListener>();
    protected final Statement stmt;
    protected final KDConnection cn;
    protected final int dbType;
    private final int conn_id;
    private Statement stmtByNativeDataSource;
    private volatile CancelTimeroutTask cancelTimerOutTask;
    private volatile ScheduledFuture<?> endOfLife;
    private static final AtomicReferenceFieldUpdater<KDStatement, CancelTimeroutTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(KDStatement.class, CancelTimeroutTask.class, "cancelTimerOutTask");
    private ArrayList<String> batchSqls = new ArrayList();
    private ArrayList<FormaterContext> batchSqlFormatContext = new ArrayList();
    protected List<String> realColumns;

    public static void addInterruptListener(IInterruptListener listener) {
        listenerSet.add(listener);
    }

    public static void removeInterruptListener(IInterruptListener listener) {
        listenerSet.remove(listener);
    }

    protected void checkInterrupt() throws SQLException {
    }

    public KDStatement(Statement stmt, KDConnection cn) {
        this.stmt = stmt;
        this.cn = cn;
        this.dbType = cn.getDbType();
        this.cancelTimerOutTask = null;
        int fetchSize = KSQLSettingFactory.getInstance().getFetchSize();
        int sqlExecute_TimeOut = KSQLSettingFactory.getInstance().getSQLExecute_TimeOut();
        int connId = -1;
        try {
            if (fetchSize > 0) {
                stmt.setFetchSize(fetchSize);
            }
            if (sqlExecute_TimeOut > 0) {
                stmt.setQueryTimeout(sqlExecute_TimeOut);
            }
            connId = cn.getMetaData().getConnection().hashCode();
        }
        catch (SQLException e) {
            logger.warn((Object)e);
        }
        this.conn_id = connId;
        this.pgUseRealColumnName = cn.isPgUseRealColumnName();
    }

    protected String getSql(String ksql, FormaterContext formaterContext) throws SQLException {
        String sql;
        try {
            if (this.cn.traceInfo != null && this.cn.traceInfo.translate) {
                FormatOptions options = new FormatOptions();
                options.setSaveColumnName2Context(this.pgUseRealColumnName && (this.dbType == 5 || this.dbType == 104));
                sql = TransUtil.translate(ksql, this.dbType, options, formaterContext, false);
            } else {
                sql = ksql;
            }
        }
        catch (SqlTranslateException ex) {
            throw new SQLException("translate sql exception, message is \n" + ex.getMessage());
        }
        return sql;
    }

    private LogItem beginLog(String method, long startTime, long transTime, String ksql, String sql, long bytes) {
        LogItem logItem = null;
        if (ConnectionLogger.isValid()) {
            logItem = new LogItem();
            logItem.url = this.cn.traceInfo.url;
            logItem.username = this.cn.traceInfo.userName;
            logItem.password = this.cn.traceInfo.pwd;
            logItem.method = method;
            logItem.executeTime = new Timestamp(startTime);
            logItem.dbType = this.dbType;
            if (transTime > 0L) {
                logItem.transtimespan = transTime - startTime;
            }
            logItem.ksql = ksql;
            logItem.dialect_sql = sql;
            logItem.conn_id = this.conn_id;
            logItem.bytes = bytes;
        }
        return logItem;
    }

    private void endLog(LogItem logItem, long startTime, String ksql, int updateCount, String activateConnectionTrace) throws SQLException {
        if (InspectSqlManageAdpter.isEnable()) {
            InspectSqlManageAdpter.filter(logItem);
        }
        if (logItem == null) {
            return;
        }
        if (ConnectionLogger.isValid()) {
            logItem.timespan = System.currentTimeMillis() - startTime;
            this.cn.logger.write(logItem);
            if (updateCount != 0) {
                logItem.updateCount = updateCount;
            }
            if (activateConnectionTrace != null) {
                this.activateConnectionTrace(activateConnectionTrace);
            }
        }
    }

    private void logSQLException(LogItem logItem, SQLException ex, String sql, String ksql) {
        if (ConnectionLogger.isValid() && logItem != null) {
            logItem.errorMessage = ex.getMessage();
        }
        if (!KSQLLogOption.getOption().isLogStatementExecuteError()) {
            return;
        }
        if (sql != null && !this.isTestQuery(sql)) {
            logger.error((Object)("execute sql error: " + ex.getMessage() + "\r\nsql:" + sql + "\r\nksql:" + ksql));
        }
    }

    private Statement getStmtByNativeDataSource() throws SQLException {
        if (this.stmtByNativeDataSource == null) {
            this.stmtByNativeDataSource = this.cn.getConnectionByNativeDataSource().createStatement();
            this.cn.incNativeStatementRef();
        }
        return this.stmtByNativeDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String ksql) throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formarterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formarterContext);
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.addBatch", startTime, transTime, ksql, sql, sql.length());
        try {
            String[] sqls = sql.split("\r\n");
            if (sqls.length > 1 && (this.dbType == 1 || this.dbType == 9 || this.dbType == 6)) {
                for (int i = 0; i < sqls.length; ++i) {
                    String s = sqls[i].substring(0, sqls[i].length() - 1);
                    this.batchSqls.add(s);
                    this.batchSqlFormatContext.add(formarterContext);
                }
            } else {
                this.batchSqls.add(sql);
                this.batchSqlFormatContext.add(formarterContext);
            }
        }
        finally {
            this.endLog(logItem, startTime, ksql, 0, null);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
    }

    protected FormaterContext getFormaterContext() {
        FormaterContext formarterContext = new FormaterContext();
        if (this.cn.traceInfo != null) {
            formarterContext.setProperty("routeKey", this.cn.traceInfo.getRouteKey());
        }
        if (this.dbType == 105 || this.dbType == 17 || this.dbType == 19 || this.dbType == 6 || this.dbType == 18) {
            formarterContext.setProperty("stmt", this.stmt);
        }
        return formarterContext;
    }

    @Override
    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        ConnectionInfo connInfo;
        Map activateConnInfoMap;
        this.stmt.close();
        if (this.stmtByNativeDataSource != null) {
            try {
                this.cn.decNativeStatementRef();
                this.stmtByNativeDataSource.close();
            }
            catch (Exception t) {
                logger.warn((Object)t.getMessage(), (Throwable)t);
            }
            this.cn.closeConnectionByNativeDataSource();
        }
        if (ConnectionLogger.isValid() && (activateConnInfoMap = KSqlMonitor.getActivateConnectionMap()) != null && (connInfo = (ConnectionInfo)activateConnInfoMap.get(this.getConnection())) != null && connInfo.lastStmtInfo != null) {
            connInfo.lastStmtInfo.closedTime = System.currentTimeMillis();
        }
    }

    protected void appendCommit(String sql) throws SQLException {
        VTUtil.appendCommit(this.cn, this.dbType, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String ksql) throws SQLException {
        boolean rtnVal;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return true;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.execute", startTime, transTime, ksql, sql, sql.length());
        if (this.dbType == 1 || this.dbType == 9 || this.dbType == 6 || this.dbType == 17 || this.dbType == 19) {
            String[] sqls = sql.split("\r\n");
            int multiSqlType = -1;
            if (sqls.length == 2 && sqls[0].startsWith("CREATE TABLE ") && sqls[0].endsWith("WITH NO DATA;") && sqls[1].startsWith("INSERT INTO ")) {
                multiSqlType = 0;
            } else if (sqls.length == 3 && sqls[0].startsWith("CREATE PROCEDURE ") && sqls[1].startsWith("CALL ") && sqls[2].startsWith("DROP PROCEDURE ")) {
                multiSqlType = 1;
            } else if (sqls.length >= 3 && sqls[0].startsWith("CREATE TABLE KSQL_TEMP_TABLE_") && sqls[sqls.length / 2].startsWith("UPDATE ") && sqls[sqls.length - 1].startsWith("DROP TABLE IF EXISTS KSQL_TEMP_TABLE_")) {
                multiSqlType = 2;
            }
            if (multiSqlType != -1) {
                int i;
                Statement stmt2 = this.cn.createStatement();
                ArrayList<String> dropSql = new ArrayList<String>();
                if (multiSqlType == 0) {
                    for (i = 0; i < sqls.length; ++i) {
                        stmt2.addBatch("/*dialect*/" + sqls[i].substring(0, sqls[i].length() - 1));
                    }
                } else if (multiSqlType == 1) {
                    for (i = 0; i < sqls.length - 1; ++i) {
                        stmt2.addBatch("/*dialect*/" + sqls[i].substring(0, sqls[i].length() - 1));
                    }
                    dropSql.add("/*dialect*/" + sqls[2].substring(0, sqls[2].length() - 1));
                } else if (multiSqlType == 2) {
                    for (i = 0; i < sqls.length / 2 + 1; ++i) {
                        stmt2.addBatch("/*dialect*/" + sqls[i].substring(0, sqls[i].length() - 1));
                    }
                    for (i = sqls.length / 2 + 1; i < sqls.length; ++i) {
                        dropSql.add("/*dialect*/" + sqls[i].substring(0, sqls[i].length() - 1));
                    }
                }
                int[] rtnVal2 = null;
                try {
                    rtnVal2 = stmt2.executeBatch();
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException ex) {
                    if (!ConnectionLogger.isValid()) throw ex;
                    if (logItem == null) throw ex;
                    logItem.errorMessage = ex.getMessage();
                    throw ex;
                }
                finally {
                    int updateCount = 0;
                    if (logItem != null) {
                        if (rtnVal2 != null) {
                            logItem.updateCount = 0;
                            for (int i2 = 0; i2 < rtnVal2.length; logItem.updateCount += rtnVal2[i2], ++i2) {
                            }
                        }
                        this.endLog(logItem, startTime, ksql, updateCount, "execute batch.");
                    }
                    if (dropSql.size() != 0) {
                        Statement stmt3 = null;
                        int len = dropSql.size();
                        for (int i3 = 0; i3 < len; ++i3) {
                            try {
                                stmt3 = this.cn.createStatement();
                                stmt3.execute((String)dropSql.get(i3));
                                continue;
                            }
                            catch (Exception ex) {
                                DisCardUtil.discard();
                                continue;
                            }
                            finally {
                                try {
                                    if (stmt3 != null) {
                                        stmt3.close();
                                    }
                                }
                                catch (Exception ex) {
                                    DisCardUtil.discard();
                                }
                            }
                        }
                    }
                    try {
                        stmt2.close();
                    }
                    catch (Exception ex) {
                        DisCardUtil.discard();
                    }
                }
            }
        }
        boolean isTestConnection = false;
        boolean isRealTest = false;
        if (this.isTestQuery(sql)) {
            isTestConnection = true;
            Integer connId = this.conn_id;
            Long testTime = conn2TestRecordMap.get(connId);
            if (testTime == null) {
                isRealTest = true;
                conn2TestRecordMap.put(connId, System.currentTimeMillis());
            } else {
                long internal = System.currentTimeMillis() - testTime;
                if (internal < 600000L) {
                    isRealTest = false;
                } else {
                    isRealTest = true;
                    conn2TestRecordMap.put(connId, System.currentTimeMillis());
                }
            }
        }
        if (!isTestConnection || isTestConnection && isRealTest) {
            int oldTimeout = this.getQueryTimeout();
            try {
                this.startQueryTimer(oldTimeout, ExecuteType.execute);
                if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                    rtnVal = this.getStmtByNativeDataSource().execute(sql);
                    this.cn.getConnectionByNativeDataSource().commit();
                } else {
                    rtnVal = this.stmt.execute(sql);
                }
                this.stopQueryTimer(true, true, oldTimeout);
            }
            catch (SQLException ex) {
                this.logSQLException(logItem, ex, sql, ksql);
                throw ex;
            }
            finally {
                if (logItem != null) {
                    this.endLog(logItem, startTime, ksql, this.stmt.getUpdateCount(), sql);
                }
                this.stopQueryTimer(false, false, oldTimeout);
            }
        } else {
            rtnVal = true;
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    protected boolean isTestQuery(String sql) {
        return "SELECT 1 FROM DUAL".equals(sql) || "SELECT 1 FROM SYSIBM.SYSDUMMY1".equals(sql) || "SELECT 1".equals(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeBatch", startTime, -1L, null, null, 0L);
        int[] rtnVal = null;
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeBatch);
            rtnVal = new int[this.batchSqls.size()];
            for (int i = 0; i < this.batchSqls.size(); ++i) {
                String sql = this.batchSqls.get(i);
                if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                    rtnVal[i] = this.getStmtByNativeDataSource().executeUpdate(sql);
                    this.cn.getConnectionByNativeDataSource().commit();
                    continue;
                }
                if (sql.startsWith("/*ignore*/")) {
                    rtnVal[i] = 1;
                    continue;
                }
                try {
                    rtnVal[i] = this.stmt.executeUpdate(sql);
                    continue;
                }
                catch (cn.com.vastbase.util.PSQLException e) {
                    if (this.dbType == 16 && cn.com.vastbase.util.PSQLState.TOO_MANY_RESULTS.getState().equals(e.getSQLState()) && this.batchSqlFormatContext.get(i).getProperty("sqlStmt") instanceof SqlExecStmt) continue;
                    throw e;
                }
                catch (org.gbase.util.PSQLException e) {
                    if (this.dbType == 18 && PSQLState.TOO_MANY_RESULTS.getState().equals(e.getSQLState()) && this.batchSqlFormatContext.get(i).getProperty("sqlStmt") instanceof SqlExecStmt) continue;
                    throw e;
                }
                catch (PSQLException e) {
                    if (this.dbType == 14 && com.huawei.opengauss.jdbc.util.PSQLState.TOO_MANY_RESULTS.getState().equals(e.getSQLState()) && this.batchSqlFormatContext.get(i).getProperty("sqlStmt") instanceof SqlExecStmt) continue;
                    throw e;
                }
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            if (ConnectionLogger.isValid() && logItem != null) {
                logItem.errorMessage = ex.getMessage();
            }
            throw ex;
        }
        finally {
            this.batchSqls.clear();
            int updateCount = 0;
            if (logItem != null) {
                if (rtnVal != null) {
                    for (int i = 0; i < rtnVal.length; ++i) {
                        updateCount += rtnVal[i];
                    }
                }
                this.endLog(logItem, startTime, null, updateCount, "execute batch.");
            }
            this.stopQueryTimer(false, false, oldTimeout);
        }
        return rtnVal;
    }

    @Override
    public ResultSet executeQuery(String ksql) throws SQLException {
        KDResultSet rtnVal;
        this.checkInterrupt();
        if (ksql == null) {
            throw new IllegalArgumentException("sql is null");
        }
        if (ksql.startsWith("/*ksql_internal*/")) {
            return InternalDataProcessor.executeQuery(this.cn, ksql);
        }
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeQuery", startTime, transTime, ksql, sql, sql.length());
        boolean isTestConnection = false;
        boolean isRealTest = false;
        if ("SELECT 1 FROM DUAL".equals(sql) || "SELECT 1 FROM SYSIBM.SYSDUMMY1".equals(sql) || "SELECT 1".equals(sql)) {
            isTestConnection = true;
            Integer connId = this.conn_id;
            Long testTime = conn2TestRecordMap.get(connId);
            if (testTime == null) {
                isRealTest = true;
                conn2TestRecordMap.put(connId, System.currentTimeMillis());
            } else {
                long internal = System.currentTimeMillis() - testTime;
                if (internal < 600000L) {
                    isRealTest = false;
                } else {
                    isRealTest = true;
                    conn2TestRecordMap.put(connId, System.currentTimeMillis());
                }
            }
        }
        if (!isTestConnection || isTestConnection && isRealTest) {
            int oldTimeout = this.getQueryTimeout();
            try {
                this.startQueryTimer(oldTimeout, ExecuteType.executeQuery);
                ResultSet rs = this.stmt.executeQuery(sql);
                rtnVal = rs != null ? new KDResultSet(rs, this) : null;
                this.stopQueryTimer(true, true, oldTimeout);
            }
            catch (SQLException ex) {
                this.logSQLException(logItem, ex, sql, ksql);
                throw ex;
            }
            finally {
                this.endLog(logItem, startTime, ksql, 0, sql);
                this.stopQueryTimer(false, false, oldTimeout);
            }
        } else {
            String[] strVec = new String[]{""};
            int[] intVec = new int[]{12};
            InternalDataResultSet internal = new InternalDataResultSet(strVec, intVec);
            rtnVal = new KDResultSet(internal, this);
        }
        List columnRealNames = (List)formaterContext.getContextProperty("realColumnNames");
        if (rtnVal != null && columnRealNames != null) {
            rtnVal.setRealColumns(columnRealNames);
        }
        return rtnVal;
    }

    protected void activateConnectionTrace(String sql) throws SQLException {
        ConnectionInfo connInfo;
        Map activateConnInfoMap = KSqlMonitor.getActivateConnectionMap();
        if (activateConnInfoMap != null && (connInfo = (ConnectionInfo)activateConnInfoMap.get(this.getConnection())) != null) {
            connInfo.lastStmtInfo = new StatementInfo(sql);
        }
    }

    @Override
    public int executeUpdate(String ksql) throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return 1;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeUpdate", startTime, transTime, ksql, sql, sql.length());
        int rtnVal = 0;
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().executeUpdate(sql);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.executeUpdate(sql);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, ksql, rtnVal, sql);
            }
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.cn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.stmt.getResultSet();
        if (rs == null) {
            return null;
        }
        KDResultSet ret = new KDResultSet(rs, this);
        ret.setRealColumns(this.realColumns);
        return ret;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean p) throws SQLException {
        this.stmt.setEscapeProcessing(p);
    }

    @Override
    public void setFetchDirection(int p) throws SQLException {
        this.stmt.setFetchDirection(p);
    }

    @Override
    public void setFetchSize(int p) throws SQLException {
        if (p < 1000) {
            p = 1000;
        }
        if (p > 20000) {
            p = 20000;
        }
        this.stmt.setFetchSize(p);
    }

    @Override
    public void setMaxFieldSize(int p) throws SQLException {
        this.stmt.setMaxFieldSize(p);
    }

    @Override
    public void setMaxRows(int p1) throws SQLException {
        this.stmt.setMaxRows(p1);
    }

    @Override
    public void setQueryTimeout(int p1) throws SQLException {
        this.stmt.setQueryTimeout(p1);
    }

    @Override
    public boolean execute(String ksql, int autoGeneratedKeys) throws SQLException {
        boolean rtnVal;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return true;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.execute", startTime, transTime, ksql, sql, sql.length());
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().execute(sql, autoGeneratedKeys);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.execute(sql, autoGeneratedKeys);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, ksql, this.stmt.getUpdateCount(), sql);
            }
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public boolean execute(String ksql, int[] columnIndexes) throws SQLException {
        boolean rtnVal;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return true;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.execute", startTime, transTime, ksql, sql, sql.length());
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.execute);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().execute(sql, columnIndexes);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.execute(sql, columnIndexes);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, ksql, this.stmt.getUpdateCount(), sql);
            }
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public boolean execute(String ksql, String[] columnNames) throws SQLException {
        boolean rtnVal;
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return true;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.execute", startTime, transTime, ksql, sql, sql.length());
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.execute);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().execute(sql, columnNames);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.execute(sql, columnNames);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            if (logItem != null) {
                this.endLog(logItem, startTime, ksql, this.stmt.getUpdateCount(), sql);
            }
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public int executeUpdate(String ksql, int autoGeneratedKeys) throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return 1;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeUpdate", startTime, transTime, ksql, sql, sql.length());
        int rtnVal = 0;
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().executeUpdate(sql, autoGeneratedKeys);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, ksql, rtnVal, sql);
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public int executeUpdate(String ksql, int[] columnIndexes) throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return 1;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeUpdate", startTime, transTime, ksql, sql, sql.length());
        int rtnVal = 0;
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().executeUpdate(sql, columnIndexes);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.executeUpdate(sql, columnIndexes);
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, ksql, rtnVal, sql);
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public int executeUpdate(String ksql, String[] columnNames) throws SQLException {
        this.checkInterrupt();
        long startTime = System.currentTimeMillis();
        FormaterContext formaterContext = this.getFormaterContext();
        String sql = this.getSql(ksql, formaterContext);
        if (sql.startsWith("/*ignore*/")) {
            return 1;
        }
        this.setRealColumnNames((List)formaterContext.getContextProperty("realColumnNames"));
        sql = VTUtil.decorate(sql, this.dbType);
        long transTime = System.currentTimeMillis();
        LogItem logItem = this.beginLog("Statement.executeUpdate", startTime, transTime, ksql, sql, sql.length());
        int rtnVal = 0;
        int oldTimeout = this.getQueryTimeout();
        try {
            this.startQueryTimer(oldTimeout, ExecuteType.executeUpdate);
            if (VTUtil.needNewTransaction(this.cn, this.dbType, sql)) {
                rtnVal = this.getStmtByNativeDataSource().executeUpdate(sql, columnNames);
                this.cn.getConnectionByNativeDataSource().commit();
            } else {
                rtnVal = this.stmt.executeUpdate(sql, columnNames);
            }
            if (ConnectionLogger.isValid() && logItem != null) {
                logItem.updateCount = rtnVal;
            }
            this.stopQueryTimer(true, true, oldTimeout);
        }
        catch (SQLException ex) {
            this.logSQLException(logItem, ex, sql, ksql);
            throw ex;
        }
        finally {
            this.endLog(logItem, startTime, ksql, rtnVal, sql);
            this.stopQueryTimer(false, false, oldTimeout);
        }
        DtsSqlHandle.parse(ksql, new Object[0]);
        return rtnVal;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        if (this.stmt != null) {
            return this.stmt.unwrap(iface);
        }
        throw new SQLException("Wrapped statement is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return true;
        }
        return this.stmt.isWrapperFor(iface);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stmt.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public void setRealColumnNames(List<String> realColumns) {
        this.realColumns = realColumns;
    }

    public void startQueryTimer(int timeout, ExecuteType executeType) throws SQLException {
        CancelTimeroutTask timerTask;
        if (timeout > 0 && (timerTask = TimeoutTaskFactory.getCancelTimeTask(this.cn, executeType)) != null && timerTask.getCancelId() > 0L) {
            CANCEL_TIMER_UPDATER.set(this, timerTask);
            if (TimeoutConfig.getTimerType() == TimerType.scheduled) {
                this.endOfLife = TimerExecutorService.addTimerTask(timerTask, timeout);
            } else if (TimeoutConfig.getTimerType() == TimerType.timer) {
                SharedTimer.addTimerTask(timerTask, timeout);
            } else {
                KsqlCancelService.addTimerTask(timerTask, timeout);
            }
            this.stmt.setQueryTimeout(0);
        }
    }

    public void stopQueryTimer(boolean rethrowCancelReason, boolean checkCancelTimeout, int timeout) throws SQLException {
        CancelTimeroutTask timeroutTask = CANCEL_TIMER_UPDATER.get(this);
        if (timeroutTask != null && CANCEL_TIMER_UPDATER.compareAndSet(this, timeroutTask, null)) {
            if (rethrowCancelReason) {
                timeroutTask.rethrowCancelReason();
            }
            if (checkCancelTimeout) {
                timeroutTask.checkCancelTimeout();
            }
            if (TimeoutConfig.getTimerType() == TimerType.scheduled) {
                TimerExecutorService.purgeTimerTasks(timeroutTask, this.endOfLife);
                this.endOfLife = null;
            } else if (TimeoutConfig.getTimerType() == TimerType.timer) {
                SharedTimer.purgeTimerTasks(timeroutTask);
            } else {
                KsqlCancelService.purgeTimerTasks(timeroutTask);
            }
            this.stmt.setQueryTimeout(timeout);
        }
    }
}

