/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.nologging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoLoggingConfig {
    private static final Logger log = LoggerFactory.getLogger(NoLoggingConfig.class);
    public static final String key_enable = "enable";
    private static boolean nologging_append_enable = true;
    private static Properties properties = new Properties();

    private static void init() {
        NoLoggingConfig.initProperties();
        NoLoggingConfig.loadFromFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveToFile() {
        String propFile = NoLoggingConfig.getPropFile();
        try (FileOutputStream fos = new FileOutputStream(propFile);){
            String comments = "Generated by jsp, Date: " + new Date();
            properties.store(fos, comments);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getPropFile() {
        String deploy = ConfigurationUtil.getString((String)"eas.deploy");
        String propFile = deploy + "/nologgingconfig.properties";
        return propFile;
    }

    public static boolean existsPropFile() {
        String propFile = NoLoggingConfig.getPropFile();
        File f = new File(propFile);
        return f.exists();
    }

    public static boolean loadFromFile() {
        Properties props = new Properties();
        File file = new File(NoLoggingConfig.getPropFile());
        boolean b = false;
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                props.load(fis);
                b = true;
            }
            catch (Exception t) {
                log.warn(t.getMessage(), (Throwable)t);
                return false;
            }
            properties.putAll((Map<?, ?>)props);
            String v = props.getProperty(key_enable);
            if ("false".equals(v)) {
                nologging_append_enable = false;
            } else if ("true".equals(v)) {
                nologging_append_enable = true;
            }
            return true;
        }
        return false;
    }

    private static void initProperties() {
        properties.setProperty(key_enable, nologging_append_enable ? "true" : "false");
    }

    public static boolean enableNoLoggingAppend() {
        return nologging_append_enable;
    }

    public static void setEnableNoLoggingAppend() {
        nologging_append_enable = true;
        properties.setProperty(key_enable, "true");
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        return props;
    }

    public static void setProperties(Properties props) {
        properties.putAll((Map<?, ?>)props);
        String v = props.getProperty(key_enable);
        if ("false".equals(v)) {
            nologging_append_enable = false;
        } else if ("true".equals(v)) {
            nologging_append_enable = true;
        }
    }

    static {
        NoLoggingConfig.init();
    }
}

