/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ksql.shell.timeout.TimeoutConfig;
import kd.bos.ksql.shell.timeout.TimeoutExecutor;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;

public class CancelTaskManager {
    private static final CancelTaskManager INSTANCE = new CancelTaskManager();
    private final Map<Long, Set<CancelTimeroutTask>> threadCancelTimeoutMap = new HashMap<Long, Set<CancelTimeroutTask>>();

    public static CancelTaskManager get() {
        return INSTANCE;
    }

    public synchronized void addCancelTimeout(CancelTimeroutTask cancelTimeroutTask) {
        Long threadId = Thread.currentThread().getId();
        Set<CancelTimeroutTask> set = this.threadCancelTimeoutMap.get(threadId);
        if (set == null) {
            set = new HashSet<CancelTimeroutTask>(1);
            this.threadCancelTimeoutMap.put(threadId, set);
        }
        set.add(cancelTimeroutTask);
    }

    public synchronized void removeCancelTimeout(CancelTimeroutTask cancelTimeroutTask) {
        Long threadId = Thread.currentThread().getId();
        Set<CancelTimeroutTask> set = this.threadCancelTimeoutMap.get(threadId);
        if (set != null) {
            set.remove(cancelTimeroutTask);
            if (set.isEmpty()) {
                this.threadCancelTimeoutMap.remove(threadId);
            }
        }
    }

    public synchronized void killQueryCancelTask(long threadId, String traceId) {
        Set<CancelTimeroutTask> set = this.threadCancelTimeoutMap.get(threadId);
        if (set != null) {
            set.forEach(item -> {
                if (item.getExecuteType() == ExecuteType.executeQuery && item.getTraceId().equalsIgnoreCase(traceId)) {
                    TimeoutExecutor.submit(item);
                }
            });
        }
    }

    public synchronized void killCancelTask(long threadId, String traceId) {
        Set<CancelTimeroutTask> set = this.threadCancelTimeoutMap.get(threadId);
        if (set != null) {
            set.forEach(item -> {
                if (item.getTraceId().equalsIgnoreCase(traceId)) {
                    TimeoutExecutor.submit(item);
                }
            });
        }
    }

    public List<Integer> getSupportedDbTypes() {
        if (!TimeoutConfig.isEnable()) {
            return Collections.EMPTY_LIST;
        }
        Integer[] res = new Integer[]{6, 5};
        return Arrays.asList(res);
    }
}

