/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;

public final class DataSourceUtils {
    private static Method dataSourceFactory_getDataSource;
    private static Method dataSourceInfo_getDataSource;
    private static Method dataSourceInfo_getNewConnection;

    private DataSourceUtils() {
    }

    public static Connection getDataSourceConnection(String routeKey) {
        try {
            RequestContextInfo requestContextInfo = RequestContextInfo.get();
            Object dataSourceFactory = dataSourceFactory_getDataSource.invoke(null, requestContextInfo.getTenantId(), routeKey, requestContextInfo.getAccountId(), false);
            DataSource datasource = (DataSource)dataSourceInfo_getDataSource.invoke(dataSourceFactory, new Object[0]);
            return datasource.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Connection getDataSourceNewConnection(String routeKey) {
        try {
            RequestContextInfo requestContextInfo = RequestContextInfo.get();
            Object dataSourceFactory = dataSourceFactory_getDataSource.invoke(null, requestContextInfo.getTenantId(), routeKey, requestContextInfo.getAccountId(), false);
            return (Connection)dataSourceInfo_getNewConnection.invoke(dataSourceFactory, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            dataSourceFactory_getDataSource = Class.forName("kd.bos.db.datasource.DataSourceFactory").getDeclaredMethod("getDataSource", String.class, String.class, String.class, Boolean.TYPE);
            dataSourceInfo_getDataSource = Class.forName("kd.bos.db.datasource.DataSourceInfo").getDeclaredMethod("getDataSource", new Class[0]);
            dataSourceInfo_getNewConnection = Class.forName("kd.bos.db.datasource.DataSourceInfo").getDeclaredMethod("getNewConnection", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

