/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.context.RequestContextWrap;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.thread.ThreadTruck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDataReporterUtils {
    private static final Logger log = LoggerFactory.getLogger(EventDataReporterUtils.class);
    private static Method eventDataReporter_report;
    private static Constructor<?> sqlAutoTimeoutEvent_constructor;
    private static ExecutorService es;

    public static void eventDataReport(CancelTimeroutTask timeoutTask) {
        es.submit(new RequestContextWrap(timeoutTask, () -> EventDataReporterUtils.doEventDataReport(timeoutTask)));
    }

    private static void doEventDataReport(CancelTimeroutTask timeoutTask) {
        try {
            String message = String.format("CancelTimeOutTask execute,tenantId:%s,accountId:%s,traceId:%s", timeoutTask.getTenantId(), timeoutTask.getAccountId(), timeoutTask.getTraceId());
            if (log.isInfoEnabled()) {
                log.info(message);
            }
            Object eventTypeInstance = sqlAutoTimeoutEvent_constructor.newInstance(new Object[0]);
            RequestContextInfo rc = RequestContextInfo.get();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantId", rc.getTenantId());
            map.put("traceId", rc.getTraceId());
            map.put("accountId", rc.getAccountId());
            ThreadTruck.put((Object)"rcinfo", map);
            eventDataReporter_report.invoke(null, eventTypeInstance, message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        es = Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicInteger seq = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "pool-EventData-Reporter-thread-" + this.seq.getAndIncrement());
            }
        });
        try {
            eventDataReporter_report = Class.forName("kd.bos.govern.eventdata.reporter.EventDataReporter").getDeclaredMethod("report", Class.forName("kd.bos.govern.eventdata.EventType"), String.class);
            sqlAutoTimeoutEvent_constructor = Class.forName("kd.bos.govern.eventdata.types.TerminationEvent$SqlAutoTimeoutEvent").getDeclaredConstructor(new Class[0]);
            if (!sqlAutoTimeoutEvent_constructor.isAccessible()) {
                sqlAutoTimeoutEvent_constructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

