/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timer;

import java.util.Comparator;
import java.util.PriorityQueue;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;

public class KsqlCancelTimer
extends Thread {
    private volatile PriorityQueue<CancelTimeroutTask> taskQueue = new PriorityQueue<CancelTimeroutTask>(Comparator.comparing(cancelTask -> cancelTask.getNextExecutionTime()));

    public KsqlCancelTimer(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(CancelTimeroutTask cancelTask, long seconds) {
        PriorityQueue<CancelTimeroutTask> priorityQueue = this.taskQueue;
        synchronized (priorityQueue) {
            cancelTask.setNextExecutionTime(System.currentTimeMillis() + seconds * 1000L);
            this.taskQueue.add(cancelTask);
            if (this.taskQueue.peek() == cancelTask) {
                this.taskQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(CancelTimeroutTask cancelTask) {
        PriorityQueue<CancelTimeroutTask> priorityQueue = this.taskQueue;
        synchronized (priorityQueue) {
            this.taskQueue.remove(cancelTask);
            cancelTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    PriorityQueue<CancelTimeroutTask> priorityQueue = this.taskQueue;
                    synchronized (priorityQueue) {
                        if (this.taskQueue.isEmpty()) {
                            this.taskQueue.wait(10000L);
                            continue;
                        }
                        CancelTimeroutTask cancelTask = this.taskQueue.peek();
                        if (cancelTask != null) {
                            if (cancelTask.isCanceled()) {
                                this.taskQueue.remove(cancelTask);
                                continue;
                            }
                            long timeLeast = cancelTask.getNextExecutionTime() - System.currentTimeMillis();
                            if (timeLeast > 0L) {
                                this.taskQueue.wait(timeLeast);
                            } else {
                                cancelTask.run();
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

