/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timetask;

import com.mysql.cj.exceptions.CJTimeoutException;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlCancelTimeroutTaskImpl
extends CancelTimeroutTask {
    private static final Logger log = LoggerFactory.getLogger(MysqlCancelTimeroutTaskImpl.class);
    private static final String KILL_QUERY = "/*dialect*/KILL QUERY %s";

    public MysqlCancelTimeroutTaskImpl(KDConnection kdConnection, ExecuteType executeType) {
        super(kdConnection, executeType);
        try {
            this.cancelId = kdConnection.getNativeConnection().unwrap(ConnectionImpl.class).getSession().getThreadId();
        }
        catch (SQLException e) {
            log.error("MysqlCancelTimeroutTaskImpl init error.", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void cancelExecute(Statement statement) throws SQLException {
        this.executed = statement.execute(this.getKillSql());
    }

    @Override
    public void checkCancelTimeout() throws SQLTimeoutException {
        if (this.executed) {
            CJTimeoutException cause = new CJTimeoutException();
            throw new MySQLTimeoutException(cause.getMessage());
        }
    }

    @Override
    public String getKillSql() {
        return String.format(KILL_QUERY, this.cancelId);
    }
}

