/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.trace;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.ksql.shell.trace.ConnectionInfo;
import kd.bos.ksql.shell.trace.StatementInfo;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.shell.trace.server.TraceServer;
import kd.bos.util.DisCardUtil;

public class KSqlMonitor {
    private static final Map activateConnInfoMap = new HashMap();
    private static final Map traceInfoList = new HashMap();
    private static final Map traceServerMap = new HashMap();

    public static final Map getActivateConnectionMap() {
        return activateConnInfoMap;
    }

    static TraceServer createAndtartTraceServer(int port) throws IOException {
        TraceServer srv = null;
        srv = new TraceServer(port);
        Thread t = new Thread(srv);
        t.start();
        t.setName("KSQL Trace Server : " + port);
        return srv;
    }

    public static TraceServer getTraceServer(int port) {
        if (port < 0) {
            return null;
        }
        Integer key = port;
        TraceServer srv = (TraceServer)traceServerMap.get(key);
        if (srv == null) {
            srv = KSqlMonitor.getTraceServerInternal(port);
        }
        return srv;
    }

    private static TraceServer getTraceServerInternal(int port) {
        Integer key = port;
        TraceServer srv = (TraceServer)traceServerMap.get(key);
        if (srv == null) {
            try {
                srv = KSqlMonitor.createAndtartTraceServer(port);
                traceServerMap.put(key, srv);
            }
            catch (IOException ex) {
                DisCardUtil.discard();
            }
        }
        return srv;
    }

    public static void putTraceInfo(String url, TraceInfo traceInfo) {
        traceInfoList.put(url, traceInfo);
    }

    public static TraceInfo getTraceInfo(String url) {
        return (TraceInfo)traceInfoList.get(url);
    }

    public static Iterator driverIterator() {
        return traceInfoList.entrySet().iterator();
    }

    public static Map getTraceInfoMap() {
        return traceInfoList;
    }

    public static void getActivateConnectionInfoReport(StringBuilder buff) {
        int connIndex = 0;
        buff.append("activate connection size : ").append(activateConnInfoMap.size());
        buff.append("\n");
        buff.append("--------------------------------");
        buff.append("\n");
        Iterator iter = activateConnInfoMap.values().iterator();
        while (iter.hasNext()) {
            int i;
            StackTraceElement[] elementArray;
            buff.append(connIndex++);
            buff.append("\n--------\n");
            ConnectionInfo connInfo = (ConnectionInfo)iter.next();
            Timestamp time = new Timestamp(connInfo.createdTime);
            buff.append("created time : ").append(time.toString());
            buff.append(", conn_timespan : ").append(System.currentTimeMillis() - connInfo.createdTime);
            buff.append("\n");
            StatementInfo stmtInfo = connInfo.lastStmtInfo;
            if (stmtInfo != null) {
                buff.append("last statement time : ").append(new Timestamp(stmtInfo.createdTime));
                buff.append(", lastStmt_timespan : ").append(System.currentTimeMillis() - stmtInfo.createdTime);
                buff.append("\n");
                buff.append("last statement sql : \n----\n");
                buff.append(stmtInfo.sql);
                buff.append("\n----\n");
                buff.append("stmt stackTrace : \n");
                if (stmtInfo.stackTrace instanceof StackTraceElement[]) {
                    elementArray = (StackTraceElement[])stmtInfo.stackTrace;
                    for (i = 0; i < elementArray.length; ++i) {
                        buff.append(elementArray[i].toString());
                        buff.append("\n");
                    }
                } else if (stmtInfo.stackTrace == null) {
                    buff.append("connection not close, but stackTrace is null");
                } else {
                    buff.append(stmtInfo.stackTrace.toString());
                }
                buff.append("\n----\n");
            }
            buff.append("connection stackTrace : \n");
            if (connInfo.stackTrace instanceof StackTraceElement[]) {
                elementArray = (StackTraceElement[])connInfo.stackTrace;
                for (i = 0; i < elementArray.length; ++i) {
                    buff.append(elementArray[i].toString());
                    buff.append("\n");
                }
            } else if (connInfo.stackTrace == null) {
                buff.append("connection not close, but stackTrace is null");
            } else {
                buff.append(connInfo.stackTrace.toString());
            }
            buff.append("\n");
            buff.append("--------------------------------");
            buff.append("\n\n\n");
        }
    }

    public static String getActivateConnectionInfoReport() {
        StringBuilder buff = new StringBuilder();
        KSqlMonitor.getActivateConnectionInfoReport(buff);
        return buff.toString();
    }
}

