/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.security.SecureRandom;
import java.util.UUID;
import kd.bos.ksql.util.UUTNException;
import kd.bos.ksql.util.UUTNSource;
import org.apache.log4j.Logger;

public class UUTN {
    public static final String GLOBAL_TEMPORARY_TABLE_PREFIX = "GZT";
    public static final String TABLE_PREFIX = "VT";
    public static final String SEQUENCE_PREFIX = "ZS";
    public static final String CONSTRAINT_PREFIX = "ZC";
    public static final String TRIGGER_PREFIX = "ZR";
    private static final Logger logger = Logger.getLogger(UUTN.class);
    public final String valueAfterMD5;
    private static SecureRandom mySecureRand = new SecureRandom();
    public static final String S_ID = UUTN.normalize(UUTNSource.getUniqueSource().hashCode());
    public final String prefix;

    public UUTN() {
        this.prefix = TABLE_PREFIX;
        this.valueAfterMD5 = this.getRandomGUID();
    }

    public UUTN(String prefix) {
        this.prefix = prefix;
        this.valueAfterMD5 = this.getRandomGUID();
    }

    public UUTN(boolean isFULL) {
        this.prefix = TABLE_PREFIX;
        this.valueAfterMD5 = this.getRandomGUID(isFULL);
    }

    public UUTN(boolean isFULL, String prefix) {
        this.prefix = prefix;
        this.valueAfterMD5 = this.getRandomGUID(isFULL);
    }

    private String getRandomGUID() throws UUTNException {
        return UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }

    private String getRandomGUID(boolean isFULL) throws UUTNException {
        return this.getRandomGUID();
    }

    public static boolean isTempTable(String tablename) {
        return tablename != null && tablename.startsWith(TABLE_PREFIX);
    }

    public static boolean isGlobalTempTable(String tablename) {
        return tablename != null && tablename.startsWith(GLOBAL_TEMPORARY_TABLE_PREFIX);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        String temp = S_ID + this.valueAfterMD5;
        if (this.prefix.equalsIgnoreCase(CONSTRAINT_PREFIX)) {
            sb.append(temp.substring(temp.length() - 16));
        } else {
            sb.append(S_ID);
            sb.append(this.valueAfterMD5);
        }
        return sb.toString();
    }

    private static final String normalize(long l) {
        return Long.toString(l, 35).toUpperCase().replaceAll("-", "Z");
    }
}

