/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.visitor.ASTVisitorBase;
import kd.bos.ksql.visitor.TreeNode;

public class DMAggregateVisitor
extends ASTVisitorBase<TreeNode> {
    @Override
    public TreeNode visitSqlSelect(SqlSelect stmt) {
        List selectList = stmt.selectList;
        TableSourceVisitor tableSourceVisitor = new TableSourceVisitor();
        SqlTableSourceBase tableSource = stmt.tableSource;
        if (tableSource != null) {
            tableSourceVisitor.visit(tableSource);
        }
        if (!tableSourceVisitor.containSubQuery()) {
            return (TreeNode)super.visitSqlSelect(stmt);
        }
        for (SqlSelectItem selectItem : selectList) {
            String methodName;
            SqlExpr expr = selectItem.expr;
            if (!(expr instanceof SqlAggregateExpr) || !"sum".equals(methodName = ((SqlAggregateExpr)expr).methodName.toLowerCase(Locale.ENGLISH)) && !"avg".equals(methodName) && !"count".equals(methodName) || !(stmt.tableSource instanceof SqlSubQueryTableSource)) continue;
            ArrayList<String> alias = new ArrayList<String>();
            List paramList = ((SqlAggregateExpr)expr).paramList;
            SqlSelectBase ssb = ((SqlSubQueryTableSource)stmt.tableSource).subQuery;
            List<SqlSelectItem> subSelectList = this.findSelectList(ssb);
            for (SqlSelectItem item : subSelectList) {
                alias.add(item.alias);
            }
            ColumnAliasVisitor columnAliasVisitor = new ColumnAliasVisitor(tableSourceVisitor.tableAliasMap, alias);
            if (paramList.isEmpty()) continue;
            for (TreeNode param : paramList) {
                columnAliasVisitor.visit(param);
            }
        }
        return null;
    }

    private List<SqlSelectItem> findSelectList(SqlSelectBase sqlSelectBase) {
        if (sqlSelectBase instanceof SqlSelect) {
            return ((SqlSelect)sqlSelectBase).selectList;
        }
        if (sqlSelectBase instanceof SqlUnionSelect) {
            return this.findSelectList(((SqlUnionSelect)sqlSelectBase).left);
        }
        return Collections.emptyList();
    }

    static class TableSourceVisitor
    extends ASTVisitorBase<Object> {
        private Map<String, SqlTableSourceBase> tableAliasMap = new HashMap<String, SqlTableSourceBase>();
        private Set<SqlTableSourceBase> tables = new HashSet<SqlTableSourceBase>();

        TableSourceVisitor() {
        }

        public boolean containSubQuery() {
            for (SqlTableSourceBase table : this.tables) {
                if (!(table instanceof SqlSubQueryTableSource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object visitSqlTableSource(SqlTableSource stmt) {
            if (stmt.alias != null) {
                this.tableAliasMap.put(stmt.alias, stmt);
            }
            this.tables.add(stmt);
            return null;
        }

        @Override
        public Object visitSqlSubQueryTableSource(SqlSubQueryTableSource stmt) {
            if (stmt.alias != null) {
                this.tableAliasMap.put(stmt.alias, stmt);
            }
            this.tables.add(stmt);
            return null;
        }
    }

    static class ColumnAliasVisitor
    extends ASTVisitorBase<Object> {
        private Map<String, SqlTableSourceBase> tableAliasMap = new HashMap<String, SqlTableSourceBase>();
        private List<String> subQueryColumnAlias = new ArrayList<String>();

        public ColumnAliasVisitor(Map<String, SqlTableSourceBase> tableAliasMap, List<String> subQueryColumnAlias) {
            this.tableAliasMap = tableAliasMap;
            this.subQueryColumnAlias = subQueryColumnAlias;
        }

        @Override
        public Object visitSqlIdentifierExpr(SqlIdentifierExpr expr) {
            String orgValue = "\"" + expr.getOrgValue() + "\"";
            if (this.subQueryColumnAlias.contains(orgValue)) {
                expr.setOrgValue(orgValue);
                expr.setValue(orgValue);
            }
            return null;
        }

        @Override
        public Object visitSqlBinaryOpExpr(SqlBinaryOpExpr expr) {
            String tableName = expr.left.getOrgValue();
            SqlTableSourceBase sqlTableSourceBase = this.tableAliasMap.get(tableName);
            if (sqlTableSourceBase instanceof SqlSubQueryTableSource) {
                return this.visit(expr.right);
            }
            return null;
        }
    }
}

