/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.visitor;

import java.util.Locale;
import kd.bos.ksql.dom.SqlDelete;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlCommentStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlDropIndexStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlTrancateTableStmt;
import kd.bos.ksql.util.StringUtil;
import kd.bos.ksql.visitor.ASTVisitorBase;
import kd.bos.ksql.visitor.TreeNode;

public class SharedConnectionVisitor
extends ASTVisitorBase<TreeNode> {
    private final String schema;

    public SharedConnectionVisitor(String schema) {
        if (StringUtil.isEmpty(schema)) {
            throw new IllegalArgumentException("schema cannot be empty");
        }
        this.schema = schema;
    }

    @Override
    public TreeNode visitSqlTableSource(SqlTableSource stmt) {
        String tableName = stmt.name;
        if (!tableName.toUpperCase(Locale.ROOT).startsWith("KSQL_")) {
            stmt.name = this.schema + "." + tableName;
        }
        return (TreeNode)super.visitSqlTableSource(stmt);
    }

    @Override
    public TreeNode visitSqlCreateTableStmt(SqlCreateTableStmt stmt) {
        stmt.name = this.schema + "." + stmt.name;
        return (TreeNode)super.visitSqlCreateTableStmt(stmt);
    }

    @Override
    public TreeNode visitSqlAlterTableStmt(SqlAlterTableStmt stmt) {
        stmt.tableName = this.schema + "." + stmt.tableName;
        return (TreeNode)super.visitSqlAlterTableStmt(stmt);
    }

    @Override
    public TreeNode visitSqlDropTableStmt(SqlDropTableStmt stmt) {
        stmt.tableName = this.schema + "." + stmt.tableName;
        return (TreeNode)super.visitSqlDropTableStmt(stmt);
    }

    @Override
    public TreeNode visitSqlInsert(SqlInsert stmt) {
        stmt.tableName = this.schema + "." + stmt.tableName;
        return (TreeNode)super.visitSqlInsert(stmt);
    }

    @Override
    public TreeNode visitSqlDelete(SqlDelete stmt) {
        if (stmt.tableName != null) {
            stmt.tableName = this.schema + "." + stmt.tableName;
        }
        return (TreeNode)super.visitSqlDelete(stmt);
    }

    @Override
    public TreeNode visitSqlTrancateTableStmt(SqlTrancateTableStmt stmt) {
        stmt.tableName = this.schema + "." + stmt.tableName;
        return (TreeNode)super.visitSqlTrancateTableStmt(stmt);
    }

    @Override
    public TreeNode visitSqlExecStmt(SqlExecStmt stmt) {
        stmt.processName = this.schema + "." + stmt.processName;
        return (TreeNode)super.visitSqlExecStmt(stmt);
    }

    @Override
    public TreeNode visitSqlDropIndexStmt(SqlDropIndexStmt stmt) {
        String tableName = stmt.tableName;
        if (!StringUtil.isEmpty(tableName)) {
            stmt.tableName = this.schema + "." + tableName;
        }
        return (TreeNode)super.visitSqlDropIndexStmt(stmt);
    }

    @Override
    public TreeNode visitSqlCreateIndexStmt(SqlCreateIndexStmt stmt) {
        String tableName = stmt.tableName;
        if (!StringUtil.isEmpty(tableName)) {
            stmt.tableName = this.schema + "." + tableName;
        }
        return (TreeNode)super.visitSqlCreateIndexStmt(stmt);
    }

    @Override
    public TreeNode visitSqlCommentStmt(SqlCommentStmt stmt) {
        stmt.setSchema(this.schema);
        return (TreeNode)super.visitSqlCommentStmt(stmt);
    }
}

