/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice;

import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.MetricSystem;
import kd.bos.mservice.fullgc.FullGcManage;
import kd.bos.mservice.monitor.healthmanage.node.NodeHealth;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.util.ExceptionUtils;

public class HealthService
implements Service {
    private volatile boolean isStartedFlag = false;
    private static Log logger = LogFactory.getLog(HealthService.class);

    public String getName() {
        return "HealthService";
    }

    public boolean isStarted() {
        return this.isStartedFlag;
    }

    public void start() {
        NodeHealth.init();
        new Thread(() -> {
            FullGcManage full = new FullGcManage();
            try {
                full.listen();
            }
            catch (Exception e) {
                logger.error("start fullgcmanager error", (Throwable)e);
            }
        }, "full gc callback").start();
        this.isStartedFlag = true;
        logger.info("HealthService started ");
    }

    public void stop() {
        this.isStartedFlag = false;
        logger.info("HealthService stopped ");
    }

    static {
        try {
            String registerMetricKey = "kd.metrics.jvm.oomcount";
            MetricSystem.registerGauge((String)registerMetricKey, () -> OutOfMemoryObserver.getCount());
        }
        catch (Throwable e) {
            ExceptionUtils.parseException((Throwable)e);
        }
    }
}

