/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.fullgc;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.MetricSystem;
import kd.bos.mservice.fullgc.FullGcListener;
import kd.bos.mservice.fullgc.FullGcManage;
import kd.bos.mservice.fullgc.MemoryRecycle;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.util.ExceptionUtils;

public class FullGcRegisterMetricListener
implements FullGcListener {
    private static Log log = LogFactory.getLog(FullGcRegisterMetricListener.class);
    private static final String KEY_TIMEWINDOW = "fullgc.overload.timewindow.seconds";
    private static final String KEY_HEALTHGCTIME = "fullgc.overload.healthgctime.millis";
    private static final LimitQueue<MemoryRecycleItem> lqueue = new LimitQueue(100);

    private static synchronized int getOverLoadCount() {
        int count = 0;
        long timeWindow = Long.getLong(KEY_TIMEWINDOW, 180L) * 1000L;
        for (int size = lqueue.size() - 1; size >= 0; --size) {
            MemoryRecycleItem item = lqueue.get(size);
            if (item.timestamp + timeWindow <= System.currentTimeMillis()) break;
            ++count;
        }
        return count;
    }

    @Override
    public String name() {
        return "FullGcRegisterMetricListener";
    }

    @Override
    public void overloadAction(long l, MemoryRecycle summ) {
        int healthtime = Integer.getInteger(KEY_HEALTHGCTIME, 10000);
        if (l >= (long)healthtime) {
            MemoryRecycleItem item = new MemoryRecycleItem();
            item.timestamp = System.currentTimeMillis();
            item.dur = l;
            item.summ = summ;
            log.warn("fullgc:" + item);
            lqueue.offer(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverAction(long duration, MemoryRecycle summ) {
        Class<FullGcRegisterMetricListener> clazz = FullGcRegisterMetricListener.class;
        synchronized (FullGcRegisterMetricListener.class) {
            while (lqueue.size() > 0) {
                lqueue.poll();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    static {
        try {
            String registerMetricKey = "kd.metrics.jvm.fullgc.overload";
            MetricSystem.registerGauge((String)registerMetricKey, () -> {
                int overloadCount = FullGcRegisterMetricListener.getOverLoadCount();
                System.setProperty("jvm.fullgc.overloadCount", String.valueOf(overloadCount));
                FullGcManage.setFullGcOverloadCount(overloadCount);
                return overloadCount;
            });
        }
        catch (Throwable e) {
            ExceptionUtils.parseException((Throwable)e);
        }
    }

    static class MemoryRecycleItem {
        long timestamp;
        long dur;
        MemoryRecycle summ;

        MemoryRecycleItem() {
        }

        public String toString() {
            return "fullgc At " + this.timestamp + ",duration:" + this.dur + "ms. " + this.summ;
        }
    }
}

