/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.fullgc;

import com.sun.management.GcInfo;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MemoryRecycle {
    private String region;
    private long max;
    private long useBefore;
    private long after;

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getUseBefore() {
        return this.useBefore;
    }

    public void setUseBefore(long useBefore) {
        this.useBefore = useBefore;
    }

    public long getAfter() {
        return this.after;
    }

    public void setAfter(long after) {
        this.after = after;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String toString() {
        return String.format("name:%s  max:%sMB, %sMB -> %s MB  ; \r\n", this.region, this.max / 0x100000L, this.useBefore / 0x100000L, this.after / 0x100000L);
    }

    public static List<MemoryRecycle> parseRecycleInfo(GcInfo gc) {
        Map<String, MemoryUsage> before = gc.getMemoryUsageBeforeGc();
        Map<String, MemoryUsage> after = gc.getMemoryUsageAfterGc();
        ArrayList<MemoryRecycle> mrecycle = new ArrayList<MemoryRecycle>(2);
        before.forEach((k, v) -> {
            MemoryRecycle re = new MemoryRecycle();
            mrecycle.add(re);
            re.setRegion((String)k);
            re.setMax(v.getMax());
            re.setUseBefore(v.getUsed());
            re.setAfter(((MemoryUsage)after.get(k)).getUsed());
        });
        return mrecycle;
    }

    public static MemoryRecycle sum(List<MemoryRecycle> sourceLs, String keyPre) {
        MemoryRecycle mr = new MemoryRecycle();
        mr.setRegion("");
        sourceLs.forEach(v -> {
            if (keyPre == null || v.getRegion().startsWith(keyPre)) {
                mr.setRegion(mr.getRegion() + " & " + v.getRegion());
                mr.setMax(mr.max + v.max);
                mr.setUseBefore(mr.useBefore + v.useBefore);
                mr.setAfter(mr.after + v.after);
            }
        });
        return mr;
    }
}

