/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import kd.bos.mservice.memory.VMParams;
import kd.bos.util.ConfigurationUtil;
import org.apache.log4j.Logger;

public class DumpFileManage {
    private static Logger logger = Logger.getLogger(DumpFileManage.class);

    public static String getDumpPath() {
        try {
            String dumpPath = VMParams.getDumpPath();
            if (dumpPath == null) {
                return ConfigurationUtil.getString((String)"user.dir");
            }
            if (dumpPath.endsWith(".hprof") || dumpPath.endsWith(".bin")) {
                int id2;
                int indx;
                int id1 = dumpPath.lastIndexOf("/");
                int n = indx = id1 > (id2 = dumpPath.lastIndexOf("\\")) ? id1 : id2;
                if (indx > 0) {
                    return dumpPath.substring(0, indx);
                }
                return ConfigurationUtil.getString((String)"user.dir");
            }
            return dumpPath;
        }
        catch (Exception e) {
            logger.error((Object)"[quarantine] getDumpPath error ", (Throwable)e);
            return null;
        }
    }

    public static String getDumpFileIfExists(String path) {
        try {
            return DumpFileManage.getRecentHprofFiles(path);
        }
        catch (Exception e) {
            logger.error((Object)"[quarantine] hasRecentHprofFiles error", (Throwable)e);
            return null;
        }
    }

    private static String getRecentHprofFiles(String directoryPath) throws IOException {
        Path dir = Paths.get(directoryPath, new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return null;
        }
        Instant cutoffTime = Instant.now().minus(1L, ChronoUnit.MINUTES);
        StringBuilder sb = new StringBuilder();
        try (Stream<Path> fileStream = Files.walk(dir, new FileVisitOption[0]);){
            boolean hasRecentHprofFile = fileStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".hprof")).anyMatch(path -> {
                try {
                    FileTime fileTime;
                    try {
                        fileTime = (FileTime)Files.getAttribute(path, "creationTime", LinkOption.NOFOLLOW_LINKS);
                    }
                    catch (UnsupportedOperationException e) {
                        fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                    }
                    if (fileTime.toInstant().isAfter(cutoffTime)) {
                        sb.append(path);
                        return true;
                    }
                    return false;
                }
                catch (IOException ex) {
                    logger.error((Object)"[quarantine] getRecentHprofFiles error", (Throwable)ex);
                    return false;
                }
            });
            if (hasRecentHprofFile) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static boolean hasFinish(String fullPath) {
        Path path = Paths.get(fullPath, new String[0]);
        try {
            int second = Integer.getInteger("dumpfile.finish.afterSecondsNotChanged", 30);
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(Instant.now().minus(second, ChronoUnit.SECONDS));
        }
        catch (IOException e) {
            logger.error((Object)"[quarantine] hasFinish error", (Throwable)e);
            return false;
        }
    }
}

