/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.mservice.memory.StatusReceiver;
import kd.bos.mservice.memory.VMParams;
import kd.bos.util.JVMMemoryUsage;
import org.apache.log4j.Logger;

public class MemoryHealthMange {
    private static volatile long lastGcTime = 0L;
    private static Logger logger = Logger.getLogger(MemoryHealthMange.class);

    public static void recivedGcEvent() {
        lastGcTime = System.currentTimeMillis();
    }

    public static long getLastGcTime() {
        return lastGcTime;
    }

    public static boolean isMemoryUnhealth() {
        long maxMemory = VMParams.getXmxMB();
        long usedMemory = JVMMemoryUsage.getUsedMemory_MB();
        int memoryHighPercent = Integer.getInteger("fullgc.overload.recycle.percent", 92);
        int memoryAlarmPercent = Integer.getInteger("memory.alarm.threshold", 85);
        long usedMemoryPercent = 100L * usedMemory / maxMemory;
        if (usedMemoryPercent > (long)memoryHighPercent || usedMemoryPercent > (long)memoryAlarmPercent) {
            logger.info((Object)("[quarantine] used Memory is(MB) " + usedMemory));
            HashMap<Integer, WeakReference<byte[]>> holder = new HashMap<Integer, WeakReference<byte[]>>(2);
            long beginTime = System.currentTimeMillis();
            long leftMemory = (long)((double)(maxMemory - usedMemory) * 1.2);
            int i = 0;
            while ((long)i < leftMemory) {
                if (beginTime < lastGcTime || (long)i == leftMemory - 1L) {
                    boolean r;
                    AtomicInteger aiCount = new AtomicInteger(0);
                    holder.values().forEach(v -> {
                        if (v.get() != null) {
                            aiCount.incrementAndGet();
                        }
                    });
                    long acctMemoryUsage = JVMMemoryUsage.getUsedMemory_MB() - (long)aiCount.get();
                    boolean bl = r = 100L * acctMemoryUsage / maxMemory > (long)memoryHighPercent;
                    if (r) {
                        logger.info((Object)("[quarantine] acctMemoryUsage Memory overload,is (MB) " + acctMemoryUsage));
                    }
                    if (100L * acctMemoryUsage / maxMemory > (long)memoryAlarmPercent) {
                        StatusReceiver.memoryAlarm(maxMemory, usedMemory);
                    }
                    return r;
                }
                holder.put(i, new WeakReference<byte[]>(new byte[0x100000]));
                LockSupport.parkNanos(1000L);
                ++i;
            }
        }
        return false;
    }
}

