/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.mservice.memory.StatusNotify;
import kd.bos.mservice.memory.indicator.FullgcStatusIndicator;
import kd.bos.mservice.memory.indicator.OOMStatusIndicator;
import kd.bos.mservice.memory.indicator.OverMemoryUseStatusIndicator;
import kd.bos.mservice.memory.indicator.StatusIndicator;
import org.apache.log4j.Logger;

public class StatusChecker {
    private static final List<StatusIndicator> indicator = new ArrayList<StatusIndicator>(2);
    private static Logger logger = Logger.getLogger(StatusChecker.class);
    private static AtomicBoolean hasLogUnhealth = new AtomicBoolean(false);

    public static void check() {
        if (!Boolean.getBoolean("memory.checker.enable")) {
            return;
        }
        try {
            AtomicBoolean isUnHealth = new AtomicBoolean(false);
            indicator.forEach(v -> {
                if (v.isUnHealth()) {
                    if (hasLogUnhealth.compareAndSet(false, true)) {
                        logger.error((Object)("[quarantine] unhealthy:" + v.desc()));
                        EventDataReporter.report((EventType)v.getEventType(), (String)v.desc());
                    }
                    isUnHealth.set(true);
                    StatusNotify.getInstance().notifyUnhealth();
                }
            });
            if (!isUnHealth.get()) {
                StatusNotify.getInstance().notifyNormal();
            }
        }
        catch (Exception e) {
            logger.error((Object)"[quarantine]  statuscheck check error! ", (Throwable)e);
        }
    }

    static {
        try {
            indicator.add(new OOMStatusIndicator());
            indicator.add(new FullgcStatusIndicator());
            indicator.add(new OverMemoryUseStatusIndicator());
        }
        catch (Throwable e) {
            logger.error((Object)"[quarantine] add statuscheck error! ", e);
        }
    }
}

