/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import kd.bos.mservice.memory.NodeStatus;
import kd.bos.mservice.memory.StatusReceiver;
import kd.bos.mservice.memory.UnhealthAction;

public class StatusNotify {
    private NodeStatus status;
    private UnhealthAction action = new UnhealthAction();
    private static StatusNotify instance = new StatusNotify();

    public static StatusNotify getInstance() {
        return instance;
    }

    public synchronized void notifyNormal() {
        if (this.status == null) {
            this.status = NodeStatus.NORMAL;
        }
        this.innerRecieved();
    }

    public synchronized void notifyUnhealth() {
        if (this.status == null || this.status == NodeStatus.NORMAL) {
            this.status = NodeStatus.QUARANTINE;
            this.action.doAction(UnhealthAction.IsolateAction.PAUSED_ACTION);
            StatusReceiver.receive(this.status);
            this.action.doAction(UnhealthAction.IsolateAction.DUMP_ACTION);
        } else {
            this.innerRecieved();
        }
    }

    private void innerRecieved() {
        if (this.status == NodeStatus.QUARANTINE && this.action.canStop()) {
            this.status = NodeStatus.STOP;
        }
        StatusReceiver.receive(this.status);
    }
}

