/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.context.OperationContextCreator;
import kd.bos.instance.Instance;
import kd.bos.mservice.keepalive.LivingKeeperUtils;
import kd.bos.mservice.memory.NodeStatus;
import kd.bos.redis.JedisClient;
import kd.bos.util.NetAddressUtils;
import org.apache.log4j.Logger;

public class StatusReceiver {
    private static Logger logger = Logger.getLogger(StatusReceiver.class);
    private static final String NODESTATUS_PREFIX = "nodestatus-";
    private static final String INSTANCE_PREFIX = "instanceIdstatus-";
    private static final String alarmInstanceKey = "alarm-" + Instance.getInstanceId() + "@" + NetAddressUtils.getLocalIpAddress();
    private static final String instanceKey = "nodestatus-" + Instance.getInstanceId() + "@" + NetAddressUtils.getLocalIpAddress();
    private static volatile NodeStatus nodeStatus = NodeStatus.NORMAL;

    public static void receive(NodeStatus status) {
        nodeStatus = status;
        try (JedisClient jedisClient = LivingKeeperUtils.createNodeStatusJedisClient();){
            jedisClient.setex(instanceKey, (long)Integer.getInteger("bos.livingkeeper.period", 30).intValue() + 1L, status.name());
            jedisClient.setex(INSTANCE_PREFIX + Instance.getInstanceId(), (long)Integer.getInteger("bos.livingkeeper.period", 30).intValue() + 1L, status.name());
        }
        catch (Exception e) {
            OperationContextCreator.getOrCreateForBos();
            logger.error((Object)"[quarantine] StatusReceiver keep node alive error!", (Throwable)e);
        }
    }

    public static NodeStatus getStatus() {
        return nodeStatus;
    }

    public static NodeStatus getDistributeStatus(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        try (JedisClient jedisClient = LivingKeeperUtils.createNodeStatusJedisClient();){
            String status = jedisClient.get(INSTANCE_PREFIX + instanceId);
            NodeStatus nodeStatus = status == null ? null : NodeStatus.getType(status);
            return nodeStatus;
        }
    }

    public static void memoryAlarm(long max, long used) {
        try (JedisClient jedisClient = LivingKeeperUtils.createNodeStatusJedisClient();){
            SimpleDateFormat xAxisFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jedisClient.setex(alarmInstanceKey, (long)Integer.getInteger("memory.alarm.timeout", 28800).intValue() + 1L, "max: " + max + "MB,used: " + used + "MB at " + xAxisFormat.format(new Date()));
        }
    }

    public static String getAlarm() {
        try (JedisClient jedisClient = LivingKeeperUtils.createNodeStatusJedisClient();){
            String string = jedisClient.get(alarmInstanceKey);
            return string;
        }
    }
}

