/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.util.Set;
import kd.bos.instance.Instance;
import kd.bos.mservice.memory.DumpFileManage;
import kd.bos.mservice.memory.NodeStatus;
import kd.bos.mservice.memory.StatusReceiver;
import kd.bos.mservice.memory.VMParams;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.action.Action;
import kd.bos.mservice.monitor.action.ActionParam;
import kd.bos.mservice.monitor.action.impl.Dump;
import kd.bos.mservice.monitor.action.impl.Pause;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterNotifyHealthFactory;
import kd.bos.thread.OutOfMemoryObserver;
import org.apache.log4j.Logger;

public class UnhealthAction {
    private static Logger logger = Logger.getLogger(UnhealthAction.class);
    private String dumpingPath = null;
    private boolean canStop = false;
    private volatile long dumpAt = -1L;

    protected UnhealthAction() {
    }

    public boolean canStop() {
        if (this.canStop) {
            return true;
        }
        if (System.currentTimeMillis() - this.dumpAt > (long)(Integer.getInteger("dump.wait.minute", 5) * 60 * 1000)) {
            logger.warn((Object)("[quarantine] waiting over time for " + this.dumpingPath));
            this.canStop = true;
            return true;
        }
        if (this.dumpingPath == null) {
            return false;
        }
        boolean hasFinish = DumpFileManage.hasFinish(this.dumpingPath);
        if (hasFinish) {
            logger.info((Object)("[quarantine] dump has finished for " + this.dumpingPath));
            this.canStop = true;
        }
        return hasFinish;
    }

    public void doAction(IsolateAction quaratine) {
        ActionParam actionParam = new ActionParam().withIndicator("unHealthAction").withWaitSeconds(1).withDesc("unhealthy").withLevel(HealthLevel.ERROR.getLevel());
        if (quaratine == IsolateAction.PAUSED_ACTION) {
            String t = Boolean.TRUE.toString();
            if (t.equals(System.getProperty("memory.action.pause.enable", t))) {
                if (this.hasAnotherLive()) {
                    Action pause = new Pause().withParam(actionParam);
                    logger.warn((Object)"[quarantine] doAction: pause");
                    pause.execute();
                } else {
                    logger.warn((Object)"[quarantine] doAction: want to pause but no another application is live");
                }
            } else {
                logger.warn((Object)"[quarantine] doAction: want to pause but disabled by [memory.action.pause.enable]");
            }
        } else if (quaratine == IsolateAction.DUMP_ACTION) {
            if (this.dumpAt > 0L) {
                return;
            }
            this.dumpAt = System.currentTimeMillis();
            String _dumpPath = VMParams.getDumpPath();
            if (_dumpPath == null) {
                _dumpPath = System.getProperty("dump.path");
            }
            if (_dumpPath == null) {
                logger.warn((Object)"[quarantine] doAction: dump -- not config -XX:HeapDumpPath when dump the vm");
                this.canStop = true;
                return;
            }
            if (OutOfMemoryObserver.hasOOM() && VMParams.isIsHeapDumpOnOutOfMemeoryError()) {
                this.dumpingPath = DumpFileManage.getDumpFileIfExists(_dumpPath);
                if (this.dumpingPath == null) {
                    Dump dump = (Dump)new Dump().withParam(actionParam);
                    this.dumpingPath = dump.getDumpFullName();
                    logger.info((Object)("[quarantine] doAction: dump -- at " + this.dumpingPath));
                    dump.execute();
                } else {
                    logger.info((Object)("[quarantine] doAction: has dumped -- at " + this.dumpingPath));
                }
            } else {
                Dump dump = (Dump)new Dump().withParam(actionParam);
                this.dumpingPath = dump.getDumpFullName();
                logger.info((Object)("[quarantine] doAction: self dump -- at " + this.dumpingPath));
                dump.execute();
            }
        }
    }

    private boolean hasAnotherLive() {
        Set<String> instanceIds = ClusterNotifyHealthFactory.getNotifyer().getClusterAppIds();
        String appName = Instance.getAppName();
        String instanceId = Instance.getInstanceId();
        for (String remoteInstanceid : instanceIds) {
            String removeAppName = Instance.getAppNameFromInstanceId((String)remoteInstanceid);
            if (!appName.equals(removeAppName) || instanceId.equals(remoteInstanceid)) continue;
            NodeStatus status = StatusReceiver.getDistributeStatus(remoteInstanceid);
            if (status == NodeStatus.NORMAL) {
                logger.info((Object)("[quarantine] hasAnotherLive / remoteInstanceid: is Normal " + remoteInstanceid));
                return true;
            }
            logger.info((Object)("[quarantine] remoteInstanceid: is  " + (Object)((Object)status) + " , id is " + remoteInstanceid));
        }
        return false;
    }

    public static enum IsolateAction {
        PAUSED_ACTION,
        DUMP_ACTION;

    }
}

