/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.apache.log4j.Logger;

public class VMParams {
    private static long xmxMB;
    private static String dumpPath;
    private static boolean isHeapDumpOnOutOfMemeoryError;
    private static Logger logger;

    private static void init() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMxBean.getInputArguments();
        xmxMB = VMParams.parseXmxToMB(jvmArgs);
        for (String arg : jvmArgs) {
            if (arg.startsWith("-XX:HeapDumpPath")) {
                dumpPath = arg.substring("-XX:HeapDumpPath".length() + 1);
                continue;
            }
            if (!arg.equals("-XX:+HeapDumpOnOutOfMemoryError")) continue;
            isHeapDumpOnOutOfMemeoryError = true;
        }
    }

    public static long getXmxMB() {
        return xmxMB;
    }

    public static String getDumpPath() {
        return dumpPath;
    }

    public static boolean isIsHeapDumpOnOutOfMemeoryError() {
        return isHeapDumpOnOutOfMemeoryError;
    }

    private static long parseXmxToMB(List<String> jvmArgs) {
        for (String arg : jvmArgs) {
            if (!arg.startsWith("-Xmx")) continue;
            try {
                long xmxvalue = VMParams.parseXmxValue(arg);
                return xmxvalue;
            }
            catch (Exception e) {
                logger.error((Object)"[quarantine] parse xmx error", (Throwable)e);
            }
        }
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    private static long parseXmxValue(String xmxArg) {
        String valueStr = xmxArg.substring(4);
        String unit = valueStr.replaceAll("[0-9]", "");
        long value = Long.parseLong(valueStr.replaceAll("[^0-9]", ""));
        switch (unit.toUpperCase()) {
            case "K": 
            case "KB": {
                return value / 1024L;
            }
            case "M": 
            case "MB": {
                return value;
            }
            case "G": 
            case "GB": {
                return value * 1024L;
            }
            case "T": 
            case "TB": {
                return value * 1024L * 1024L;
            }
        }
        return value / 0x100000L;
    }

    static {
        isHeapDumpOnOutOfMemeoryError = false;
        logger = Logger.getLogger(VMParams.class);
        try {
            VMParams.init();
        }
        catch (Error | Exception e) {
            logger.error((Object)"[quarantine] VMParams init error", e);
        }
    }
}

