/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.memory.indicator;

import kd.bos.govern.eventdata.EventType;
import kd.bos.mservice.memory.MemoryHealthMange;
import kd.bos.mservice.memory.VMParams;
import kd.bos.mservice.memory.event.MemoryIsolateEvent;
import kd.bos.mservice.memory.indicator.StatusIndicator;
import kd.bos.mservice.monitor.assistant.ThreadStackUtils;
import kd.bos.util.JVMMemoryUsage;

public class OverMemoryUseStatusIndicator
implements StatusIndicator {
    private volatile boolean lasted = false;

    @Override
    public boolean isUnHealth() {
        if (Boolean.getBoolean("memory.overload.disable")) {
            return false;
        }
        boolean r = MemoryHealthMange.isMemoryUnhealth();
        if (Boolean.getBoolean("memory.overload.once")) {
            return r;
        }
        if (this.lasted && r) {
            return true;
        }
        this.lasted = r;
        return false;
    }

    @Override
    public String desc() {
        return "OverMemoryUseStatusIndicator : max is " + VMParams.getXmxMB() + "MB, used is " + JVMMemoryUsage.getUsedMemory_MB() + ",stack : " + ThreadStackUtils.getFormatStack(Thread.getAllStackTraces());
    }

    @Override
    public EventType getEventType() {
        return MemoryIsolateEvent.MemoryOverloadIsolateEvent.getInstance();
    }
}

