/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.util.ExceptionUtils;

public class LimitQueue<E> {
    private int limit;
    private LinkedList<E> queue = new LinkedList();

    public LimitQueue(int limit) {
        this.limit = limit;
    }

    public void offer(E e) {
        if (this.queue.size() >= this.limit) {
            this.queue.poll();
        }
        this.queue.offer(e);
    }

    public E poll() {
        return this.queue.poll();
    }

    public E get(int position) {
        return this.queue.get(position);
    }

    public E getLast() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.getLast();
    }

    public E getFirst() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.getFirst();
    }

    public int getLimit() {
        return this.limit;
    }

    public int size() {
        return this.queue.size();
    }

    public List<E> getAll() {
        ArrayList<E> ls = new ArrayList<E>(4);
        for (int i = 0; i < this.queue.size(); ++i) {
            try {
                ls.add(this.queue.get(i));
                continue;
            }
            catch (Exception e) {
                ExceptionUtils.parseException((Throwable)e);
            }
        }
        return ls;
    }

    public static void main(String[] args) {
        int i;
        LimitQueue<Integer> q = new LimitQueue<Integer>(18);
        for (i = 0; i < 18; ++i) {
            q.offer(i);
        }
        for (i = 0; i < q.size(); ++i) {
        }
        q.get(q.size() - 1);
    }
}

