/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.action;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.indicator.FullGCStatics;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.report.HealthReporter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class NodeAction {
    private static Log log = LogFactory.getLog(NodeAction.class);
    private static Map<String, AtomicBoolean> hasNotifiedIndicator = new ConcurrentHashMap<String, AtomicBoolean>(2);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"notifyActionForHealthError\u20141", (int)1);
    private static final long FULLGC_TIME_INTERVAL = Integer.getInteger("fullgc.overload.timeInterval", 300000).intValue();

    public static void notifyAction(Set<String> healthErrorIndicatorSet) {
        pool.execute(() -> {
            if (!Boolean.getBoolean("health.action.enable")) {
                return;
            }
            Map<String, Indicator> indicatorsMap = IndicatorChain.getInstance().getIndicators();
            ArrayList allActions = new ArrayList(2);
            healthErrorIndicatorSet.forEach(indicatorName -> {
                AtomicBoolean nofityed = hasNotifiedIndicator.computeIfAbsent((String)indicatorName, k -> new AtomicBoolean(false));
                if (nofityed.compareAndSet(false, true)) {
                    Indicator indicator = (Indicator)indicatorsMap.get(indicatorName);
                    allActions.addAll(indicator.actionsWhenExceptions());
                    return;
                }
            });
            if (allActions.size() > 0) {
                allActions.forEach(action -> {
                    action.execute();
                    HealthReporter.getInstance().reportAction(action.getClass().getSimpleName(), action.getParam());
                });
            }
        });
    }

    public static void performFullGc() {
        FullGCStatics fullGcStatics = new FullGCStatics();
        long lastGcTime = fullGcStatics.getLastFullGCTime();
        if (lastGcTime > FULLGC_TIME_INTERVAL) {
            System.gc();
            log.warn("nodehealthwarn: The node memory is overloaded, actively executes fullGC at " + System.currentTimeMillis() + " by thread " + Thread.currentThread().getName());
        }
    }
}

