/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.action.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.memory.DumpFileManage;
import kd.bos.mservice.monitor.action.AbstractAction;
import kd.bos.mservice.monitor.action.impl.ServiceUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.EnvUtils;

public class Dump
extends AbstractAction {
    private static final String MAGIC = "/";
    public static final String DUMPPATH_KEY = "dump.path";
    private static final String dumpPath = ConfigurationUtil.getString((String)"dump.path", (String)DumpFileManage.getDumpPath());
    private static final String javaHome = ConfigurationUtil.getString((String)"JAVA_HOME");
    private static Log logger = LogFactory.getLog(Dump.class);
    private String dumpFullName;

    public Dump() {
        StringBuilder sb = new StringBuilder();
        sb.append(dumpPath).append(dumpPath.endsWith(MAGIC) ? "" : File.separator);
        try {
            Files.createDirectories(Paths.get(sb.toString(), new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            logger.error("create dir error ", (Throwable)e);
        }
        sb.append(ServiceUtil.getDateTime()).append("-").append(Instance.getInstanceId()).append("-").append(new SecureRandom().nextInt(1000)).append(".hprof");
        this.dumpFullName = sb.toString();
    }

    @Override
    public void execute() {
        if (javaHome == null) {
            ServiceUtil.warn("please set JAVA_HOME ");
            return;
        }
        StringBuilder sb = new StringBuilder(javaHome);
        sb.append(javaHome.endsWith(MAGIC) ? "" : MAGIC);
        sb.append("bin/jmap -dump:live,format=b,file=");
        sb.append(this.dumpFullName).append(" ").append(EnvUtils.getPid());
        try {
            Runtime.getRuntime().exec(sb.toString());
            if (this.param.getWaitSeconds() > 0) {
                LockSupport.parkNanos((long)this.param.getWaitSeconds() * 1000000000L);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public String getDumpFullName() {
        return this.dumpFullName;
    }
}

