/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.assistant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.monitor.assistant.AssistDiagnose;
import kd.bos.mservice.monitor.assistant.BackendThreadStackAssistDiagnose;
import kd.bos.mservice.monitor.assistant.DBActionConnectionAssistDiagnose;
import kd.bos.mservice.monitor.assistant.FullGCAssistDiagnose;
import kd.bos.mservice.monitor.assistant.OOMStackAssistDiagnose;
import kd.bos.mservice.monitor.assistant.RedisAssistDiagnose;
import kd.bos.mservice.monitor.assistant.StackAssistDiagnose;
import kd.bos.mservice.monitor.assistant.TopThreadAssistDiagnose;

public class AssistDiagnoseFactory {
    private static Map<String, AssistDiagnose<?>> allAssistsMap = new ConcurrentHashMap(2);

    public static AssistDiagnose<?> getType(String type) {
        return allAssistsMap.computeIfAbsent(type, t -> {
            if ("stack".equals(type)) {
                return new StackAssistDiagnose();
            }
            if ("topthread".equals(type)) {
                return new TopThreadAssistDiagnose();
            }
            if ("oomstack".equals(type)) {
                return new OOMStackAssistDiagnose();
            }
            if ("backendthreadstack".equals(type)) {
                return new BackendThreadStackAssistDiagnose();
            }
            if ("dbactiveconnection".equals(type)) {
                return new DBActionConnectionAssistDiagnose();
            }
            if ("redisAssist".equals(type)) {
                return RedisAssistDiagnose.getInstance();
            }
            if ("fullgcinfo".equals(type)) {
                return FullGCAssistDiagnose.getInstance();
            }
            return null;
        });
    }
}

