/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.assistant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.monitor.assistant.AssistDiagnose;
import kd.bos.mservice.monitor.assistant.ThreadStackUtils;
import kd.bos.thread.RunningThreadManage;

public class BackendThreadStackAssistDiagnose
implements AssistDiagnose<String> {
    long lastGetTimestamp = -1L;

    @Override
    public String getAssistantInfo() {
        Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
        Set ids = RunningThreadManage.getRunningThreadIds();
        HashMap<Thread, StackTraceElement[]> backendThreadMap = new HashMap<Thread, StackTraceElement[]>(8);
        this.lastGetTimestamp = System.currentTimeMillis();
        m.forEach((t, s) -> {
            if (ids.contains(t.getId())) {
                backendThreadMap.put((Thread)t, (StackTraceElement[])s);
            }
        });
        return ThreadStackUtils.getFormatStack(backendThreadMap);
    }

    @Override
    public boolean requireOutPermit() {
        if (this.lastGetTimestamp == -1L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastGetTimestamp >= 120000L;
    }
}

