/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.assistant;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;

public class ThreadStackUtils {
    private static final String TIME_STR = "/time:";
    private static final AtomicInteger aicout = new AtomicInteger(10000);

    public static String getFormatStack(Map<Thread, StackTraceElement[]> m) {
        ArrayList<IThreadInfo> threads = new ArrayList<IThreadInfo>();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        m.forEach((t, stes) -> {
            String threadName = t.getName();
            IThreadInfo threadInfo = new IThreadInfo(threadName, (StackTraceElement[])stes, (Thread)t);
            String threadTraceStatistic = TraceStatistics.getThreadTraceStatistic((Thread)t);
            if (threadTraceStatistic.length() > 0) {
                threadInfo.threadTraceStatistic = threadTraceStatistic.replaceAll("&nbsp;", "").replaceAll("<br>", "\r\n");
            }
            threads.add(threadInfo);
            Map map = TracerImpl.getInstrumentMap((Thread)t);
            if (map != null) {
                map.forEach((k, v) -> {
                    cal.setTimeInMillis((long)v);
                    threadInfo.memspanStr.append(String.format(LangRes.healthmanage.getString("ThreadStackUtils_2", "\t[Current Method] Start time: %1$s, Executed: %2$s milliseconds, Executing method: %3$s.%4$s,", new Object[0]), formatter.format(cal.getTime()), System.currentTimeMillis() - v, k.getType(), k.getName()));
                    Map tags = k.tags();
                    threadInfo.memspanStr.append("\r\n");
                    if (tags != null) {
                        tags.forEach((tk, tv) -> {
                            if (!"service".equals(tk) && !"remoteUrl".equals(tk)) {
                                threadInfo.memspanStr.append("\t\t\t").append("[ ").append((String)tk).append(" ]: ").append((String)tv).append("\r\n");
                            }
                        });
                    }
                });
            }
        });
        List<IThreadInfo> sortedThreads = ThreadStackUtils.sort(threads);
        return ThreadStackUtils.toDisplay(sortedThreads);
    }

    private static String toDisplay(List<IThreadInfo> threads) {
        StringBuilder out = new StringBuilder();
        int threadIndex = 0;
        HashMap<String, String> steCache = new HashMap<String, String>(2);
        for (IThreadInfo t : threads) {
            String _threadName = t.threadname;
            StackTraceElement[] stes = t.stes;
            int pos = _threadName.indexOf(TIME_STR);
            StringBuilder sb = new StringBuilder();
            out.append("").append(++threadIndex).append("_[").append(_threadName).append("]\r\n");
            if (pos > 0) {
                try {
                    long time = Long.parseLong(_threadName.substring(pos + TIME_STR.length(), pos + 13 + TIME_STR.length()));
                    long now = System.currentTimeMillis();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(time);
                    sb.append(String.format(LangRes.healthmanage.getString("ThreadStackUtils_1", "[Current Thread] Start time: %1$s, Elapsed time: %2$s milliseconds", new Object[0]), formatter.format(cal.getTime()), now - time));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (sb.length() > 0) {
                out.append("\t");
                out.append((CharSequence)sb);
                out.append("\r\n");
            }
            if (t.memspanStr.length() > 0) {
                out.append((CharSequence)t.memspanStr);
            }
            if (pos > 0 && t.threadTraceStatistic != null && t.threadTraceStatistic.length() > 0) {
                out.append("\t[").append(LangRes.healthmanage.getString("ThreadStackUtils_3", "Thread statistics", new Object[0])).append("]\r\n");
                out.append(t.threadTraceStatistic);
            }
            out.append("\t[").append(LangRes.healthmanage.getString("ThreadStackUtils_4", "Thread stack trace", new Object[0])).append("]\r\n");
            out.append(ThreadStackUtils.getSteString(stes, steCache));
            out.append("\r\n");
        }
        return out.toString();
    }

    private static Object getSteString(StackTraceElement[] stes, Map<String, String> steCache) {
        StringBuilder out = new StringBuilder();
        for (StackTraceElement ste : stes) {
            out.append("\t\tat  \t").append(ste).append("\r\n");
        }
        String outstr = out.toString();
        String stacktraceIdenfy = steCache.get(outstr);
        if (stacktraceIdenfy == null) {
            stacktraceIdenfy = "stacktrace#" + aicout.incrementAndGet();
            steCache.put(outstr, stacktraceIdenfy);
            return stacktraceIdenfy + ":\r\n" + outstr;
        }
        return "\r\n ref->" + stacktraceIdenfy + "\r\n";
    }

    private static List<IThreadInfo> sort(List<IThreadInfo> threads) {
        IThreadInfo[] preSortThreads = threads.toArray(new IThreadInfo[0]);
        int size = preSortThreads.length;
        for (int i = 0; i < size; ++i) {
            for (int j = 1; j < size - i; ++j) {
                IThreadInfo threadIf1 = preSortThreads[j - 1];
                IThreadInfo threadIf2 = preSortThreads[j];
                String preName = threadIf1.threadname;
                String sufName = threadIf2.threadname;
                int prePos = preName.indexOf(TIME_STR);
                int sufPos = sufName.indexOf(TIME_STR);
                if (prePos < 0 && sufPos > 0) {
                    IThreadInfo temp = preSortThreads[j - 1];
                    preSortThreads[j - 1] = preSortThreads[j];
                    preSortThreads[j] = temp;
                    continue;
                }
                if (prePos <= 0 || sufPos <= 0) continue;
                try {
                    long l1 = Long.parseLong(preName.substring(prePos + TIME_STR.length()));
                    long l2 = Long.parseLong(sufName.substring(sufPos + TIME_STR.length()));
                    if (l1 <= l2) continue;
                    IThreadInfo temp = preSortThreads[j - 1];
                    preSortThreads[j - 1] = preSortThreads[j];
                    preSortThreads[j] = temp;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return Arrays.asList(preSortThreads);
    }

    /*
     * Exception decompiling
     */
    public static String getEStackTrace(Throwable ex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class IThreadInfo {
        protected final String threadname;
        protected final StackTraceElement[] stes;
        protected final Thread thread;
        protected StringBuilder memspanStr = new StringBuilder();
        protected String threadTraceStatistic = "";

        IThreadInfo(String threadname, StackTraceElement[] stes, Thread thread) {
            this.threadname = threadname;
            this.stes = stes;
            this.thread = thread;
        }
    }
}

